/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;
import java.util.List;

public class FunctionType
extends Type
implements Cloneable {
    private final Type returnType;
    private ArrayList<Type> argumentTypes;
    private ArrayList<String> argumentNames;

    public FunctionType(String string, SizeThunk sizeThunk, Type type, int n) {
        this(string, sizeThunk, type, n, null);
    }

    public FunctionType(String string, SizeThunk sizeThunk, Type type, int n, ASTLocusTag aSTLocusTag) {
        super(string, sizeThunk, n, aSTLocusTag);
        this.returnType = type;
    }

    private FunctionType(FunctionType functionType, ASTLocusTag aSTLocusTag) {
        super(functionType, functionType.getCVAttributes(), aSTLocusTag);
        this.returnType = functionType.returnType;
        if (null != functionType.argumentTypes) {
            this.argumentTypes = new ArrayList<Type>(functionType.argumentTypes);
        }
        if (null != functionType.argumentNames) {
            this.argumentNames = new ArrayList<String>(functionType.argumentNames);
        }
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        if (bl) {
            return this;
        }
        return new FunctionType(this, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        int n = this.returnType.hashCode();
        return (n << 5) - n + TypeComparator.listsHashCode(this.argumentTypes);
    }

    @Override
    protected boolean equalsImpl(Type type) {
        FunctionType functionType = (FunctionType)type;
        return this.returnType.equals(functionType.returnType) && TypeComparator.listsEqual(this.argumentTypes, functionType.argumentTypes);
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        int n = this.returnType.hashCodeSemantics();
        return (n << 5) - n + TypeComparator.listsHashCodeSemantics(this.argumentTypes);
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        FunctionType functionType = (FunctionType)type;
        return this.returnType.equalSemantics(functionType.returnType) && TypeComparator.listsEqualSemantics(this.argumentTypes, functionType.argumentTypes);
    }

    @Override
    public FunctionType asFunction() {
        return this;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int getNumArguments() {
        return this.argumentTypes == null ? 0 : this.argumentTypes.size();
    }

    public String getArgumentName(int n) {
        return this.argumentNames.get(n);
    }

    public Type getArgumentType(int n) {
        return this.argumentTypes.get(n);
    }

    public StringBuilder getParameterList(StringBuilder stringBuilder, boolean bl, String string) {
        return this.getParameterList(stringBuilder, bl, string, null);
    }

    public StringBuilder getParameterList(StringBuilder stringBuilder, boolean bl, String string, List<Integer> list) {
        this.forEachParameter((n, n2, type, string2) -> {
            if (!(type.isVoid() || null != list && list.contains(n))) {
                if (0 < n2) {
                    stringBuilder.append(", ");
                }
                if (bl && type.isTypedef()) {
                    stringBuilder.append(type.getName());
                    if (string2 != null) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string2);
                    }
                } else if (type.isFunctionPointer()) {
                    FunctionType functionType = type.getTargetFunction();
                    stringBuilder.append(functionType.toString(string2, string, false, true));
                } else if (type.isArray()) {
                    stringBuilder.append(type.asArray().toString(string2));
                } else {
                    stringBuilder.append(type.getCName(true));
                    if (string2 != null) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string2);
                    }
                }
                return true;
            }
            return false;
        });
        return stringBuilder;
    }

    public int forEachParameter(ParameterConsumer parameterConsumer) {
        int n = this.getNumArguments();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!parameterConsumer.accept(i, n2, this.getArgumentType(i), this.getArgumentName(i))) continue;
            ++n2;
        }
        return n2;
    }

    public void addArgument(Type type, String string) {
        if (this.argumentTypes == null) {
            this.argumentTypes = new ArrayList();
            this.argumentNames = new ArrayList();
        }
        this.argumentTypes.add(type);
        this.argumentNames.add(string);
        this.clearCache();
    }

    public void setArgumentName(int n, String string) {
        this.argumentNames.set(n, string);
        this.clearCache();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public String toString(String string, boolean bl) {
        return this.toString(string, null, bl, false);
    }

    public String toString(String string, boolean bl, boolean bl2) {
        return this.toString(string, null, bl, bl2);
    }

    public String toString(String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getReturnType().getCName(true));
        stringBuilder.append(" ");
        if (bl2) {
            stringBuilder.append("(");
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append("*");
        }
        if (string != null) {
            if (bl) {
                stringBuilder.append("{@native ");
            }
            stringBuilder.append(string);
            if (bl) {
                stringBuilder.append("}");
            }
        }
        if (bl2) {
            stringBuilder.append(")");
        }
        stringBuilder.append("(");
        this.getParameterList(stringBuilder, true, string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.returnType.visit(typeVisitor);
        int n = this.getNumArguments();
        for (int i = 0; i < n; ++i) {
            this.getArgumentType(i).visit(typeVisitor);
        }
    }

    public static interface ParameterConsumer {
        public boolean accept(int var1, int var2, Type var3, String var4);
    }
}

