/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.TypeConfig;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.BitType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.DoubleType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.FloatType;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import com.jogamp.gluegen.cgram.types.VoidType;

public abstract class Type
implements TypeComparator.SemanticEqualityOp,
ASTLocusTag.ASTLocusTagProvider {
    public final boolean relaxedEqSem;
    private final int cvAttributes;
    final ASTLocusTag astLocus;
    private String name;
    private SizeThunk size;
    private int typedefCVAttributes;
    private boolean isTypedef;
    private boolean hasCachedHash;
    private int cachedHash;
    private boolean hasCachedSemanticHash;
    private int cachedSemanticHash;

    protected Type(String string, SizeThunk sizeThunk, int n, ASTLocusTag aSTLocusTag) {
        this.setName(string);
        this.relaxedEqSem = TypeConfig.relaxedEqualSemanticsTest();
        this.cvAttributes = n;
        this.astLocus = aSTLocusTag;
        this.size = sizeThunk;
        this.typedefCVAttributes = 0;
        this.isTypedef = false;
    }

    Type(Type type, int n, ASTLocusTag aSTLocusTag) {
        this.relaxedEqSem = type.relaxedEqSem;
        this.cvAttributes = n;
        this.astLocus = aSTLocusTag;
        this.name = type.name;
        this.size = type.size;
        this.typedefCVAttributes = type.typedefCVAttributes;
        this.isTypedef = type.isTypedef;
        this.clearCache();
    }

    protected final void clearCache() {
        this.hasCachedHash = false;
        this.cachedHash = 0;
        this.hasCachedSemanticHash = false;
        this.cachedSemanticHash = 0;
    }

    public final Type newCVVariant(int n) {
        if (this.cvAttributes == n) {
            return this;
        }
        return this.newVariantImpl(true, n, this.astLocus);
    }

    public Type clone(ASTLocusTag aSTLocusTag) {
        return this.newVariantImpl(true, this.cvAttributes, aSTLocusTag);
    }

    abstract Type newVariantImpl(boolean var1, int var2, ASTLocusTag var3);

    @Override
    public final ASTLocusTag getASTLocusTag() {
        return this.astLocus;
    }

    public boolean isAnon() {
        return null == this.name;
    }

    public final String getCName() {
        return this.getCName(false);
    }

    public String getCName(boolean bl) {
        return this.getName(bl);
    }

    public final String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (!bl) {
            return this.name;
        }
        return this.getCVAttributesString() + this.name;
    }

    public String toString() {
        return this.getCName(true);
    }

    private static StringBuilder append(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
        return stringBuilder;
    }

    public final StringBuilder getSignature(StringBuilder stringBuilder) {
        Type type;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        stringBuilder.append("(").append(this.getClass().getSimpleName()).append(") ");
        if (this.isTypedef()) {
            stringBuilder.append("typedef ");
        }
        if (null != this.name) {
            stringBuilder.append("'").append(this.name).append("'");
        } else {
            stringBuilder.append("ANON");
        }
        if (this.isFunctionPointer()) {
            stringBuilder.append(" -> ");
            type = this.getTargetFunction();
            stringBuilder.append(((FunctionType)type).toString(null, null, false, true));
        } else {
            type = this.getTargetType();
            if (null != type && this != type) {
                stringBuilder.append(" -> ");
                stringBuilder.append("(" + type.toString() + ") * " + this.getCVAttributesString());
            }
        }
        if (GlueGen.debug()) {
            stringBuilder.append(", o=0x" + Integer.toHexString(this.objHash()));
        }
        stringBuilder.append(", size");
        bl = true;
        if (null != this.size) {
            long l = -1L;
            try {
                l = this.size.computeSize(MachineDataInfo.StaticConfig.LP64_UNIX.md);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l2 = l;
            stringBuilder.append("[fixed ").append(this.size.hasFixedNativeSize()).append(", lnx64 ").append(l2).append("]");
        } else {
            stringBuilder.append(" ZERO");
        }
        Type.append(stringBuilder, "const[", bl);
        bl = false;
        if (this.isConstTypedef()) {
            Type.append(stringBuilder, "typedef", bl);
            bl = true;
        }
        if (this.isConstRaw()) {
            Type.append(stringBuilder, "native", bl);
            bl = true;
        }
        if (this.isConst()) {
            Type.append(stringBuilder, "true]", bl);
        } else {
            Type.append(stringBuilder, "false]", bl);
        }
        bl = true;
        Type.append(stringBuilder, "is[", bl);
        bl = false;
        if (this.isVolatile()) {
            Type.append(stringBuilder, "volatile ", bl);
            bl = true;
        }
        if (this.isPrimitive()) {
            Type.append(stringBuilder, "primitive", bl);
            bl = true;
        }
        if (this.isPointer()) {
            Type.append(stringBuilder, "pointer*" + this.pointerDepth(), bl);
            bl = true;
        }
        if (this.isArray()) {
            Type.append(stringBuilder, "array*" + this.arrayDimension(), bl);
            bl = true;
        }
        if (this.isBit()) {
            Type.append(stringBuilder, "bit", bl);
            bl = true;
        }
        if (this.isCompound()) {
            Type.append(stringBuilder, "struct{", bl).append(this.asCompound().getStructName()).append(": ").append(this.asCompound().getNumFields());
            Type.append(stringBuilder, "}", bl);
            bl = true;
        }
        if (this.isDouble()) {
            Type.append(stringBuilder, "double", bl);
            bl = true;
        }
        if (this.isEnum()) {
            EnumType enumType = this.asEnum();
            Type.append(stringBuilder, "enum ", bl).append(" [").append(enumType.getUnderlyingType()).append("] {").append(enumType.getNumEnumerates()).append(": ");
            enumType.appendEnums(stringBuilder, false);
            bl = true;
        }
        if (this.isFloat()) {
            Type.append(stringBuilder, "float", bl);
            bl = true;
        }
        if (this.isFunction()) {
            Type.append(stringBuilder, "function", bl);
            bl = true;
        }
        if (this.isFunctionPointer()) {
            Type.append(stringBuilder, "funcPointer", bl);
            bl = true;
        }
        if (this.isInt()) {
            Type.append(stringBuilder, "int", bl);
            bl = true;
        }
        if (this.isVoid()) {
            Type.append(stringBuilder, "void", bl);
            bl = true;
        }
        Type.append(stringBuilder, "]", false);
        bl = true;
        return stringBuilder;
    }

    public final String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CType[");
        this.getSignature(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private final int objHash() {
        return super.hashCode();
    }

    private final boolean setName(String string) {
        this.clearCache();
        if (null == string || 0 == string.length()) {
            this.name = string;
            return false;
        }
        this.name = string.intern();
        return true;
    }

    public boolean setTypedefName(String string) {
        if (this.setName(string)) {
            this.typedefCVAttributes = this.cvAttributes;
            this.isTypedef = true;
            return true;
        }
        return false;
    }

    final void setTypedef(int n) {
        this.name = this.name.intern();
        this.typedefCVAttributes = n;
        this.isTypedef = true;
        this.clearCache();
    }

    final int getTypedefCVAttributes() {
        return this.typedefCVAttributes;
    }

    public final boolean isTypedef() {
        return this.isTypedef;
    }

    public final boolean hasSize() {
        return null != this.size;
    }

    public final SizeThunk getSize() {
        return this.size;
    }

    public final long getSize(MachineDataInfo machineDataInfo) {
        SizeThunk sizeThunk = this.getSize();
        if (sizeThunk == null) {
            throw new RuntimeException("No size set for type \"" + this.getName() + "\"");
        }
        return sizeThunk.computeSize(machineDataInfo);
    }

    final void setSize(SizeThunk sizeThunk) {
        this.size = sizeThunk;
        this.clearCache();
    }

    public BitType asBit() {
        return null;
    }

    public IntType asInt() {
        return null;
    }

    public EnumType asEnum() {
        return null;
    }

    public FloatType asFloat() {
        return null;
    }

    public DoubleType asDouble() {
        return null;
    }

    public PointerType asPointer() {
        return null;
    }

    public ArrayType asArray() {
        return null;
    }

    public CompoundType asCompound() {
        return null;
    }

    public FunctionType asFunction() {
        return null;
    }

    public VoidType asVoid() {
        return null;
    }

    public final boolean isBit() {
        return this.asBit() != null;
    }

    public final boolean isInt() {
        return this.asInt() != null;
    }

    public final boolean isEnum() {
        return this.asEnum() != null;
    }

    public final boolean isFloat() {
        return this.asFloat() != null;
    }

    public final boolean isDouble() {
        return this.asDouble() != null;
    }

    public final boolean isPointer() {
        return this.asPointer() != null;
    }

    public final boolean isArray() {
        return this.asArray() != null;
    }

    public final boolean isCompound() {
        return this.asCompound() != null;
    }

    public final boolean isFunction() {
        return this.asFunction() != null;
    }

    public final boolean isVoid() {
        return this.asVoid() != null;
    }

    public final boolean isVolatile() {
        return 0 != (this.cvAttributes & ~this.typedefCVAttributes & 2);
    }

    public final boolean isConst() {
        return 0 != (this.cvAttributes & ~this.typedefCVAttributes & 1);
    }

    private final boolean isConstTypedef() {
        return 0 != (this.typedefCVAttributes & 1);
    }

    private final boolean isConstRaw() {
        return 0 != (this.cvAttributes & 1);
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isFunctionPointer() {
        return false;
    }

    public final boolean isBaseTypeConst() {
        return this.getBaseType().isConst();
    }

    public final int hashCode() {
        if (!this.hasCachedHash) {
            int n = 31 + (this.isTypedef ? 1 : 0);
            n = (n << 5) - n + (null != this.size ? this.size.hashCode() : 0);
            n = (n << 5) - n + this.cvAttributes;
            n = (n << 5) - n + this.typedefCVAttributes;
            n = (n << 5) - n + (null != this.name ? this.name.hashCode() : 0);
            if (!this.isTypedef) {
                n = (n << 5) - n + this.hashCodeImpl();
            }
            this.cachedHash = n;
            this.hasCachedHash = true;
        }
        return this.cachedHash;
    }

    protected abstract int hashCodeImpl();

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        Type type = (Type)object;
        if (this.isTypedef == type.isTypedef && (null != this.size && this.size.equals(type.size) || null == this.size && null == type.size) && this.cvAttributes == type.cvAttributes && this.typedefCVAttributes == type.typedefCVAttributes && (null == this.name ? null == type.name : this.name.equals(type.name))) {
            if (!this.isTypedef) {
                return this.equalsImpl(type);
            }
            return true;
        }
        return false;
    }

    protected abstract boolean equalsImpl(Type var1);

    @Override
    public final int hashCodeSemantics() {
        if (!this.hasCachedSemanticHash) {
            int n = 31 + (null != this.size ? this.size.hashCodeSemantics() : 0);
            if (!this.relaxedEqSem) {
                n = (n << 5) - n + this.cvAttributes;
                n = (n << 5) - n + this.typedefCVAttributes;
            }
            this.cachedSemanticHash = n = (n << 5) - n + this.hashCodeSemanticsImpl();
            this.hasCachedSemanticHash = true;
        }
        return this.cachedSemanticHash;
    }

    protected abstract int hashCodeSemanticsImpl();

    @Override
    public final boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
        if (semanticEqualityOp == this) {
            return true;
        }
        if (!(semanticEqualityOp instanceof Type) || !this.getClass().isInstance(semanticEqualityOp)) {
            return false;
        }
        Type type = (Type)semanticEqualityOp;
        if ((null != this.size && this.size.equalSemantics(type.size) || null == this.size && null == type.size) && (this.relaxedEqSem || this.cvAttributes == type.cvAttributes && this.typedefCVAttributes == type.typedefCVAttributes)) {
            return this.equalSemanticsImpl(type);
        }
        return false;
    }

    protected abstract boolean equalSemanticsImpl(Type var1);

    public void visit(TypeVisitor typeVisitor) {
        typeVisitor.visitType(this);
    }

    public final int getCVAttributes() {
        return this.cvAttributes;
    }

    public final String getCVAttributesString() {
        if (this.isConst() && this.isVolatile()) {
            return "const volatile ";
        }
        if (this.isConst()) {
            return "const ";
        }
        if (this.isVolatile()) {
            return "volatile ";
        }
        return "";
    }

    public int pointerDepth() {
        return 0;
    }

    public int arrayDimension() {
        return 0;
    }

    public Type getBaseType() {
        return this;
    }

    public Type getTargetType() {
        return this;
    }

    public Type getArrayBaseOrPointerTargetType() {
        return this;
    }

    public FunctionType getTargetFunction() {
        return null;
    }
}

