/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.Feature;
import com.jogamp.gluegen.jcpp.JoinReader;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.NumericValue;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.Token;
import com.jogamp.gluegen.jcpp.TokenType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;

public class LexerSource
extends Source {
    private static final boolean DEBUG = false;
    private JoinReader reader;
    private final boolean ppvalid;
    private boolean bol;
    private boolean include;
    private boolean digraphs;
    private int u0;
    private int u1;
    private int ucount;
    private int line;
    private int column;
    private int lastcolumn;
    private boolean cr;

    @Nonnull
    protected static BufferedReader toBufferedReader(@Nonnull Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public LexerSource(Reader reader, boolean bl) {
        this.reader = new JoinReader(reader);
        this.ppvalid = bl;
        this.bol = true;
        this.include = false;
        this.digraphs = true;
        this.ucount = 0;
        this.line = 1;
        this.column = 0;
        this.lastcolumn = -1;
        this.cr = false;
    }

    @Override
    void init(Preprocessor preprocessor) {
        super.init(preprocessor);
        this.digraphs = preprocessor.getFeature(Feature.DIGRAPHS);
        this.reader.init(preprocessor, this);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    boolean isNumbered() {
        return true;
    }

    private void _error(String string, boolean bl) throws LexerException {
        int n = this.line;
        int n2 = this.column;
        if (n2 == 0) {
            n2 = this.lastcolumn;
            --n;
        } else {
            --n2;
        }
        if (bl) {
            super.error(n, n2, string);
        } else {
            super.warning(n, n2, string);
        }
    }

    final void error(String string) throws LexerException {
        this._error(string, true);
    }

    final void warning(String string) throws LexerException {
        this._error(string, false);
    }

    void setInclude(boolean bl) {
        this.include = bl;
    }

    private static boolean isLineSeparator(int n) {
        switch ((char)n) {
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return n == -1;
    }

    private int read() throws IOException, LexerException {
        int n;
        assert (this.ucount <= 2) : "Illegal ucount: " + this.ucount;
        switch (this.ucount) {
            case 2: {
                this.ucount = 1;
                n = this.u1;
                break;
            }
            case 1: {
                this.ucount = 0;
                n = this.u0;
                break;
            }
            default: {
                n = this.reader == null ? -1 : this.reader.read();
            }
        }
        switch (n) {
            case 13: {
                this.cr = true;
                ++this.line;
                this.lastcolumn = this.column;
                this.column = 0;
                break;
            }
            case 10: {
                if (this.cr) {
                    this.cr = false;
                    break;
                }
            }
            case 11: 
            case 12: 
            case 133: 
            case 8232: 
            case 8233: {
                this.cr = false;
                ++this.line;
                this.lastcolumn = this.column;
                this.column = 0;
                break;
            }
            case -1: {
                this.cr = false;
                break;
            }
            default: {
                this.cr = false;
                ++this.column;
            }
        }
        return n;
    }

    private void unread(int n) throws IOException {
        if (n != -1) {
            if (LexerSource.isLineSeparator(n)) {
                --this.line;
                this.column = this.lastcolumn;
                this.cr = false;
            } else {
                --this.column;
            }
            switch (this.ucount) {
                case 0: {
                    this.u0 = n;
                    this.ucount = 1;
                    break;
                }
                case 1: {
                    this.u1 = n;
                    this.ucount = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot unget another character!");
                }
            }
        }
    }

    @Nonnull
    private Token invalid(StringBuilder stringBuilder, String string) throws IOException, LexerException {
        int n = this.read();
        while (!LexerSource.isLineSeparator(n)) {
            stringBuilder.append((char)n);
            n = this.read();
        }
        this.unread(n);
        return new Token(300, stringBuilder.toString(), string);
    }

    @Nonnull
    private Token ccomment() throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder("/*");
        while (true) {
            int n;
            if ((n = this.read()) == -1) {
                return new Token(300, stringBuilder.toString(), "Unterminated comment");
            }
            stringBuilder.append((char)n);
            if (n != 42) continue;
            do {
                if ((n = this.read()) == -1) {
                    return new Token(300, stringBuilder.toString(), "Unterminated comment");
                }
                stringBuilder.append((char)n);
            } while (n == 42);
            if (n == 47) break;
        }
        return new Token(260, stringBuilder.toString());
    }

    @Nonnull
    private Token cppcomment() throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder("//");
        int n = this.read();
        while (!LexerSource.isLineSeparator(n)) {
            stringBuilder.append((char)n);
            n = this.read();
        }
        this.unread(n);
        return new Token(261, stringBuilder.toString());
    }

    private int escape(StringBuilder stringBuilder) throws IOException, LexerException {
        int n = this.read();
        switch (n) {
            case 97: {
                stringBuilder.append('a');
                return 7;
            }
            case 98: {
                stringBuilder.append('b');
                return 8;
            }
            case 102: {
                stringBuilder.append('f');
                return 12;
            }
            case 110: {
                stringBuilder.append('n');
                return 10;
            }
            case 114: {
                stringBuilder.append('r');
                return 13;
            }
            case 116: {
                stringBuilder.append('t');
                return 9;
            }
            case 118: {
                stringBuilder.append('v');
                return 11;
            }
            case 92: {
                stringBuilder.append('\\');
                return 92;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n2 = 0;
                int n3 = 0;
                do {
                    n3 = (n3 << 3) + Character.digit(n, 8);
                    stringBuilder.append((char)n);
                    n = this.read();
                } while (++n2 < 3 && Character.digit(n, 8) != -1);
                this.unread(n);
                return n3;
            }
            case 120: {
                stringBuilder.append((char)n);
                int n4 = 0;
                int n5 = 0;
                while (n4++ < 2) {
                    n = this.read();
                    if (Character.digit(n, 16) == -1) {
                        this.unread(n);
                        break;
                    }
                    n5 = (n5 << 4) + Character.digit(n, 16);
                    stringBuilder.append((char)n);
                }
                return n5;
            }
            case 34: {
                stringBuilder.append('\"');
                return 34;
            }
            case 39: {
                stringBuilder.append('\'');
                return 39;
            }
        }
        this.warning("Unnecessary escape character " + (char)n);
        stringBuilder.append((char)n);
        return n;
    }

    @Nonnull
    private Token character() throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder("'");
        int n = this.read();
        if (n == 92) {
            stringBuilder.append('\\');
            n = this.escape(stringBuilder);
        } else {
            if (LexerSource.isLineSeparator(n)) {
                this.unread(n);
                return new Token(300, stringBuilder.toString(), "Unterminated character literal");
            }
            if (n == 39) {
                stringBuilder.append('\'');
                return new Token(300, stringBuilder.toString(), "Empty character literal");
            }
            if (!Character.isDefined(n)) {
                stringBuilder.append('?');
                return this.invalid(stringBuilder, "Illegal unicode character literal");
            }
            stringBuilder.append((char)n);
        }
        int n2 = this.read();
        if (n2 != 39) {
            while (true) {
                if (LexerSource.isLineSeparator(n2)) {
                    this.unread(n2);
                    break;
                }
                stringBuilder.append((char)n2);
                if (n2 == 39) break;
                n2 = this.read();
            }
            return new Token(300, stringBuilder.toString(), "Illegal character constant " + stringBuilder);
        }
        stringBuilder.append('\'');
        return new Token(259, stringBuilder.toString(), Character.valueOf((char)n));
    }

    @Nonnull
    private Token string(char c, char c2) throws IOException, LexerException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        StringBuilder stringBuilder2 = new StringBuilder();
        while ((n = this.read()) != c2) {
            if (n == 92) {
                stringBuilder.append('\\');
                if (this.include) continue;
                char c3 = (char)this.escape(stringBuilder);
                stringBuilder2.append(c3);
                continue;
            }
            if (n == -1) {
                this.unread(n);
                return new Token(300, stringBuilder.toString(), "End of file in string literal after " + stringBuilder2);
            }
            if (LexerSource.isLineSeparator(n)) {
                this.unread(n);
                return new Token(300, stringBuilder.toString(), "Unterminated string literal after " + stringBuilder2);
            }
            stringBuilder.append((char)n);
            stringBuilder2.append((char)n);
        }
        stringBuilder.append(c2);
        switch (c2) {
            case '\"': {
                return new Token(292, stringBuilder.toString(), stringBuilder2.toString());
            }
            case '>': {
                return new Token(269, stringBuilder.toString(), stringBuilder2.toString());
            }
            case '\'': {
                if (stringBuilder2.length() == 1) {
                    return new Token(259, stringBuilder.toString(), stringBuilder2.toString());
                }
                return new Token(291, stringBuilder.toString(), stringBuilder2.toString());
            }
        }
        throw new IllegalStateException("Unknown closing character " + String.valueOf(c2));
    }

    @Nonnull
    private Token _number_suffix(StringBuilder stringBuilder, NumericValue numericValue, int n) throws IOException, LexerException {
        int n2 = 0;
        while (true) {
            if (n == 85 || n == 117) {
                if (n2 & true) {
                    this.warning("Duplicate unsigned suffix " + n);
                }
                n2 |= 1;
                stringBuilder.append((char)n);
                n = this.read();
                continue;
            }
            if (n == 76 || n == 108) {
                if ((n2 & 0x3E) != 0) {
                    this.warning("Multiple length suffixes after " + stringBuilder);
                }
                stringBuilder.append((char)n);
                int n3 = this.read();
                if (n3 == n) {
                    n2 |= 8;
                    stringBuilder.append((char)n3);
                    n = this.read();
                    continue;
                }
                n2 |= 4;
                n = n3;
                continue;
            }
            if (n == 73 || n == 105) {
                if ((n2 & 0x3E) != 0) {
                    this.warning("Multiple length suffixes after " + stringBuilder);
                }
                n2 |= 2;
                stringBuilder.append((char)n);
                n = this.read();
                continue;
            }
            if (n == 70 || n == 102) {
                if ((n2 & 0x3E) != 0) {
                    this.warning("Multiple length suffixes after " + stringBuilder);
                }
                n2 |= 0x10;
                stringBuilder.append((char)n);
                n = this.read();
                continue;
            }
            if (n != 68 && n != 100) break;
            if ((n2 & 0x3E) != 0) {
                this.warning("Multiple length suffixes after " + stringBuilder);
            }
            n2 |= 0x20;
            stringBuilder.append((char)n);
            n = this.read();
        }
        if (Character.isUnicodeIdentifierPart(n)) {
            String string = "Invalid suffix \"" + (char)n + "\" on numeric constant";
            while (Character.isUnicodeIdentifierPart(n)) {
                stringBuilder.append((char)n);
                n = this.read();
            }
            this.unread(n);
            return new Token(300, stringBuilder.toString(), string);
        }
        this.unread(n);
        numericValue.setFlags(n2);
        return new Token(272, stringBuilder.toString(), numericValue);
    }

    @Nonnull
    private String _number_part(StringBuilder stringBuilder, int n, boolean bl) throws IOException, LexerException {
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = this.read();
        if (bl && (n2 == 43 || n2 == 45)) {
            stringBuilder.append((char)n2);
            stringBuilder2.append((char)n2);
            n2 = this.read();
        }
        while (Character.digit(n2, n) != -1) {
            stringBuilder.append((char)n2);
            stringBuilder2.append((char)n2);
            n2 = this.read();
        }
        this.unread(n2);
        return stringBuilder2.toString();
    }

    @Nonnull
    private Token number_hex(char c) throws IOException, LexerException {
        String string;
        StringBuilder stringBuilder = new StringBuilder("0");
        stringBuilder.append(c);
        String string2 = this._number_part(stringBuilder, 16, false);
        NumericValue numericValue = new NumericValue(16, string2);
        int n = this.read();
        if (n == 46) {
            stringBuilder.append((char)n);
            string = this._number_part(stringBuilder, 16, false);
            numericValue.setFractionalPart(string);
            n = this.read();
        }
        if (n == 80 || n == 112) {
            stringBuilder.append((char)n);
            string = this._number_part(stringBuilder, 10, true);
            numericValue.setExponent(2, string);
            n = this.read();
        }
        return this._number_suffix(stringBuilder, numericValue, n);
    }

    private static boolean is_octal(@Nonnull String string) {
        if (!string.startsWith("0")) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.digit(string.charAt(i), 8) != -1) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private Token number_decimal() throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this._number_part(stringBuilder, 10, false);
        String string2 = null;
        String string3 = null;
        int n = this.read();
        if (n == 46) {
            stringBuilder.append((char)n);
            string2 = this._number_part(stringBuilder, 10, false);
            n = this.read();
        }
        if (n == 69 || n == 101) {
            stringBuilder.append((char)n);
            string3 = this._number_part(stringBuilder, 10, true);
            n = this.read();
        }
        int n2 = 10;
        if (string2 == null && string3 == null && string.startsWith("0")) {
            if (!LexerSource.is_octal(string)) {
                this.warning("Decimal constant starts with 0, but not octal: " + string);
            } else {
                n2 = 8;
            }
        }
        NumericValue numericValue = new NumericValue(n2, string);
        if (string2 != null) {
            numericValue.setFractionalPart(string2);
        }
        if (string3 != null) {
            numericValue.setExponent(10, string3);
        }
        return this._number_suffix(stringBuilder, numericValue, n);
    }

    @Nonnull
    private Token number() throws IOException, LexerException {
        Token token;
        int n = this.read();
        if (n == 48) {
            int n2 = this.read();
            if (n2 == 120 || n2 == 88) {
                token = this.number_hex((char)n2);
            } else {
                this.unread(n2);
                this.unread(n);
                token = this.number_decimal();
            }
        } else if (Character.isDigit(n) || n == 46) {
            this.unread(n);
            token = this.number_decimal();
        } else {
            throw new LexerException("Asked to parse something as a number which isn't: " + (char)n);
        }
        return token;
    }

    @Nonnull
    private Token identifier(int n) throws IOException, LexerException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        while (true) {
            if (Character.isIdentifierIgnorable(n2 = this.read())) {
                continue;
            }
            if (!Character.isJavaIdentifierPart(n2)) break;
            stringBuilder.append((char)n2);
        }
        this.unread(n2);
        return new Token(270, stringBuilder.toString());
    }

    @Nonnull
    private Token whitespace(int n) throws IOException, LexerException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        while (true) {
            n2 = this.read();
            if (this.ppvalid && LexerSource.isLineSeparator(n2) || !Character.isWhitespace(n2)) break;
            stringBuilder.append((char)n2);
        }
        this.unread(n2);
        return new Token(294, stringBuilder.toString());
    }

    @Nonnull
    private Token cond(char c, int n, int n2) throws IOException, LexerException {
        int n3 = this.read();
        if (c == n3) {
            return new Token(n);
        }
        this.unread(n3);
        return new Token(n2);
    }

    @Override
    public Token token() throws IOException, LexerException {
        Token token = null;
        int n = this.line;
        int n2 = this.column;
        int n3 = this.read();
        switch (n3) {
            case 10: {
                if (!this.ppvalid) break;
                this.bol = true;
                if (this.include) {
                    token = new Token(284, n, n2, "\n");
                } else {
                    int n4;
                    int n5 = 0;
                    do {
                        ++n5;
                    } while ((n4 = this.read()) == 10);
                    this.unread(n4);
                    char[] cArray = new char[n5];
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = 10;
                    }
                    token = new Token(284, n, n2, new String(cArray));
                }
                return token;
            }
            case 33: {
                token = this.cond('=', 283, 33);
                break;
            }
            case 35: {
                if (this.bol) {
                    token = new Token(268);
                    break;
                }
                token = this.cond('#', 286, 35);
                break;
            }
            case 43: {
                int n6 = this.read();
                if (n6 == 43) {
                    token = new Token(271);
                    break;
                }
                if (n6 == 61) {
                    token = new Token(287);
                    break;
                }
                this.unread(n6);
                break;
            }
            case 45: {
                int n7 = this.read();
                if (n7 == 45) {
                    token = new Token(262);
                    break;
                }
                if (n7 == 61) {
                    token = new Token(293);
                    break;
                }
                if (n7 == 62) {
                    token = new Token(258);
                    break;
                }
                this.unread(n7);
                break;
            }
            case 42: {
                token = this.cond('=', 282, 42);
                break;
            }
            case 47: {
                int n8 = this.read();
                if (n8 == 42) {
                    token = this.ccomment();
                    break;
                }
                if (n8 == 47) {
                    token = this.cppcomment();
                    break;
                }
                if (n8 == 61) {
                    token = new Token(263);
                    break;
                }
                this.unread(n8);
                break;
            }
            case 37: {
                int n9 = this.read();
                if (n9 == 61) {
                    token = new Token(281);
                    break;
                }
                if (this.digraphs && n9 == 62) {
                    token = new Token(125);
                    break;
                }
                if (this.digraphs && n9 == 58) {
                    n9 = this.read();
                    if (n9 != 37) {
                        this.unread(n9);
                        token = new Token(35);
                        break;
                    }
                    n9 = this.read();
                    if (n9 != 58) {
                        this.unread(n9);
                        this.unread(37);
                        token = new Token(35);
                        break;
                    }
                    token = new Token(286);
                    break;
                }
                this.unread(n9);
                break;
            }
            case 58: {
                int n10 = this.read();
                if (this.digraphs && n10 == 62) {
                    token = new Token(93);
                    break;
                }
                this.unread(n10);
                break;
            }
            case 60: {
                if (this.include) {
                    token = this.string('<', '>');
                    break;
                }
                int n11 = this.read();
                if (n11 == 61) {
                    token = new Token(275);
                    break;
                }
                if (n11 == 60) {
                    token = this.cond('=', 280, 279);
                    break;
                }
                if (this.digraphs && n11 == 58) {
                    token = new Token(91);
                    break;
                }
                if (this.digraphs && n11 == 37) {
                    token = new Token(123);
                    break;
                }
                this.unread(n11);
                break;
            }
            case 61: {
                token = this.cond('=', 266, 61);
                break;
            }
            case 62: {
                int n12 = this.read();
                if (n12 == 61) {
                    token = new Token(267);
                    break;
                }
                if (n12 == 62) {
                    token = this.cond('=', 290, 289);
                    break;
                }
                this.unread(n12);
                break;
            }
            case 94: {
                token = this.cond('=', 295, 94);
                break;
            }
            case 124: {
                int n13 = this.read();
                if (n13 == 61) {
                    token = new Token(285);
                    break;
                }
                if (n13 == 124) {
                    token = this.cond('=', 278, 277);
                    break;
                }
                this.unread(n13);
                break;
            }
            case 38: {
                int n14 = this.read();
                if (n14 == 38) {
                    token = this.cond('=', 274, 273);
                    break;
                }
                if (n14 == 61) {
                    token = new Token(257);
                    break;
                }
                this.unread(n14);
                break;
            }
            case 46: {
                int n15 = this.read();
                if (n15 == 46) {
                    token = this.cond('.', 264, 288);
                } else {
                    this.unread(n15);
                }
                if (!Character.isDigit(n15)) break;
                this.unread(46);
                token = this.number();
                break;
            }
            case 39: {
                token = this.string('\'', '\'');
                break;
            }
            case 34: {
                token = this.string('\"', '\"');
                break;
            }
            case -1: {
                this.close();
                token = new Token(265, n, n2, "<eof>");
            }
        }
        if (token == null) {
            if (Character.isWhitespace(n3)) {
                token = this.whitespace(n3);
            } else if (Character.isDigit(n3)) {
                this.unread(n3);
                token = this.number();
            } else if (Character.isJavaIdentifierStart(n3)) {
                token = this.identifier(n3);
            } else {
                String string = TokenType.getTokenText(n3);
                if (string == null) {
                    string = n3 >>> 16 == 0 ? Character.toString((char)n3) : new String(Character.toChars(n3));
                }
                token = new Token(n3, string);
            }
        }
        if (this.bol) {
            switch (token.getType()) {
                case 260: 
                case 294: {
                    break;
                }
                default: {
                    this.bol = false;
                }
            }
        }
        token.setLocation(n, n2);
        return token;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        super.close();
    }
}

