/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.InputLexerSource;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.VirtualFile;
import com.jogamp.gluegen.jcpp.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ResourceFileSystem
implements VirtualFileSystem {
    private final ClassLoader loader;
    private final Charset charset;

    public ResourceFileSystem(@Nonnull ClassLoader classLoader, @Nonnull Charset charset) {
        this.loader = classLoader;
        this.charset = charset;
    }

    @Override
    public VirtualFile getFile(String string) {
        return new ResourceFile(this.loader, string);
    }

    @Override
    public VirtualFile getFile(String string, String string2) {
        return this.getFile(string + "/" + string2);
    }

    private class ResourceFile
    implements VirtualFile {
        private final ClassLoader loader;
        private final String path;

        public ResourceFile(ClassLoader classLoader, String string) {
            this.loader = classLoader;
            this.path = string;
        }

        @Override
        public boolean isFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }

        @Override
        public ResourceFile getParentFile() {
            int n = this.path.lastIndexOf(47);
            if (n < 1) {
                return null;
            }
            return new ResourceFile(this.loader, this.path.substring(0, n));
        }

        @Override
        public ResourceFile getChildFile(String string) {
            return new ResourceFile(this.loader, this.path + "/" + string);
        }

        @Override
        public Source getSource() throws IOException {
            InputStream inputStream = this.loader.getResourceAsStream(this.path);
            return new InputLexerSource(inputStream, ResourceFileSystem.this.charset);
        }
    }
}

