/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jgram;

import com.jogamp.gluegen.jgram.JavaLexer;
import com.jogamp.gluegen.jgram.JavaParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Set;

class Test {
    static boolean showTree = false;

    Test() {
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                System.err.println("Parsing...");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-showtree")) {
                        showTree = true;
                        continue;
                    }
                    Test.doFile(new File(stringArray[i]));
                }
            } else {
                System.err.println("Usage: java com.jogamp.gluegen.jgram.Test [-showtree] <directory or file name>");
            }
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public static void doFile(File file) throws Exception {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Test.doFile(new File(file, stringArray[i]));
            }
        } else if (file.getName().length() > 5 && file.getName().substring(file.getName().length() - 5).equals(".java")) {
            System.err.println("   " + file.getAbsolutePath());
            Test.parseFile(file.getName(), new BufferedReader(new FileReader(file)));
        }
    }

    public static void parseFile(String string, Reader reader) throws Exception {
        try {
            JavaLexer javaLexer = new JavaLexer(reader);
            javaLexer.setFilename(string);
            JavaParser javaParser = new JavaParser(javaLexer);
            javaParser.setFilename(string);
            javaParser.compilationUnit();
            Set<String> set = javaParser.getParsedEnumNames();
            System.out.println("Enums");
            for (String string2 : set) {
                System.out.println(string2);
            }
            System.out.println("Functions");
            set = javaParser.getParsedFunctionNames();
            for (String string2 : set) {
                System.out.println(string2);
            }
        }
        catch (Exception exception) {
            System.err.println("parser exception: " + exception);
            exception.printStackTrace();
        }
    }
}

