/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.JavaCodeUnit;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import com.jogamp.gluegen.procaddress.ProcAddressCMethodBindingEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressConfiguration;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProcAddressEmitter
extends JavaEmitter {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static final String WRAP_PREFIX = "dispatch_";
    private TypeDictionary typedefDictionary;
    protected JavaCodeUnit tableJavaUnit;
    protected Set<String> emittedTableEntries;
    protected String tableClassPackage;
    protected String tableClassName;

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map, List<FunctionSymbol> list) throws Exception {
        this.typedefDictionary = typeDictionary;
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.beginProcAddressTable();
        }
        super.beginFunctions(typeDictionary, typeDictionary2, map, list);
    }

    @Override
    public void endFunctions() throws Exception {
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.endProcAddressTable();
        }
        super.endFunctions();
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        super.beginStructs(typeDictionary, typeDictionary2, map);
    }

    public String runtimeExceptionType() {
        return this.getConfig().runtimeExceptionType();
    }

    public String unsupportedExceptionType() {
        return this.getConfig().unsupportedExceptionType();
    }

    @Override
    protected JavaConfiguration createConfig() {
        return new ProcAddressConfiguration();
    }

    @Override
    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(FunctionSymbol functionSymbol) throws Exception {
        return this.generateMethodBindingEmittersImpl(functionSymbol);
    }

    protected boolean needsModifiedEmitters(FunctionSymbol functionSymbol) {
        return this.callThroughProcAddress(functionSymbol) && !this.getConfig().isUnimplemented(functionSymbol);
    }

    private List<? extends FunctionEmitter> generateMethodBindingEmittersImpl(FunctionSymbol functionSymbol) throws Exception {
        List<? extends FunctionEmitter> list = super.generateMethodBindingEmitters(functionSymbol);
        if (list.isEmpty()) {
            this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "genModProcAddrEmitter: SKIP, empty binding set: {0}", (Object)functionSymbol);
            return list;
        }
        boolean bl = this.callThroughProcAddress(functionSymbol);
        boolean bl2 = this.getConfig().isUnimplemented(functionSymbol);
        if (!bl || bl2) {
            this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "genModProcAddrEmitter: SKIP, not needed: callThrough {0}, isUnimplemented {1}: {2}", bl, bl2, functionSymbol);
            return list;
        }
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>(list.size());
        if (bl && this.getProcAddressConfig().emitProcAddressTable()) {
            this.emitProcAddressTableEntryForString(functionSymbol.getName());
        }
        for (FunctionEmitter functionEmitter : list) {
            if (functionEmitter instanceof JavaMethodBindingEmitter) {
                this.generateModifiedEmitters((JavaMethodBindingEmitter)functionEmitter, arrayList);
                continue;
            }
            if (functionEmitter instanceof CMethodBindingEmitter) {
                this.generateModifiedEmitters((CMethodBindingEmitter)functionEmitter, arrayList);
                continue;
            }
            throw new RuntimeException("Unexpected emitter type: " + functionEmitter.getClass().getName());
        }
        return arrayList;
    }

    protected String getFunctionPointerTypedefName(FunctionSymbol functionSymbol) {
        return this.getProcAddressConfig().convertToFunctionPointerName(functionSymbol.getOrigName());
    }

    protected void fixSecurityModifiers(JavaMethodBindingEmitter javaMethodBindingEmitter) {
        if (javaMethodBindingEmitter.hasModifier(JavaMethodBindingEmitter.NATIVE) && !javaMethodBindingEmitter.hasModifier(JavaMethodBindingEmitter.PRIVATE)) {
            javaMethodBindingEmitter.removeModifier(JavaMethodBindingEmitter.PUBLIC);
            javaMethodBindingEmitter.removeModifier(JavaMethodBindingEmitter.PROTECTED);
            javaMethodBindingEmitter.removeModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
    }

    protected void generateModifiedEmitters(JavaMethodBindingEmitter javaMethodBindingEmitter, List<FunctionEmitter> list) {
        boolean bl = this.callThroughProcAddress(javaMethodBindingEmitter.getBinding().getCSymbol());
        boolean bl2 = javaMethodBindingEmitter.signatureOnly() && javaMethodBindingEmitter.isNativeMethod() && !javaMethodBindingEmitter.isPrivateNativeMethod() && bl;
        ProcAddressJavaMethodBindingEmitter procAddressJavaMethodBindingEmitter = new ProcAddressJavaMethodBindingEmitter(javaMethodBindingEmitter, bl, this.getProcAddressConfig().getProcAddressTableExpr(), javaMethodBindingEmitter.isPrivateNativeMethod(), this);
        if (bl2) {
            procAddressJavaMethodBindingEmitter.setEmitBody(true);
            procAddressJavaMethodBindingEmitter.removeModifier(JavaMethodBindingEmitter.NATIVE);
        } else if (bl) {
            this.fixSecurityModifiers(procAddressJavaMethodBindingEmitter);
        }
        list.add(procAddressJavaMethodBindingEmitter);
        if (bl2) {
            procAddressJavaMethodBindingEmitter = new ProcAddressJavaMethodBindingEmitter(javaMethodBindingEmitter, bl, this.getProcAddressConfig().getProcAddressTableExpr(), true, this);
            procAddressJavaMethodBindingEmitter.setPrivateNativeMethod(true);
            this.fixSecurityModifiers(procAddressJavaMethodBindingEmitter);
            list.add(procAddressJavaMethodBindingEmitter);
        }
    }

    protected void generateModifiedEmitters(CMethodBindingEmitter cMethodBindingEmitter, List<FunctionEmitter> list) {
        FunctionSymbol functionSymbol = cMethodBindingEmitter.getBinding().getCSymbol();
        boolean bl = this.hasFunctionPointerTypedef(functionSymbol);
        boolean bl2 = bl || this.callThroughProcAddress(functionSymbol);
        String string = this.getProcAddressConfig().getLocalProcAddressCallingConvention(functionSymbol);
        this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "genModProcAddrEmitter: callThrough {0}, hasTypedef {1}, localCallConv {2}: {3}", bl2, bl, string, functionSymbol);
        ProcAddressCMethodBindingEmitter procAddressCMethodBindingEmitter = new ProcAddressCMethodBindingEmitter(cMethodBindingEmitter, bl2, bl, string, this);
        MessageFormat messageFormat = cMethodBindingEmitter.getReturnValueCapacityExpression();
        if (messageFormat != null) {
            procAddressCMethodBindingEmitter.setReturnValueCapacityExpression(messageFormat);
        }
        list.add(procAddressCMethodBindingEmitter);
    }

    protected boolean callThroughProcAddress(FunctionSymbol functionSymbol) {
        ProcAddressConfiguration procAddressConfiguration = this.getProcAddressConfig();
        boolean bl = false;
        int n = 0;
        if (procAddressConfiguration.forceProcAddressGen(functionSymbol)) {
            bl = true;
            n = 1;
        } else if (procAddressConfiguration.skipProcAddressGen(functionSymbol)) {
            bl = false;
            n = 2;
        } else {
            bl = this.hasFunctionPointerTypedef(functionSymbol);
            n = 3;
        }
        this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "callThroughProcAddress: {0} [m {1}]: {2}", bl, n, functionSymbol);
        return bl;
    }

    protected boolean hasFunctionPointerTypedef(FunctionSymbol functionSymbol) {
        String string = this.getFunctionPointerTypedefName(functionSymbol);
        boolean bl = this.typedefDictionary.containsKey(string);
        this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "hasFunctionPointerTypedef: {0}: {1}", bl, functionSymbol);
        return bl;
    }

    protected void beginProcAddressTable() throws Exception {
        ProcAddressConfiguration procAddressConfiguration = this.getProcAddressConfig();
        this.tableClassPackage = procAddressConfiguration.tableClassPackage();
        this.tableClassName = procAddressConfiguration.tableClassName();
        String string = this.tableClassPackage;
        if (string == null) {
            string = this.getImplPackageName();
        }
        String string2 = string + "." + this.tableClassName;
        String[] stringArray = this.getClassAccessModifiers(string2);
        String string3 = this.getJavaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string);
        String string4 = string3 + File.separator + this.tableClassName + ".java";
        this.tableJavaUnit = this.openJavaUnit(string4, string, this.tableClassName);
        this.emittedTableEntries = new HashSet<String>();
        this.tableJavaUnit.emitln("package " + string + ";");
        this.tableJavaUnit.emitln();
        for (String string5 : this.getConfig().imports()) {
            this.tableJavaUnit.emitln("import " + string5 + ";");
        }
        this.tableJavaUnit.emitln("import " + ProcAddressTable.class.getName() + ";");
        this.tableJavaUnit.emitln("import com.jogamp.common.util.SecurityUtil;");
        this.tableJavaUnit.emitln();
        this.tableJavaUnit.emitln("/**");
        this.tableJavaUnit.emitln(" * This table is a cache of pointers to the dynamically-linkable C library.");
        this.tableJavaUnit.emitln(" * @see " + ProcAddressTable.class.getSimpleName());
        this.tableJavaUnit.emitln(" */");
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.tableJavaUnit.emit(stringArray[i]);
            this.tableJavaUnit.emit(" ");
        }
        this.tableJavaUnit.emitln("final class " + this.tableClassName + " extends " + ProcAddressTable.class.getSimpleName() + " {");
        this.tableJavaUnit.emitln();
        for (String string5 : this.getProcAddressConfig().getForceProcAddressGen()) {
            this.emitProcAddressTableEntryForString(string5);
        }
        this.tableJavaUnit.emitln();
        this.tableJavaUnit.emitln("  public " + this.tableClassName + "(){ super(); }");
        this.tableJavaUnit.emitln();
        this.tableJavaUnit.emitln("  public " + this.tableClassName + "(" + FunctionAddressResolver.class.getName() + " resolver){ super(resolver); }");
        this.tableJavaUnit.emitln();
    }

    protected void endProcAddressTable() throws Exception {
        this.tableJavaUnit.emitln("} // end of class " + this.tableClassName);
        this.tableJavaUnit.close();
        this.tableJavaUnit = null;
    }

    protected void emitProcAddressTableEntryForString(String string) {
        if (this.emittedTableEntries.contains(string)) {
            return;
        }
        this.emittedTableEntries.add(string);
        this.tableJavaUnit.emit("  /* pp */ long ");
        this.tableJavaUnit.emit(PROCADDRESS_VAR_PREFIX);
        this.tableJavaUnit.emit(string);
        this.tableJavaUnit.emitln(";");
    }

    protected ProcAddressConfiguration getProcAddressConfig() {
        return (ProcAddressConfiguration)this.getConfig();
    }
}

