/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;
import java.io.PrintWriter;

public class ProcAddressJavaMethodBindingEmitter
extends JavaMethodBindingEmitter {
    protected boolean callThroughProcAddress;
    protected boolean changeNameAndArguments;
    protected String getProcAddressTableExpr;
    protected ProcAddressEmitter emitter;

    public ProcAddressJavaMethodBindingEmitter(JavaMethodBindingEmitter javaMethodBindingEmitter, boolean bl, String string, boolean bl2, ProcAddressEmitter procAddressEmitter) {
        super(javaMethodBindingEmitter);
        this.callThroughProcAddress = bl;
        this.getProcAddressTableExpr = string;
        this.changeNameAndArguments = bl2;
        this.emitter = procAddressEmitter;
        if (bl) {
            this.setCommentEmitter(new WrappedMethodCommentEmitter());
        }
        if (javaMethodBindingEmitter.getBinding().hasContainingType()) {
            throw new IllegalArgumentException("Cannot create proc. address wrapper; method has containing type: \"" + javaMethodBindingEmitter.getBinding() + "\"");
        }
    }

    public ProcAddressJavaMethodBindingEmitter(ProcAddressJavaMethodBindingEmitter procAddressJavaMethodBindingEmitter) {
        this(procAddressJavaMethodBindingEmitter, procAddressJavaMethodBindingEmitter.callThroughProcAddress, procAddressJavaMethodBindingEmitter.getProcAddressTableExpr, procAddressJavaMethodBindingEmitter.changeNameAndArguments, procAddressJavaMethodBindingEmitter.emitter);
    }

    @Override
    public String getImplName() {
        String string = super.getImplName();
        if (this.changeNameAndArguments) {
            return "dispatch_" + string;
        }
        return string;
    }

    @Override
    protected int appendArguments(StringBuilder stringBuilder) {
        int n = super.appendArguments(stringBuilder);
        if (this.callThroughProcAddress && this.changeNameAndArguments) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("long procAddress");
            ++n;
        }
        return n;
    }

    @Override
    protected String getNativeImplMethodName() {
        String string = super.getNativeImplMethodName();
        if (this.callThroughProcAddress) {
            return "dispatch_" + string;
        }
        return string;
    }

    @Override
    protected void emitPreCallSetup(MethodBinding methodBinding) {
        super.emitPreCallSetup(methodBinding);
        if (this.callThroughProcAddress) {
            String string = "_addressof_" + methodBinding.getNativeName();
            this.unit.emitln("    final long __addr_ = " + this.getProcAddressTableExpr + "." + string + ";");
            this.unit.emitln("    if (__addr_ == 0) {");
            this.unit.emitf("      throw new %s(String.format(\"Method \\\"%%s\\\" not available\", \"%s\"));%n", this.emitter.unsupportedExceptionType(), methodBinding.getName());
            this.unit.emitln("    }");
        }
    }

    @Override
    protected int emitCallArguments(MethodBinding methodBinding) {
        int n = super.emitCallArguments(methodBinding);
        if (this.callThroughProcAddress) {
            if (n > 0) {
                this.unit.emit(", ");
            }
            this.unit.emit("__addr_");
            ++n;
        }
        return n;
    }

    public class WrappedMethodCommentEmitter
    extends JavaMethodBindingEmitter.DefaultCommentEmitter {
        @Override
        protected void emitBeginning(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            printWriter.print("Entry point (through function pointer) to C language function: <br> ");
        }
    }
}

