/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.structgen;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.gluegen.CCodeUnit;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaCodeUnit;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.structgen.CStruct;
import com.jogamp.gluegen.structgen.CStructs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jogamp.common.Debug;

@SupportedAnnotationTypes(value={"com.jogamp.gluegen.structgen.CStruct", "com.jogamp.gluegen.structgen.CStructs"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class CStructAnnotationProcessor
extends AbstractProcessor {
    private static final String DEFAULT = "_default_";
    static final boolean DEBUG;
    private static final String STRUCTGENOUTPUT_OPTION = "structgen.output";
    private static final String STRUCTGENPRAGMA_ONCE = "structgen.enable.pragma.once";
    private static final String STRUCTGENOUTPUT;
    private static final String STRUCTGENPRAGMAONCE;
    private Filer filer;
    private Messager messager;
    private Elements eltUtils;
    private String outputPath;
    private boolean enablePragmaOnce;
    private static final Set<String> generatedStructs;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.eltUtils = processingEnvironment.getElementUtils();
        this.outputPath = processingEnvironment.getOptions().get(STRUCTGENOUTPUT_OPTION);
        this.outputPath = this.outputPath == null ? STRUCTGENOUTPUT : this.outputPath;
        String string = processingEnvironment.getOptions().get(STRUCTGENPRAGMAONCE);
        this.enablePragmaOnce = Boolean.parseBoolean(string == null ? STRUCTGENPRAGMAONCE : string);
    }

    private File locateSource(String string, String string2) {
        block5: {
            try {
                File file;
                if (DEBUG) {
                    System.err.println("CStruct.locateSource.0: p " + string + ", r " + string2);
                }
                FileObject fileObject = this.filer.getResource(StandardLocation.SOURCE_PATH, string, string2);
                if (DEBUG) {
                    System.err.println("CStruct.locateSource.1: h " + String.valueOf(fileObject.toUri()));
                }
                if ((file = new File(fileObject.toUri().getPath())).exists()) {
                    return file;
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block5;
                System.err.println("Caught " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Object object;
        Object object2;
        Object object3;
        String string = System.getProperty("user.dir");
        Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(CStructs.class);
        for (Element object42 : set2) {
            object3 = this.eltUtils.getPackageOf(object42).toString();
            object2 = object42.getAnnotation(CStructs.class);
            if (null == object2) continue;
            for (CStruct cStruct : object = object2.value()) {
                this.processCStruct(cStruct, object42, (String)object3, string);
            }
        }
        Set<? extends Element> set3 = roundEnvironment.getElementsAnnotatedWith(CStruct.class);
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            object3 = (Element)iterator.next();
            object2 = this.eltUtils.getPackageOf((Element)object3).toString();
            object = object3.getAnnotation(CStruct.class);
            if (null == object) continue;
            this.processCStruct((CStruct)object, (Element)object3, (String)object2, string);
        }
        return true;
    }

    private void processCStruct(CStruct cStruct, Element element, String string, String string2) {
        try {
            String string3 = cStruct.header();
            Element element2 = element.getEnclosingElement();
            boolean bl = null == element2;
            System.err.println("CStruct: " + String.valueOf(cStruct) + ", package " + string + ", header " + string3);
            if (DEBUG) {
                System.err.println("CStruct.0: user.dir: " + string2);
                System.err.println("CStruct.0: element: " + String.valueOf(element) + ", .simpleName " + String.valueOf(element.getSimpleName()));
                System.err.print("CStruct.0: isPackageOrType " + bl + ", enclElement: " + String.valueOf(element2));
                if (!bl) {
                    if (!element2.toString().equals("unnamed module")) {
                        System.err.println(", .simpleName " + String.valueOf(element2.getSimpleName()) + ", .package " + this.eltUtils.getPackageOf(element2).toString());
                    } else {
                        System.err.println(", .simpleName " + String.valueOf(element2.getSimpleName()) + ", .package <unnamed modules have no package>");
                    }
                } else {
                    System.err.println("");
                }
            }
            if (bl && cStruct.name().equals(DEFAULT)) {
                throw new IllegalArgumentException("CStruct annotation on package or type must have name specified: " + String.valueOf(cStruct) + " @ " + String.valueOf(element));
            }
            Object object = this.locateSource(string, string3);
            if (null == object && null == (object = this.locateSource("", string3))) {
                throw new RuntimeException("Could not locate header " + string3 + ", package " + string);
            }
            File file = object;
            String string4 = file.getAbsolutePath();
            String string5 = string4.substring(0, string4.length() - file.getName().length() - 1);
            object = string5.substring(0, string5.length() - string.length()) + "..";
            System.err.println("CStruct: " + String.valueOf(file) + ", abs: " + file.isAbsolute() + ", headerParent " + string5 + ", rootOut " + (String)object + ", enablePragmaOnce " + this.enablePragmaOnce);
            this.generateStructBinding(element, cStruct, bl, (String)object, string, file, string5);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while processing!", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStructBinding(Element element, CStruct cStruct, boolean bl, String string, String string2, File file, String string3) throws IOException {
        BufferedReader bufferedReader;
        boolean bl2;
        String string4 = element.asType().toString();
        boolean bl3 = !cStruct.name().equals(DEFAULT);
        String string5 = bl3 ? cStruct.name() : string4;
        boolean bl4 = bl2 = !cStruct.jname().equals(DEFAULT);
        String string6 = bl2 ? cStruct.jname() : (!bl ? string4 : string5);
        System.err.println("CStruct: Generating struct accessor for struct: " + string5 + " -> " + string6 + " [struct.name " + cStruct.name() + ", struct.jname " + cStruct.jname() + ", declaredType " + string4 + "]");
        if (generatedStructs.contains(string6)) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "struct " + string5 + " already defined elsewhere, skipping.", element);
            return;
        }
        Object object = new File(this.outputPath);
        boolean bl5 = ((File)object).isAbsolute();
        object = bl5 ? this.outputPath : string + File.separator + this.outputPath;
        String string7 = (String)object + File.separator + file.getName() + ".cfg";
        File file2 = new File(string7);
        if (DEBUG) {
            System.err.println("CStruct: OutputDir: " + this.outputPath + ", is-abs " + bl5);
            System.err.println("CStruct: OutputPath: " + (String)object);
            System.err.println("CStruct: ConfigFile: " + String.valueOf(file2));
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            fileWriter.write("Package " + string2 + "\n");
            fileWriter.write("EmitStruct " + string5 + "\n");
            if (!bl2 && string6 != string5) {
                fileWriter.write("RenameJavaType " + cStruct.name() + " " + string4 + "\n");
            }
        }
        finally {
            if (null != fileWriter) {
                fileWriter.close();
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string7);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string3);
        arrayList2.add((String)object);
        String string8 = file.getPath();
        try {
            bufferedReader = new BufferedReader(new FileReader(string8));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("input file not found", fileNotFoundException);
        }
        if (DEBUG) {
            GlueGen.setDebug(true);
        }
        new GlueGen().run(bufferedReader, string8, AnnotationProcessorJavaStructEmitter.class, arrayList2, arrayList, (String)object, false, this.enablePragmaOnce, false);
        file2.delete();
        generatedStructs.add(string6);
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("jogamp.gluegen.structgen.debug", true);
        STRUCTGENOUTPUT = PropertyAccess.getProperty("jogamp.gluegen.structgen.output", true, "gensrc");
        STRUCTGENPRAGMAONCE = PropertyAccess.getProperty("jogamp.gluegen.structgen.enable.pragma.once", true, "true");
        generatedStructs = new HashSet<String>();
    }

    public static class AnnotationProcessorJavaStructEmitter
    extends JavaEmitter {
        private boolean filter(String string) {
            if (generatedStructs.contains(string)) {
                System.err.println("skipping -> " + string);
                return false;
            }
            if (!string.endsWith("32") && !string.endsWith("64")) {
                System.err.println("generating -> " + string);
                generatedStructs.add(string);
            }
            return true;
        }

        @Override
        protected CCodeUnit openCUnit(String string, String string2) throws IOException {
            if (!this.filter(string2)) {
                return null;
            }
            return super.openCUnit(string, string2);
        }

        @Override
        protected JavaCodeUnit openJavaUnit(String string, String string2, String string3) throws IOException {
            if (!this.filter(string3)) {
                return null;
            }
            return super.openJavaUnit(string, string2, string3);
        }
    }
}

