/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLStateKeeper;
import java.util.ArrayList;
import java.util.List;
import jogamp.common.os.android.StaticContext;
import jogamp.newt.driver.android.WindowDriver;

public class NewtBaseActivity
extends Activity {
    List<com.jogamp.newt.Window> newtWindows = new ArrayList<com.jogamp.newt.Window>();
    List<GLAutoDrawable> glAutoDrawables = new ArrayList<GLAutoDrawable>();
    GLAnimatorControl animator = null;
    boolean isDelegatedActivity = false;
    Activity rootActivity;
    boolean setThemeCalled = false;
    private final GLStateKeeper.Listener glStateKeeperListener = new GLStateKeeper.Listener(){

        @Override
        public void glStatePreserveNotify(GLStateKeeper gLStateKeeper) {
            Log.d((String)"JogAmp.NEWT", (String)("GLStateKeeper Preserving: 0x" + Integer.toHexString(gLStateKeeper.hashCode())));
        }

        @Override
        public void glStateRestored(GLStateKeeper gLStateKeeper) {
            Log.d((String)"JogAmp.NEWT", (String)("GLStateKeeper Restored: 0x" + Integer.toHexString(gLStateKeeper.hashCode())));
            NewtBaseActivity.this.startAnimation(true);
        }
    };

    protected void startAnimation(boolean bl) {
        int n;
        if (null != this.animator) {
            n = bl ? (this.animator.isPaused() ? (int)(this.animator.resume() ? 1 : 0) : (int)(this.animator.start() ? 1 : 0)) : this.animator.stop();
            Log.d((String)"JogAmp.NEWT", (String)("Animator global: start " + bl + ", result " + (n != 0)));
        }
        for (n = 0; n < this.glAutoDrawables.size(); ++n) {
            GLAnimatorControl gLAnimatorControl = this.glAutoDrawables.get(n).getAnimator();
            if (null == gLAnimatorControl) continue;
            boolean bl2 = bl ? (gLAnimatorControl.isPaused() ? gLAnimatorControl.resume() : gLAnimatorControl.start()) : gLAnimatorControl.stop();
            Log.d((String)"JogAmp.NEWT", (String)("Animator glad[" + n + "]: start " + bl + ", result " + bl2));
        }
    }

    public NewtBaseActivity() {
        this.rootActivity = this;
    }

    public void setRootActivity(Activity activity) {
        this.rootActivity = activity;
        this.isDelegatedActivity = this != activity;
    }

    public final boolean isDelegatedActivity() {
        return this.isDelegatedActivity;
    }

    public final Activity getActivity() {
        return this.rootActivity;
    }

    public void setContentView(Window window, com.jogamp.newt.Window window2) throws IllegalArgumentException {
        com.jogamp.newt.Window window3 = window2.getDelegatedWindow();
        if (!(window3 instanceof WindowDriver)) {
            throw new IllegalArgumentException("Given NEWT Window is not an Android Window: " + window2.getClass().getName());
        }
        this.adaptTheme4Transparency(window3.getRequestedCapabilities());
        this.layoutForNEWTWindow(window, window3);
        WindowDriver windowDriver = (WindowDriver)window3;
        window.setContentView((View)windowDriver.getAndroidView());
        this.registerNEWTWindow(window2);
    }

    public void addContentView(Window window, com.jogamp.newt.Window window2, ViewGroup.LayoutParams layoutParams) throws IllegalArgumentException {
        com.jogamp.newt.Window window3 = window2.getDelegatedWindow();
        if (!(window3 instanceof WindowDriver)) {
            throw new IllegalArgumentException("Given NEWT Window's Delegate is not an Android Window: " + window3.getClass().getName());
        }
        WindowDriver windowDriver = (WindowDriver)window3;
        window.addContentView((View)windowDriver.getAndroidView(), layoutParams);
        this.registerNEWTWindow(window2);
    }

    public void registerNEWTWindow(com.jogamp.newt.Window window) throws IllegalArgumentException {
        com.jogamp.newt.Window window2 = window.getDelegatedWindow();
        Log.d((String)"JogAmp.NEWT", (String)("registerNEWTWindow: Type " + window.getClass().getName() + ", delegate " + window2.getClass().getName()));
        if (!(window2 instanceof WindowDriver)) {
            throw new IllegalArgumentException("Given NEWT Window's Delegate is not an Android Window: " + window2.getClass().getName());
        }
        WindowDriver windowDriver = (WindowDriver)window2;
        windowDriver.registerActivity(this.getActivity());
        this.newtWindows.add(window);
        if (window instanceof GLAutoDrawable) {
            this.glAutoDrawables.add((GLAutoDrawable)((Object)window));
        }
        if (window instanceof GLStateKeeper) {
            ((GLStateKeeper)((Object)window)).setGLStateKeeperListener(this.glStateKeeperListener);
        }
    }

    public void layoutForNEWTWindow(Window window, com.jogamp.newt.Window window2) {
        if (null == window || null == window2) {
            throw new IllegalArgumentException("Android or NEWT Window null");
        }
        if (window2.isFullscreen() || window2.isUndecorated()) {
            window.requestFeature(1);
        }
        if (window2.isFullscreen()) {
            window.addFlags(1024);
            window.clearFlags(2048);
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
        if (window2.getWidth() > 0 && window2.getHeight() > 0 && !window2.isFullscreen()) {
            window.setLayout(window2.getWidth(), window2.getHeight());
        }
    }

    public void setFullscreenFeature(Window window, boolean bl) {
        if (null == window) {
            throw new IllegalArgumentException("Android or Window null");
        }
        if (bl) {
            window.requestFeature(1);
            window.addFlags(1024);
            window.clearFlags(2048);
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }

    protected void adaptTheme4Transparency(CapabilitiesImmutable capabilitiesImmutable) {
        if (!capabilitiesImmutable.isBackgroundOpaque()) {
            this.setTransparencyTheme();
        }
    }

    public void setTransparencyTheme() {
        if (!this.setThemeCalled) {
            this.setThemeCalled = true;
            Context context = this.getActivity().getApplicationContext();
            String string = context.getPackageName() + ":style/Theme.Transparent";
            int n = context.getResources().getIdentifier("Theme.Transparent", "style", context.getPackageName());
            if (0 == n) {
                Log.d((String)"JogAmp.NEWT", (String)("SetTransparencyTheme: Resource n/a: " + string));
            } else {
                Log.d((String)"JogAmp.NEWT", (String)("SetTransparencyTheme: Setting style: " + string + ": 0x" + Integer.toHexString(n)));
                context.setTheme(n);
            }
        }
    }

    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.animator = gLAnimatorControl;
        if (!gLAnimatorControl.isStarted()) {
            gLAnimatorControl.start();
        }
        gLAnimatorControl.pause();
    }

    public Window getWindow() {
        if (this.isDelegatedActivity()) {
            return this.getActivity().getWindow();
        }
        return super.getWindow();
    }

    public void onCreate(Bundle bundle) {
        Log.d((String)"JogAmp.NEWT", (String)"onCreate.0");
        if (!this.isDelegatedActivity()) {
            super.onCreate(bundle);
        }
        this.cleanup();
        StaticContext.init((Context)this.rootActivity.getApplicationContext());
        Log.d((String)"JogAmp.NEWT", (String)"onCreate.X");
    }

    public void onStart() {
        Log.d((String)"JogAmp.NEWT", (String)"onStart.0");
        if (!this.isDelegatedActivity()) {
            super.onStart();
        }
        Log.d((String)"JogAmp.NEWT", (String)"onStart.X");
    }

    public void onRestart() {
        Log.d((String)"JogAmp.NEWT", (String)"onRestart.0");
        if (!this.isDelegatedActivity()) {
            super.onRestart();
        }
        Log.d((String)"JogAmp.NEWT", (String)"onRestart.X");
    }

    public void onResume() {
        Log.d((String)"JogAmp.NEWT", (String)"onResume.0");
        if (!this.isDelegatedActivity()) {
            super.onResume();
        }
        for (int i = 0; i < this.newtWindows.size(); ++i) {
            com.jogamp.newt.Window window = this.newtWindows.get(i);
            window.setVisible(true);
            if (!(window instanceof FPSCounter)) continue;
            ((FPSCounter)((Object)window)).resetFPSCounter();
        }
        this.startAnimation(true);
        Log.d((String)"JogAmp.NEWT", (String)"onResume.X");
    }

    public void onPause() {
        Log.d((String)"JogAmp.NEWT", (String)"onPause.0");
        if (!this.getActivity().isFinishing()) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.glAutoDrawables.size(); ++i) {
                GLAutoDrawable gLAutoDrawable = this.glAutoDrawables.get(i);
                if (!(gLAutoDrawable instanceof GLStateKeeper)) continue;
                if (((GLStateKeeper)((Object)gLAutoDrawable)).preserveGLStateAtDestroy(true)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            Log.d((String)"JogAmp.NEWT", (String)("GLStateKeeper.Mark2Preserve: Total " + this.glAutoDrawables.size() + ", OK " + n + ", Fail " + n2));
        }
        this.startAnimation(false);
        if (!this.isDelegatedActivity()) {
            super.onPause();
        }
        Log.d((String)"JogAmp.NEWT", (String)"onPause.X");
    }

    public void onStop() {
        Log.d((String)"JogAmp.NEWT", (String)"onStop.0");
        for (int i = 0; i < this.newtWindows.size(); ++i) {
            com.jogamp.newt.Window window = this.newtWindows.get(i);
            window.setVisible(false);
        }
        if (!this.isDelegatedActivity()) {
            super.onStop();
        }
        Log.d((String)"JogAmp.NEWT", (String)"onStop.X");
    }

    private void cleanup() {
        NativeSurfaceHolder nativeSurfaceHolder;
        int n;
        Log.d((String)"JogAmp.NEWT", (String)"cleanup.0");
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.glAutoDrawables.size(); ++n) {
            nativeSurfaceHolder = this.glAutoDrawables.get(n);
            if (!(nativeSurfaceHolder instanceof GLStateKeeper)) continue;
            GLStateKeeper gLStateKeeper = (GLStateKeeper)((Object)nativeSurfaceHolder);
            gLStateKeeper.preserveGLStateAtDestroy(false);
            GLEventListenerState gLEventListenerState = gLStateKeeper.clearPreservedGLState();
            if (null != gLEventListenerState) {
                gLEventListenerState.destroy();
                ++n2;
                continue;
            }
            ++n3;
        }
        Log.d((String)"JogAmp.NEWT", (String)("cleanup.1: GLStateKeeper.ForceDestroy: Total " + this.glAutoDrawables.size() + ", destroyed " + n2 + ", clean " + n3));
        for (n = 0; n < this.newtWindows.size(); ++n) {
            nativeSurfaceHolder = this.newtWindows.get(n);
            nativeSurfaceHolder.destroy();
        }
        this.newtWindows.clear();
        this.glAutoDrawables.clear();
        Log.d((String)"JogAmp.NEWT", (String)("cleanup.1: StaticContext.getContext: " + StaticContext.getContext()));
        StaticContext.clear();
        Log.d((String)"JogAmp.NEWT", (String)"cleanup.X");
    }

    public void onDestroy() {
        Log.d((String)"JogAmp.NEWT", (String)"onDestroy.0");
        this.cleanup();
        if (!this.isDelegatedActivity()) {
            super.onDestroy();
        }
        Log.d((String)"JogAmp.NEWT", (String)"onDestroy.X");
    }
}

