/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.android.av;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.Surface;
import com.jogamp.common.av.PTS;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.Clock;
import com.jogamp.common.os.Platform;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.common.os.android.StaticContext;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public class AndroidGLMediaPlayerAPI14
extends GLMediaPlayerImpl {
    static final boolean available;
    private MediaPlayer mp;
    private Camera cam;
    private long playStart = 0L;
    private volatile boolean updateSurface = false;
    private final Object updateSurfaceLock = new Object();
    private SurfaceTextureFrame singleSTexFrame = null;
    private int sTexFrameCount = 0;
    private boolean sTexFrameAttached = false;
    private volatile boolean eos = false;
    private final PTS audio_pts = new PTS(() -> GLMediaPlayer.State.Playing == this.getState() ? this.getPlaySpeed() : 0.0f);
    private final SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            AndroidGLMediaPlayerAPI14.this.wakeUp(true);
        }
    };
    private final MediaPlayer.OnCompletionListener onCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            AndroidGLMediaPlayerAPI14.this.eos = true;
        }
    };

    public static final boolean isAvailable() {
        return available;
    }

    public AndroidGLMediaPlayerAPI14() {
        if (!available) {
            throw new RuntimeException("AndroidGLMediaPlayerAPI14 not available");
        }
        this.setTextureTarget(36197);
    }

    @Override
    public final void printNativeInfo(PrintStream printStream) {
        printStream.println("AndroidGLMediaPlayerAPI14: available " + available);
    }

    @Override
    protected final boolean setPlaySpeedImpl(float f) {
        return false;
    }

    @Override
    protected final boolean setAudioVolumeImpl(float f) {
        block3: {
            if (null != this.mp) {
                try {
                    this.mp.setVolume(f, f);
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!DEBUG) break block3;
                    illegalStateException.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final boolean resumeImpl() {
        this.playStart = Platform.currentMillis();
        if (null != this.mp) {
            try {
                this.mp.start();
                this.eos = false;
                this.mp.setOnCompletionListener(this.onCompletionListener);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!DEBUG) return false;
                illegalStateException.printStackTrace();
                return false;
            }
        } else {
            if (null == this.cam) return false;
            try {
                if (!this.sTexFrameAttached) return true;
                this.cam.startPreview();
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!DEBUG) return false;
                illegalStateException.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final boolean pauseImpl() {
        if (null != this.mp) {
            this.wakeUp(false);
            try {
                this.mp.pause();
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!DEBUG) return false;
                illegalStateException.printStackTrace();
                return false;
            }
        } else {
            if (null == this.cam) return false;
            this.wakeUp(false);
            try {
                this.cam.stopPreview();
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!DEBUG) return false;
                illegalStateException.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected final int seekImpl(int n) {
        if (null != this.mp) {
            this.mp.seekTo(n);
            return this.mp.getCurrentPosition();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp(boolean bl) {
        Object object = this.updateSurfaceLock;
        synchronized (object) {
            if (bl) {
                this.updateSurface = true;
            }
            this.updateSurfaceLock.notifyAll();
        }
    }

    @Override
    protected PTS getAudioPTSImpl() {
        return this.audio_pts;
    }

    @Override
    protected PTS getUpdatedAudioPTS() {
        if (null != this.mp) {
            this.audio_pts.set(Clock.currentMillis(), this.mp.getCurrentPosition());
        } else {
            this.audio_pts.set(Clock.currentMillis(), 0);
        }
        return this.audio_pts;
    }

    @Override
    protected int getAudioQueuedDuration() {
        return 0;
    }

    @Override
    protected int getLastBufferedAudioPTS() {
        return this.audio_pts.getLast();
    }

    @Override
    protected final void destroyImpl() {
        if (null != this.mp) {
            block6: {
                this.wakeUp(false);
                try {
                    this.mp.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    if (!DEBUG) break block6;
                    illegalStateException.printStackTrace();
                }
            }
            this.mp.release();
            this.mp = null;
        }
        if (null != this.cam) {
            block7: {
                this.wakeUp(false);
                try {
                    this.cam.stopPreview();
                }
                catch (IllegalStateException illegalStateException) {
                    if (!DEBUG) break block7;
                    illegalStateException.printStackTrace();
                }
            }
            this.cam.release();
            this.cam = null;
        }
    }

    @Override
    protected void stopImpl() {
        this.destroyImpl();
    }

    @Override
    protected final void initStreamImpl(int n, String string, int n2, String string2, int n3) throws IOException {
        if (null == this.getUri()) {
            return;
        }
        if (null == this.mp && null == this.cam) {
            if (null == this.cameraPath) {
                this.mp = new MediaPlayer();
            } else {
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(this.cameraPath.decode());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.cam = 0 <= n4 && n4 < Camera.getNumberOfCameras() ? Camera.open((int)n4) : Camera.open();
            }
        }
        if (null != this.mp) {
            String[] stringArray;
            int[] nArray;
            int n5;
            if (-2 == n2) {
                this.mp.setVolume(0.0f, 0.0f);
            }
            try {
                Uri uri = Uri.parse((String)this.getUri().toString());
                this.mp.setDataSource(StaticContext.getContext(), uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(illegalStateException);
            }
            this.mp.setSurface(null);
            try {
                this.mp.prepare();
            }
            catch (IOException iOException) {
                throw new IOException("MediaPlayer failed to process stream <" + this.getUri().toString() + ">: " + iOException.getMessage(), iOException);
            }
            if (-2 == n2) {
                n5 = -2;
                nArray = new int[]{};
                stringArray = new String[]{};
            } else {
                n5 = 1;
                nArray = new int[]{1};
                stringArray = new String[]{"n/a"};
            }
            this.updateAttributes(null, new int[]{0}, new String[]{"und"}, 0, nArray, stringArray, n5, new int[0], new String[0], -2, this.mp.getVideoWidth(), this.mp.getVideoHeight(), 0, 0, 0, 0.0f, 0, 0, this.mp.getDuration(), "android", "android", null, -1, -1, -1);
        } else if (null != this.cam) {
            int[] nArray = new int[]{0, 0};
            Camera.Parameters parameters = this.cam.getParameters();
            parameters.getPreviewFpsRange(nArray);
            Camera.Size size = parameters.getPreviewSize();
            if (DEBUG) {
                int n6 = parameters.getPictureFormat();
                Camera.Size size2 = parameters.getPreferredPreviewSizeForVideo();
                System.err.println("MediaPlayer.Camera: fps " + nArray[0] + ".." + nArray[1] + ", size[pref " + AndroidGLMediaPlayerAPI14.camSz2Str(size2) + ", cur " + AndroidGLMediaPlayerAPI14.camSz2Str(size) + "], fmt " + n6);
                List list = parameters.getSupportedVideoSizes();
                if (null != list) {
                    for (int i = 0; i < list.size(); ++i) {
                        System.err.println("size #" + i + ": " + AndroidGLMediaPlayerAPI14.camSz2Str((Camera.Size)list.get(i)));
                    }
                }
            }
            this.updateAttributes(null, new int[]{0}, new String[]{"und"}, 0, new int[0], new String[0], -2, new int[0], new String[0], -2, size.width, size.height, 0, 0, 0, (float)nArray[1] / 1000.0f, 0, 0, 0, "android", "android", null, -1, -1, -1);
        }
    }

    private static String camSz2Str(Camera.Size size) {
        if (null != size) {
            return size.width + "x" + size.height;
        }
        return "n/a";
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
    }

    @Override
    protected int validateTextureCount(int n) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame, Texture texture, boolean[] blArray) throws InterruptedException {
        int n = Integer.MIN_VALUE;
        if (null != this.mp || null != this.cam) {
            SurfaceTextureFrame surfaceTextureFrame = null != textureFrame ? (SurfaceTextureFrame)textureFrame : this.singleSTexFrame;
            SurfaceTexture surfaceTexture = surfaceTextureFrame.surfaceTex;
            if (!this.sTexFrameAttached) {
                Surface surface;
                this.sTexFrameAttached = true;
                if (null != this.mp) {
                    surface = new Surface(surfaceTextureFrame.surfaceTex);
                    this.mp.setSurface(surface);
                } else {
                    surface = null;
                    try {
                        this.cam.setPreviewTexture(surfaceTextureFrame.surfaceTex);
                        this.cam.startPreview();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("MediaPlayer failed to process stream <" + this.getUri().toString() + ">: " + iOException.getMessage(), iOException);
                    }
                }
                if (null != surface) {
                    surface.release();
                }
                surfaceTexture.setOnFrameAvailableListener(this.onFrameAvailableListener);
            }
            if (this.eos || null != this.mp && !this.mp.isPlaying()) {
                this.eos = true;
                n = Integer.MAX_VALUE;
            } else {
                boolean bl = this.updateSurface;
                if (!bl) {
                    Object object = this.updateSurfaceLock;
                    synchronized (object) {
                        while (!this.updateSurface) {
                            this.updateSurfaceLock.wait();
                        }
                        bl = this.updateSurface;
                        this.updateSurface = false;
                    }
                }
                if (bl) {
                    surfaceTexture.updateTexImage();
                    n = null != this.mp ? this.mp.getCurrentPosition() : (int)(Platform.currentMillis() - this.playStart);
                }
            }
            surfaceTextureFrame.setPTS(n);
        }
        return n;
    }

    @Override
    protected TextureSequence.TextureFrame[] createTexFrames(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: 1/" + n + "): err " + AndroidGLMediaPlayerAPI14.toHexString(n2));
        }
        TextureSequence.TextureFrame[] textureFrameArray = new TextureSequence.TextureFrame[n];
        for (int i = 0; i < n; ++i) {
            textureFrameArray[i] = this.createTexImage(gL, nArray[0]);
        }
        return textureFrameArray;
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        ++this.sTexFrameCount;
        if (1 == this.sTexFrameCount) {
            this.singleSTexFrame = new SurfaceTextureFrame(this.createTexImageImpl(gL, n, this.getWidth(), this.getHeight()), new SurfaceTexture(n));
        }
        return this.singleSTexFrame;
    }

    @Override
    protected final void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        --this.sTexFrameCount;
        if (0 == this.sTexFrameCount) {
            this.singleSTexFrame = null;
            this.sTexFrameAttached = false;
            SurfaceTextureFrame surfaceTextureFrame = (SurfaceTextureFrame)textureFrame;
            surfaceTextureFrame.surfaceTex.release();
            super.destroyTexFrame(gL, textureFrame);
        }
    }

    static {
        boolean bl = false;
        if (PlatformPropsImpl.OS_TYPE.equals((Object)Platform.OSType.ANDROID) && AndroidVersion.SDK_INT >= 14) {
            bl = true;
        }
        available = bl;
    }

    public static class SurfaceTextureFrame
    extends TextureSequence.TextureFrame {
        public final SurfaceTexture surfaceTex;

        public SurfaceTextureFrame(Texture texture, SurfaceTexture surfaceTexture) {
            super(texture);
            this.surfaceTex = surfaceTexture;
        }

        @Override
        public String toString() {
            return "SurfaceTextureFrame[pts " + this.pts + " ms, l " + this.duration + " ms, texID " + this.texture.getTextureObject() + ", " + this.surfaceTex + "]";
        }
    }
}

