/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.stereo;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.math.Vec3f;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoUtil;
import com.jogamp.opengl.util.stereo.ViewerPose;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.util.stereo.DistortionMesh;
import jogamp.opengl.util.stereo.GenericStereoDevice;
import jogamp.opengl.util.stereo.ScaleAndOffset2D;

public class GenericStereoDeviceRenderer
implements StereoDeviceRenderer {
    private static final String shaderPrefix01 = "dist01";
    private static final String shaderTimewarpSuffix = "_timewarp";
    private static final String shaderChromaSuffix = "_chroma";
    private static final String shaderPlainSuffix = "_plain";
    private final GenericStereoDevice device;
    private final GenericEye[] eyes;
    private final ViewerPose viewerPose;
    private final int distortionBits;
    private final int textureCount;
    private final DimensionImmutable[] eyeTextureSizes;
    private final DimensionImmutable totalTextureSize;
    private final GLUniformData texUnit0;
    private ShaderProgram sp;
    private long frameStart = 0L;
    private static final DimensionImmutable zeroSize = new Dimension(0, 0);

    public String toString() {
        return "GenericStereo[distortion[" + StereoUtil.distortionBitsToString(this.distortionBits) + "], eyeTexSize " + Arrays.toString(this.eyeTextureSizes) + ", sbsSize " + this.totalTextureSize + ", texCount " + this.textureCount + ", texUnit " + (null != this.texUnit0 ? Integer.valueOf(this.texUnit0.intValue()) : "n/a") + ", " + PlatformPropsImpl.NEWLINE + "  " + (0 < this.eyes.length ? this.eyes[0] : "none") + ", " + PlatformPropsImpl.NEWLINE + "  " + (1 < this.eyes.length ? this.eyes[1] : "none") + "]";
    }

    GenericStereoDeviceRenderer(GenericStereoDevice genericStereoDevice, int n, int n2, Vec3f vec3f, EyeParameter[] eyeParameterArray, float f, int n3, DimensionImmutable[] dimensionImmutableArray, DimensionImmutable dimensionImmutable, RectangleImmutable[] rectangleImmutableArray) {
        int n4;
        DimensionImmutable[] dimensionImmutableArray2;
        boolean bl;
        if (eyeParameterArray.length != dimensionImmutableArray.length || eyeParameterArray.length != rectangleImmutableArray.length) {
            throw new IllegalArgumentException("eye arrays of different length");
        }
        this.device = genericStereoDevice;
        this.eyes = new GenericEye[eyeParameterArray.length];
        this.distortionBits = (n | genericStereoDevice.getMinimumDistortionBits()) & genericStereoDevice.getSupportedDistortionBits();
        boolean bl2 = bl = null != this.device.config.distortionMeshProducer && 0 != this.distortionBits;
        if (bl) {
            this.textureCount = 1 > n2 || 2 < n2 ? 2 : n2;
            this.eyeTextureSizes = dimensionImmutableArray;
            this.totalTextureSize = dimensionImmutable;
            if (1 == n2) {
                dimensionImmutableArray2 = new DimensionImmutable[eyeParameterArray.length];
                for (n4 = 0; n4 < eyeParameterArray.length; ++n4) {
                    dimensionImmutableArray2[n4] = dimensionImmutable;
                }
            } else {
                dimensionImmutableArray2 = dimensionImmutableArray;
            }
            this.texUnit0 = new GLUniformData("svr_Texture0", n3);
        } else {
            this.textureCount = 0;
            this.eyeTextureSizes = new DimensionImmutable[eyeParameterArray.length];
            dimensionImmutableArray2 = new DimensionImmutable[eyeParameterArray.length];
            for (n4 = 0; n4 < eyeParameterArray.length; ++n4) {
                this.eyeTextureSizes[n4] = zeroSize;
                dimensionImmutableArray2[n4] = zeroSize;
            }
            this.totalTextureSize = zeroSize;
            this.texUnit0 = null;
        }
        this.viewerPose = new ViewerPose();
        for (n4 = 0; n4 < eyeParameterArray.length; ++n4) {
            this.eyes[n4] = new GenericEye(genericStereoDevice, this.distortionBits, vec3f, eyeParameterArray[n4], dimensionImmutableArray2[n4], rectangleImmutableArray[n4]);
        }
        this.sp = null;
    }

    @Override
    public StereoDevice getDevice() {
        return this.device;
    }

    @Override
    public final int getDistortionBits() {
        return this.distortionBits;
    }

    @Override
    public final boolean usesSideBySideStereo() {
        return true;
    }

    @Override
    public final DimensionImmutable[] getEyeSurfaceSize() {
        return this.eyeTextureSizes;
    }

    @Override
    public final DimensionImmutable getTotalSurfaceSize() {
        return this.totalTextureSize;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    @Override
    public final int getTextureUnit() {
        return this.ppAvailable() ? this.texUnit0.intValue() : 0;
    }

    @Override
    public final boolean ppAvailable() {
        return null != this.texUnit0;
    }

    @Override
    public final void init(GL gL) {
        if (StereoDevice.DEBUG) {
            System.err.println(JoglVersion.getGLInfo(gL, null).toString());
        }
        if (null != this.sp) {
            throw new IllegalStateException("Already initialized");
        }
        if (!this.ppAvailable()) {
            return;
        }
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        boolean bl = StereoUtil.usesTimewarpDistortion(this.distortionBits);
        boolean bl2 = StereoUtil.usesChromaticDistortion(this.distortionBits);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(shaderPrefix01);
        if (!bl2 && !bl) {
            stringBuilder.append(shaderPlainSuffix);
        } else if (bl2 && !bl) {
            stringBuilder.append(shaderChromaSuffix);
        } else if (bl) {
            stringBuilder.append(shaderTimewarpSuffix);
            if (bl2) {
                stringBuilder.append(shaderChromaSuffix);
            }
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append(shaderPrefix01);
        if (bl2) {
            stringBuilder.append(shaderChromaSuffix);
        } else {
            stringBuilder.append(shaderPlainSuffix);
        }
        String string2 = stringBuilder.toString();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, GenericStereoDeviceRenderer.class, "shader", "shader/bin", string, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, GenericStereoDeviceRenderer.class, "shader", "shader/bin", string2, true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        this.sp = new ShaderProgram();
        this.sp.add(gL2ES2, shaderCode, System.err);
        this.sp.add(gL2ES2, shaderCode2, System.err);
        if (!this.sp.link(gL2ES2, System.err)) {
            throw new GLException("could not link program: " + this.sp);
        }
        this.sp.useProgram(gL2ES2, true);
        if (0 > this.texUnit0.setLocation(gL2ES2, this.sp.program())) {
            throw new GLException("Couldn't locate " + this.texUnit0);
        }
        for (int i = 0; i < this.eyes.length; ++i) {
            this.eyes[i].linkData(gL2ES2, this.sp);
        }
        this.sp.useProgram(gL2ES2, false);
    }

    @Override
    public final void dispose(GL gL) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        if (null != this.sp) {
            this.sp.useProgram(gL2ES2, false);
        }
        for (int i = 0; i < this.eyes.length; ++i) {
            this.eyes[i].dispose(gL2ES2);
        }
        if (null != this.sp) {
            this.sp.destroy(gL2ES2);
        }
    }

    @Override
    public final StereoDeviceRenderer.Eye getEye(int n) {
        return this.eyes[n];
    }

    @Override
    public final ViewerPose updateViewerPose() {
        return this.viewerPose;
    }

    @Override
    public final ViewerPose getLastViewerPose() {
        return this.viewerPose;
    }

    @Override
    public final void beginFrame(GL gL) {
        this.frameStart = Platform.currentTimeMillis();
    }

    @Override
    public final void endFrame(GL gL) {
        if (0L == this.frameStart) {
            throw new IllegalStateException("beginFrame not called");
        }
        this.frameStart = 0L;
    }

    @Override
    public final void ppBegin(GL gL) {
        if (null == this.sp) {
            throw new IllegalStateException("Not initialized");
        }
        if (0L == this.frameStart) {
            throw new IllegalStateException("beginFrame not called");
        }
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glClear(16384);
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL2ES2.glDisable(2884);
        gL2ES2.glDisable(2929);
        gL2ES2.glDisable(3042);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.sp.useProgram(gL2ES2, true);
        gL2ES2.glUniform(this.texUnit0);
    }

    @Override
    public final void ppOneEye(GL gL, int n) {
        GenericEye genericEye = this.eyes[n];
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        genericEye.updateUniform(gL2ES2, this.sp);
        genericEye.enableVBO(gL2ES2, true);
        gL2ES2.glDrawElements(4, genericEye.indexCount, 5123, 0L);
        this.eyes[n].enableVBO(gL2ES2, false);
    }

    @Override
    public final void ppEnd(GL gL) {
        this.sp.useProgram(gL.getGL2ES2(), false);
    }

    public static class GenericEye
    implements StereoDeviceRenderer.Eye {
        private final int eyeName;
        private final int distortionBits;
        private final int vertexCount;
        private final int indexCount;
        private final RectangleImmutable viewport;
        private final GLUniformData eyeToSourceUVScale;
        private final GLUniformData eyeToSourceUVOffset;
        private final GLUniformData eyeRotationStart;
        private final GLUniformData eyeRotationEnd;
        private final GLArrayDataServer iVBO;
        private final GLArrayData vboPos;
        private final GLArrayData vboParams;
        private final GLArrayData vboTexCoordsR;
        private final GLArrayData vboTexCoordsG;
        private final GLArrayData vboTexCoordsB;
        private final GLArrayDataServer indices;
        private final EyeParameter eyeParameter;

        @Override
        public final RectangleImmutable getViewport() {
            return this.viewport;
        }

        @Override
        public final EyeParameter getEyeParameter() {
            return this.eyeParameter;
        }

        GenericEye(GenericStereoDevice genericStereoDevice, int n, Vec3f vec3f, EyeParameter eyeParameter, DimensionImmutable dimensionImmutable, RectangleImmutable rectangleImmutable) {
            int n2;
            Object object;
            this.eyeName = eyeParameter.number;
            this.distortionBits = n;
            this.viewport = rectangleImmutable;
            boolean bl = null != genericStereoDevice.config.distortionMeshProducer && 0 != n;
            boolean bl2 = bl && StereoUtil.usesTimewarpDistortion(n);
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)(4 + (bl2 ? 32 : 0)));
            if (bl) {
                this.eyeToSourceUVScale = new GLUniformData("svr_EyeToSourceUVScale", 2, Buffers.slice2Float((Buffer)floatBuffer, (int)0, (int)2));
                this.eyeToSourceUVOffset = new GLUniformData("svr_EyeToSourceUVOffset", 2, Buffers.slice2Float((Buffer)floatBuffer, (int)2, (int)2));
            } else {
                this.eyeToSourceUVScale = null;
                this.eyeToSourceUVOffset = null;
            }
            if (bl2) {
                this.eyeRotationStart = new GLUniformData("svr_EyeRotationStart", 4, 4, Buffers.slice2Float((Buffer)floatBuffer, (int)4, (int)16));
                this.eyeRotationEnd = new GLUniformData("svr_EyeRotationEnd", 4, 4, Buffers.slice2Float((Buffer)floatBuffer, (int)20, (int)16));
            } else {
                this.eyeRotationStart = null;
                this.eyeRotationEnd = null;
            }
            this.eyeParameter = eyeParameter;
            if (bl) {
                object = new ScaleAndOffset2D(eyeParameter.fovhv, dimensionImmutable, rectangleImmutable);
                if (StereoDevice.DEBUG) {
                    System.err.println("XXX." + this.eyeName + ": eyeParam      " + eyeParameter);
                    System.err.println("XXX." + this.eyeName + ": uvScaleOffset " + object);
                    System.err.println("XXX." + this.eyeName + ": textureSize   " + dimensionImmutable);
                    System.err.println("XXX." + this.eyeName + ": viewport      " + rectangleImmutable);
                }
            } else {
                this.vertexCount = 0;
                this.indexCount = 0;
                this.iVBO = null;
                this.vboPos = null;
                this.vboParams = null;
                this.vboTexCoordsR = null;
                this.vboTexCoordsG = null;
                this.vboTexCoordsB = null;
                this.indices = null;
                if (StereoDevice.DEBUG) {
                    System.err.println("XXX." + this.eyeName + ": " + this);
                }
                return;
            }
            FloatBuffer floatBuffer2 = this.eyeToSourceUVScale.floatBufferValue();
            floatBuffer2.put(0, ((ScaleAndOffset2D)object).scale[0]);
            floatBuffer2.put(1, ((ScaleAndOffset2D)object).scale[1]);
            FloatBuffer floatBuffer3 = this.eyeToSourceUVOffset.floatBufferValue();
            floatBuffer3.put(0, ((ScaleAndOffset2D)object).offset[0]);
            floatBuffer3.put(1, ((ScaleAndOffset2D)object).offset[1]);
            object = genericStereoDevice.config.distortionMeshProducer.create(eyeParameter, n);
            if (null == object) {
                throw new GLException("Failed to create meshData for eye " + eyeParameter + ", and " + StereoUtil.distortionBitsToString(n));
            }
            this.vertexCount = ((DistortionMesh)object).vertexCount;
            this.indexCount = ((DistortionMesh)object).indexCount;
            boolean bl3 = StereoUtil.usesChromaticDistortion(n);
            boolean bl4 = StereoUtil.usesVignetteDistortion(n);
            int n3 = 6 + (bl3 ? 4 : 0);
            this.iVBO = GLArrayDataServer.createGLSLInterleaved(n3, 5126, false, this.vertexCount, 35044);
            this.vboPos = this.iVBO.addGLSLSubArray("svr_Position", 2, 34962);
            this.vboParams = this.iVBO.addGLSLSubArray("svr_Params", 2, 34962);
            this.vboTexCoordsR = this.iVBO.addGLSLSubArray("svr_TexCoordR", 2, 34962);
            if (bl3) {
                this.vboTexCoordsG = this.iVBO.addGLSLSubArray("svr_TexCoordG", 2, 34962);
                this.vboTexCoordsB = this.iVBO.addGLSLSubArray("svr_TexCoordB", 2, 34962);
            } else {
                this.vboTexCoordsG = null;
                this.vboTexCoordsB = null;
            }
            this.indices = GLArrayDataServer.createData(1, 5122, this.indexCount, 35044, 34963);
            FloatBuffer floatBuffer4 = (FloatBuffer)this.iVBO.getBuffer();
            for (n2 = 0; n2 < this.vertexCount; ++n2) {
                DistortionMesh.DistortionVertex distortionVertex = ((DistortionMesh)object).vertices[n2];
                int n4 = 0;
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": START VERTEX " + n2 + " / " + this.vertexCount);
                }
                if (distortionVertex.pos_size >= 2) {
                    if (StereoDevice.DUMP_DATA) {
                        System.err.println("XXX." + this.eyeName + ": pos [" + distortionVertex.data[n4] + ", " + distortionVertex.data[n4 + 1] + "]");
                    }
                    floatBuffer4.put(distortionVertex.data[n4]);
                    floatBuffer4.put(distortionVertex.data[n4 + 1]);
                } else {
                    floatBuffer4.put(0.0f);
                    floatBuffer4.put(0.0f);
                }
                n4 += distortionVertex.pos_size;
                if (distortionVertex.vignetteFactor_size >= 1 && bl4) {
                    if (StereoDevice.DUMP_DATA) {
                        System.err.println("XXX." + this.eyeName + ": vignette " + distortionVertex.data[n4]);
                    }
                    floatBuffer4.put(distortionVertex.data[n4]);
                } else {
                    floatBuffer4.put(1.0f);
                }
                n4 += distortionVertex.vignetteFactor_size;
                if (distortionVertex.timewarpFactor_size >= 1) {
                    if (StereoDevice.DUMP_DATA) {
                        System.err.println("XXX." + this.eyeName + ": timewarp " + distortionVertex.data[n4]);
                    }
                    floatBuffer4.put(distortionVertex.data[n4]);
                } else {
                    floatBuffer4.put(1.0f);
                }
                n4 += distortionVertex.timewarpFactor_size;
                if (distortionVertex.texR_size >= 2) {
                    if (StereoDevice.DUMP_DATA) {
                        System.err.println("XXX." + this.eyeName + ": texR [" + distortionVertex.data[n4] + ", " + distortionVertex.data[n4 + 1] + "]");
                    }
                    floatBuffer4.put(distortionVertex.data[n4]);
                    floatBuffer4.put(distortionVertex.data[n4 + 1]);
                } else {
                    floatBuffer4.put(1.0f);
                    floatBuffer4.put(1.0f);
                }
                n4 += distortionVertex.texR_size;
                if (bl3) {
                    if (distortionVertex.texG_size >= 2) {
                        if (StereoDevice.DUMP_DATA) {
                            System.err.println("XXX." + this.eyeName + ": texG [" + distortionVertex.data[n4] + ", " + distortionVertex.data[n4 + 1] + "]");
                        }
                        floatBuffer4.put(distortionVertex.data[n4]);
                        floatBuffer4.put(distortionVertex.data[n4 + 1]);
                    } else {
                        floatBuffer4.put(1.0f);
                        floatBuffer4.put(1.0f);
                    }
                    n4 += distortionVertex.texG_size;
                    if (distortionVertex.texB_size >= 2) {
                        if (StereoDevice.DUMP_DATA) {
                            System.err.println("XXX." + this.eyeName + ": texB [" + distortionVertex.data[n4] + ", " + distortionVertex.data[n4 + 1] + "]");
                        }
                        floatBuffer4.put(distortionVertex.data[n4]);
                        floatBuffer4.put(distortionVertex.data[n4 + 1]);
                    } else {
                        floatBuffer4.put(1.0f);
                        floatBuffer4.put(1.0f);
                    }
                    n4 += distortionVertex.texB_size;
                    continue;
                }
                n4 += distortionVertex.texG_size;
                n4 += distortionVertex.texB_size;
            }
            if (StereoDevice.DUMP_DATA) {
                System.err.println("XXX." + this.eyeName + ": iVBO " + this.iVBO);
            }
            if (StereoDevice.DUMP_DATA) {
                System.err.println("XXX." + this.eyeName + ": idx " + this.indices + ", count " + this.indexCount);
                for (n2 = 0; n2 < this.indexCount; ++n2) {
                    if (0 == n2 % 16) {
                        System.err.printf("%n%5d: ", n2);
                    }
                    System.err.printf("%5d, ", ((DistortionMesh)object).indices[n2]);
                }
                System.err.println();
            }
            ShortBuffer shortBuffer = (ShortBuffer)this.indices.getBuffer();
            shortBuffer.put(((DistortionMesh)object).indices, 0, ((DistortionMesh)object).indexCount);
            if (StereoDevice.DEBUG) {
                System.err.println("XXX." + this.eyeName + ": " + this);
            }
        }

        private void linkData(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
            if (null == this.iVBO) {
                return;
            }
            if (0 > this.vboPos.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboPos);
            }
            if (0 > this.vboParams.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboParams);
            }
            if (0 > this.vboTexCoordsR.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboTexCoordsR);
            }
            if (StereoUtil.usesChromaticDistortion(this.distortionBits)) {
                if (0 > this.vboTexCoordsG.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.vboTexCoordsG);
                }
                if (0 > this.vboTexCoordsB.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.vboTexCoordsB);
                }
            }
            if (0 > this.eyeToSourceUVScale.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.eyeToSourceUVScale);
            }
            if (0 > this.eyeToSourceUVOffset.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.eyeToSourceUVOffset);
            }
            if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
                if (0 > this.eyeRotationStart.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.eyeRotationStart);
                }
                if (0 > this.eyeRotationEnd.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.eyeRotationEnd);
                }
            }
            this.iVBO.seal(gL2ES2, true);
            this.iVBO.enableBuffer(gL2ES2, false);
            this.indices.seal(gL2ES2, true);
            this.indices.enableBuffer(gL2ES2, false);
        }

        void dispose(GL2ES2 gL2ES2) {
            if (null == this.iVBO) {
                return;
            }
            this.iVBO.destroy(gL2ES2);
            this.indices.destroy(gL2ES2);
        }

        void enableVBO(GL2ES2 gL2ES2, boolean bl) {
            if (null == this.iVBO) {
                return;
            }
            this.iVBO.enableBuffer(gL2ES2, bl);
            this.indices.bindBuffer(gL2ES2, bl);
        }

        void updateUniform(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
            if (null == this.iVBO) {
                return;
            }
            gL2ES2.glUniform(this.eyeToSourceUVScale);
            gL2ES2.glUniform(this.eyeToSourceUVOffset);
            if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
                gL2ES2.glUniform(this.eyeRotationStart);
                gL2ES2.glUniform(this.eyeRotationEnd);
            }
        }

        public String toString() {
            String string = null == this.iVBO ? ", no post-processing" : ", uvScale[" + this.eyeToSourceUVScale.floatBufferValue().get(0) + ", " + this.eyeToSourceUVScale.floatBufferValue().get(1) + "], uvOffset[" + this.eyeToSourceUVOffset.floatBufferValue().get(0) + ", " + this.eyeToSourceUVOffset.floatBufferValue().get(1) + "]";
            return "Eye[" + this.eyeName + ", viewport " + this.viewport + ", " + this.eyeParameter + ", vertices " + this.vertexCount + ", indices " + this.indexCount + string + ", desc " + this.eyeParameter + "]";
        }
    }
}

