/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.glu.mipmap.Extract1010102;
import jogamp.opengl.glu.mipmap.Extract1555rev;
import jogamp.opengl.glu.mipmap.Extract2101010rev;
import jogamp.opengl.glu.mipmap.Extract233rev;
import jogamp.opengl.glu.mipmap.Extract332;
import jogamp.opengl.glu.mipmap.Extract4444;
import jogamp.opengl.glu.mipmap.Extract4444rev;
import jogamp.opengl.glu.mipmap.Extract5551;
import jogamp.opengl.glu.mipmap.Extract565;
import jogamp.opengl.glu.mipmap.Extract565rev;
import jogamp.opengl.glu.mipmap.Extract8888;
import jogamp.opengl.glu.mipmap.Extract8888rev;
import jogamp.opengl.glu.mipmap.ExtractFloat;
import jogamp.opengl.glu.mipmap.ExtractSByte;
import jogamp.opengl.glu.mipmap.ExtractSInt;
import jogamp.opengl.glu.mipmap.ExtractSShort;
import jogamp.opengl.glu.mipmap.ExtractUByte;
import jogamp.opengl.glu.mipmap.ExtractUInt;
import jogamp.opengl.glu.mipmap.ExtractUShort;
import jogamp.opengl.glu.mipmap.HalveImage;
import jogamp.opengl.glu.mipmap.Image;
import jogamp.opengl.glu.mipmap.Mipmap;
import jogamp.opengl.glu.mipmap.PixelStorageModes;
import jogamp.opengl.glu.mipmap.ScaleInternal;

public class BuildMipmap {
    private static final boolean DEBUG = Debug.debug((String)"BuildMipmap");
    private static final boolean VERBOSE = Debug.verbose();
    private static final int TARGA_HEADER_SIZE = 18;

    public static int gluBuild1DMipmapLevelsCore(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        ShortBuffer shortBuffer = null;
        ShortBuffer shortBuffer2 = null;
        ShortBuffer shortBuffer3 = null;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n2, n5, n6) == 0);
        assert (n3 >= 1);
        int n10 = n4;
        int n11 = Mipmap.computeLog(n10);
        n11 += n7;
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        try {
            shortBuffer = Buffers.newDirectByteBuffer((int)Mipmap.image_size(n3, 1, n5, 5123)).asShortBuffer();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return 100902;
        }
        int n12 = n3;
        Image.fill_image(pixelStorageModes, n3, 1, n5, n6, Mipmap.is_index(n5), byteBuffer, shortBuffer);
        int n13 = Mipmap.elements_per_group(n5, n6);
        gL.glPixelStorei(3317, 2);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (int i = n7; i <= n11; ++i) {
            if (n12 == n10) {
                if (n8 <= i && i <= n9) {
                    gL.getGL2().glTexImage1D(n, i, n2, n12, 0, n5, 5123, (Buffer)shortBuffer);
                }
            } else {
                if (shortBuffer2 == null) {
                    int n14 = Mipmap.image_size(n10, 1, n5, 5123);
                    try {
                        shortBuffer2 = Buffers.newDirectByteBuffer((int)n14).asShortBuffer();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ScaleInternal.scale_internal(n13, n12, 1, shortBuffer, n10, 1, shortBuffer2);
                shortBuffer3 = shortBuffer2;
                shortBuffer2 = shortBuffer;
                shortBuffer = shortBuffer3;
                n12 = n10;
                if (n8 <= i && i <= n9) {
                    gL.getGL2().glTexImage1D(n, i, n2, n12, 0, n5, 5123, (Buffer)shortBuffer);
                }
            }
            if (n10 <= 1) continue;
            n10 /= 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int bitmapBuild2DMipmaps(GL gL, int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ShortBuffer shortBuffer = null;
        ShortBuffer shortBuffer2 = null;
        ShortBuffer shortBuffer3 = null;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        Mipmap.closestFit(gL, n, n3, n4, n2, n5, n6, nArray, nArray2);
        int n7 = Mipmap.computeLog(nArray[0]);
        int n8 = Mipmap.computeLog(nArray2[0]);
        if (n8 > n7) {
            n7 = n8;
        }
        try {
            shortBuffer = Buffers.newDirectByteBuffer((int)Mipmap.image_size(n3, n4, n5, 5123)).asShortBuffer();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return 100902;
        }
        int n9 = n3;
        int n10 = n4;
        Image.fill_image(pixelStorageModes, n3, n4, n5, n6, Mipmap.is_index(n5), byteBuffer, shortBuffer);
        int n11 = Mipmap.elements_per_group(n5, n6);
        gL.glPixelStorei(3317, 2);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (n8 = 0; n8 < n7; ++n8) {
            if (n9 == nArray[0] && n10 == nArray2[0]) {
                shortBuffer.rewind();
                gL.glTexImage2D(n, n8, n2, n9, n10, 0, n5, 5123, (Buffer)shortBuffer);
            } else {
                if (shortBuffer2 == null) {
                    int n12 = Mipmap.image_size(nArray[0], nArray2[0], n5, 5123);
                    try {
                        shortBuffer2 = Buffers.newDirectByteBuffer((int)n12).asShortBuffer();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ScaleInternal.scale_internal(n11, n9, n10, shortBuffer, nArray[0], nArray2[0], shortBuffer2);
                shortBuffer3 = shortBuffer2;
                shortBuffer2 = shortBuffer;
                shortBuffer = shortBuffer3;
                n9 = nArray[0];
                n10 = nArray2[0];
                shortBuffer.rewind();
                gL.glTexImage2D(n, n8, n2, n9, n10, 0, n5, 5123, (Buffer)shortBuffer);
            }
            if (nArray2[0] > 1) {
                nArray[0] = nArray[0] / 2;
            }
            if (nArray2[0] <= 1) continue;
            nArray2[0] = nArray2[0] / 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int gluBuild2DMipmapLevelsCore(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        ByteBuffer byteBuffer4 = null;
        Object var23_16 = null;
        int n17 = -1;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n2, n7, n8) == 0);
        assert (n3 >= 1 && n4 >= 1);
        if (n8 == 6656) {
            return BuildMipmap.bitmapBuild2DMipmaps(gL, n, n2, n3, n4, n7, n8, byteBuffer);
        }
        int n18 = n5;
        int n19 = n6;
        int n20 = Mipmap.computeLog(n18);
        int n21 = Mipmap.computeLog(n19);
        if (n21 > n20) {
            n20 = n21;
        }
        n20 += n9;
        Mipmap.retrieveStoreModes(gL, pixelStorageModes);
        boolean bl = pixelStorageModes.getUnpackSwapBytes();
        int n22 = Mipmap.elements_per_group(n7, n8);
        int n23 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n3;
        int n24 = Mipmap.bytes_per_element(n8);
        int n25 = n24 * n22;
        if (n24 == 1) {
            bl = false;
        }
        if ((n16 = (n15 = n23 * n25) % pixelStorageModes.getUnpackAlignment()) != 0) {
            n15 += pixelStorageModes.getUnpackAlignment() - n16;
        }
        n17 = pixelStorageModes.getUnpackSkipRows() * n15 + pixelStorageModes.getUnpackSkipPixels() * n25;
        byteBuffer.position(n17);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        n21 = n9;
        if (n3 == n18 && n4 == n19) {
            if (n10 <= n21 && n21 <= n11) {
                byteBuffer.rewind();
                gL.glTexImage2D(n, n21, n2, n3, n4, 0, n7, n8, (Buffer)byteBuffer);
            }
            if (n20 == 0) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 0;
            }
            n14 = n18 / 2;
            n13 = n19 / 2;
            if (n14 < 1) {
                n14 = 1;
            }
            if (n13 < 1) {
                n13 = 1;
            }
            n12 = Mipmap.image_size(n14, n13, n7, n8);
            try {
                switch (n8) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n12);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            if (byteBuffer3 != null) {
                switch (n8) {
                    case 5121: {
                        HalveImage.halveImage_ubyte(n22, n3, n4, byteBuffer, byteBuffer3, n24, n15, n25);
                        break;
                    }
                    case 5120: {
                        HalveImage.halveImage_byte(n22, n3, n4, byteBuffer, byteBuffer3, n24, n15, n25);
                        break;
                    }
                    case 5123: {
                        HalveImage.halveImage_ushort(n22, n3, n4, byteBuffer, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                        break;
                    }
                    case 5122: {
                        HalveImage.halveImage_short(n22, n3, n4, byteBuffer, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                        break;
                    }
                    case 5125: {
                        HalveImage.halveImage_uint(n22, n3, n4, byteBuffer, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                        break;
                    }
                    case 5124: {
                        HalveImage.halveImage_int(n22, n3, n4, byteBuffer, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                        break;
                    }
                    case 5126: {
                        HalveImage.halveImage_float(n22, n3, n4, byteBuffer, byteBuffer3.asFloatBuffer(), n24, n15, n25, bl);
                        break;
                    }
                    case 32818: {
                        assert (n7 == 6407);
                        HalveImage.halveImagePackedPixel(3, new Extract332(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33634: {
                        assert (n7 == 6407);
                        HalveImage.halveImagePackedPixel(3, new Extract233rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33635: {
                        HalveImage.halveImagePackedPixel(3, new Extract565(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33636: {
                        HalveImage.halveImagePackedPixel(3, new Extract565rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 32819: {
                        HalveImage.halveImagePackedPixel(4, new Extract4444(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33637: {
                        HalveImage.halveImagePackedPixel(4, new Extract4444rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 32820: {
                        HalveImage.halveImagePackedPixel(4, new Extract5551(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33638: {
                        HalveImage.halveImagePackedPixel(4, new Extract1555rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 32821: {
                        HalveImage.halveImagePackedPixel(4, new Extract8888(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33639: {
                        HalveImage.halveImagePackedPixel(4, new Extract8888rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 36342: {
                        HalveImage.halveImagePackedPixel(4, new Extract1010102(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    case 33640: {
                        HalveImage.halveImagePackedPixel(4, new Extract2101010rev(), n3, n4, byteBuffer, byteBuffer3, n24, n15, bl);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            n18 = n3 / 2;
            n19 = n4 / 2;
            if (n18 < 1) {
                n18 = 1;
            }
            if (n19 < 1) {
                n19 = 1;
            }
            bl = false;
            n15 = n18 * n25;
            n12 = Mipmap.image_size(n18, n19, n7, n8);
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            try {
                switch (n8) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n12);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            n21 = n9 + 1;
        } else {
            n12 = Mipmap.image_size(n18, n19, n7, n8);
            try {
                switch (n8) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n12);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                return 100902;
            }
            byteBuffer.position(n17);
            switch (n8) {
                case 5121: {
                    ScaleInternal.scale_internal_ubyte(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, n25);
                    break;
                }
                case 5120: {
                    ScaleInternal.scale_internal_byte(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, n25);
                    break;
                }
                case 5123: {
                    ScaleInternal.scale_internal_ushort(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5122: {
                    ScaleInternal.scale_internal_ushort(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5125: {
                    ScaleInternal.scale_internal_uint(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5124: {
                    ScaleInternal.scale_internal_int(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5126: {
                    ScaleInternal.scale_internal_float(n22, n3, n4, byteBuffer, n18, n19, byteBuffer3.asFloatBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 32818: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract332(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33634: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract233rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33635: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract565(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33636: {
                    ScaleInternal.scaleInternalPackedPixel(3, new Extract565rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32819: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract4444(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33637: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract4444rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32820: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract5551(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33638: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract1555rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32821: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract8888(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33639: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract8888rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 36342: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract1010102(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33640: {
                    ScaleInternal.scaleInternalPackedPixel(4, new Extract2101010rev(), n3, n4, byteBuffer, n18, n19, byteBuffer3, n24, n15, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            bl = false;
            n15 = n18 * n25;
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            if (n20 != 0) {
                n14 = n18 / 2;
                n13 = n19 / 2;
                if (n14 < 1) {
                    n14 = 1;
                }
                if (n13 < 1) {
                    n13 = 1;
                }
                n12 = Mipmap.image_size(n14, n13, n7, n8);
                try {
                    switch (n8) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 32818: 
                        case 32819: 
                        case 32820: 
                        case 32821: 
                        case 33634: 
                        case 33635: 
                        case 33636: 
                        case 33637: 
                        case 33638: 
                        case 33639: 
                        case 33640: 
                        case 36342: {
                            byteBuffer3 = Buffers.newDirectByteBuffer((int)n12);
                            break;
                        }
                        default: {
                            return 100900;
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    return 100902;
                }
            }
            n21 = n9;
        }
        gL.glPixelStorei(3312, 0);
        if (n10 <= n21 && n21 <= n11) {
            byteBuffer2.rewind();
            gL.glTexImage2D(n, n21, n2, n18, n19, 0, n7, n8, (Buffer)byteBuffer2);
            if (DEBUG) {
                System.err.println("GL Error(" + n21 + "): " + gL.glGetError());
                if (VERBOSE) {
                    byteBuffer2.limit(Mipmap.image_size(n18, n19, n7, n8));
                    BuildMipmap.writeTargaFile("glu2DMipmapJ" + n21 + ".tga", byteBuffer2, n18, n19);
                    byteBuffer2.clear();
                }
            }
        }
        ++n21;
        while (n21 <= n20) {
            byteBuffer2.rewind();
            byteBuffer3.rewind();
            switch (n8) {
                case 5121: {
                    HalveImage.halveImage_ubyte(n22, n18, n19, byteBuffer2, byteBuffer3, n24, n15, n25);
                    break;
                }
                case 5120: {
                    HalveImage.halveImage_byte(n22, n18, n19, byteBuffer2, byteBuffer3, n24, n15, n25);
                    break;
                }
                case 5123: {
                    HalveImage.halveImage_ushort(n22, n18, n19, byteBuffer2, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5122: {
                    HalveImage.halveImage_short(n22, n18, n19, byteBuffer2, byteBuffer3.asShortBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5125: {
                    HalveImage.halveImage_uint(n22, n18, n19, byteBuffer2, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5124: {
                    HalveImage.halveImage_int(n22, n18, n19, byteBuffer2, byteBuffer3.asIntBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 5126: {
                    HalveImage.halveImage_float(n22, n18, n19, byteBuffer2, byteBuffer3.asFloatBuffer(), n24, n15, n25, bl);
                    break;
                }
                case 32818: {
                    assert (n7 == 6407);
                    HalveImage.halveImagePackedPixel(3, new Extract332(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33634: {
                    assert (n7 == 6407);
                    HalveImage.halveImagePackedPixel(3, new Extract233rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33635: {
                    HalveImage.halveImagePackedPixel(3, new Extract565(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33636: {
                    HalveImage.halveImagePackedPixel(3, new Extract565rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32819: {
                    HalveImage.halveImagePackedPixel(4, new Extract4444(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33637: {
                    HalveImage.halveImagePackedPixel(4, new Extract4444rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32820: {
                    HalveImage.halveImagePackedPixel(4, new Extract5551(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33638: {
                    HalveImage.halveImagePackedPixel(4, new Extract1555rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 32821: {
                    HalveImage.halveImagePackedPixel(4, new Extract8888(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33639: {
                    HalveImage.halveImagePackedPixel(4, new Extract8888rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 36342: {
                    HalveImage.halveImagePackedPixel(4, new Extract1010102(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                case 33640: {
                    HalveImage.halveImagePackedPixel(4, new Extract2101010rev(), n18, n19, byteBuffer2, byteBuffer3, n24, n15, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            byteBuffer4 = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            byteBuffer3 = byteBuffer4;
            if (n18 > 1) {
                n18 /= 2;
                n15 /= 2;
            }
            if (n19 > 1) {
                n19 /= 2;
            }
            if ((n14 = n15 % pixelStorageModes.getUnpackAlignment()) == 0) {
                if (n10 <= n21 && n21 <= n11) {
                    byteBuffer2.rewind();
                    gL.glTexImage2D(n, n21, n2, n18, n19, 0, n7, n8, (Buffer)byteBuffer2);
                    if (DEBUG) {
                        System.err.println("GL Error(" + n21 + "): " + gL.glGetError());
                        if (VERBOSE) {
                            byteBuffer2.limit(Mipmap.image_size(n18, n19, n7, n8));
                            BuildMipmap.writeTargaFile("glu2DMipmapJ" + n21 + ".tga", byteBuffer2, n18, n19);
                            byteBuffer2.clear();
                        }
                    }
                }
            } else {
                n13 = n15 + pixelStorageModes.getUnpackAlignment() - n14;
                ByteBuffer byteBuffer5 = null;
                try {
                    byteBuffer5 = ByteBuffer.allocateDirect(n13 * n19);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    return 100902;
                }
                byteBuffer2.rewind();
                for (int i = 0; i < n19; ++i) {
                    byteBuffer5.position(n13 * i);
                    for (int j = 0; j < n15; ++j) {
                        byteBuffer5.put(byteBuffer2.get());
                    }
                }
                if (n10 <= n21 && n21 <= n11) {
                    byteBuffer5.rewind();
                    gL.glTexImage2D(n, n21, n2, n18, n19, 0, n7, n8, (Buffer)byteBuffer5);
                    if (DEBUG) {
                        System.err.println("GL Error(" + n21 + " padded): " + gL.glGetError());
                        if (VERBOSE) {
                            BuildMipmap.writeTargaFile("glu2DMipmapJ" + n21 + ".tga", byteBuffer5, n18, n19);
                        }
                    }
                }
            }
            ++n21;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int fastBuild2DMipmaps(GL gL, PixelStorageModes pixelStorageModes, int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        int n7;
        int n8;
        ByteBuffer byteBuffer2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Mipmap.closestFit(gL, n, n3, n4, n2, n5, n6, nArray, nArray2);
        int n9 = Mipmap.computeLog(nArray[0]);
        int n10 = Mipmap.computeLog(nArray2[0]);
        if (n10 > n9) {
            n9 = n10;
        }
        int n11 = Mipmap.elements_per_group(n5, n6);
        ByteBuffer byteBuffer3 = null;
        if (pixelStorageModes.getUnpackSkipRows() == 0 && pixelStorageModes.getUnpackSkipPixels() == 0) {
            byteBuffer2 = byteBuffer;
            n8 = n3;
            n7 = n4;
        } else {
            try {
                byteBuffer2 = Buffers.newDirectByteBuffer((int)Mipmap.image_size(n3, n4, n5, 5121));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return 100902;
            }
            n8 = n3;
            n7 = n4;
            int n12 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n3;
            int n13 = n12 * n11;
            int n14 = n3 * n11;
            int n15 = pixelStorageModes.getUnpackSkipRows() * n13 + pixelStorageModes.getUnpackSkipPixels() * n11;
            for (int i = 0; i < n4; ++i) {
                int n16 = n15;
                byteBuffer.position(n16);
                for (int j = 0; j < n14; ++j) {
                    byteBuffer2.put(byteBuffer.get());
                }
                n15 += n13;
            }
        }
        gL.glPixelStorei(3317, 1);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3312, 0);
        for (n10 = 0; n10 <= n9; ++n10) {
            if (n8 == nArray[0] && n7 == nArray2[0]) {
                byteBuffer2.rewind();
                gL.glTexImage2D(n, n10, n2, n8, n7, 0, n5, 5121, (Buffer)byteBuffer2);
            } else {
                if (byteBuffer3 == null) {
                    int n17 = Mipmap.image_size(nArray[0], nArray2[0], n5, 5121);
                    try {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n17);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                        return 100902;
                    }
                }
                ByteBuffer byteBuffer4 = byteBuffer3;
                byteBuffer3 = byteBuffer2;
                byteBuffer2 = byteBuffer4;
                n8 = nArray[0];
                n7 = nArray2[0];
                byteBuffer2.rewind();
                gL.glTexImage2D(n, n10, n2, n8, n7, 0, n5, 5121, (Buffer)byteBuffer2);
            }
            if (nArray[0] > 1) {
                nArray[0] = nArray[0] / 2;
            }
            if (nArray2[0] <= 1) continue;
            nArray2[0] = nArray2[0] / 2;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        return 0;
    }

    public static int gluBuild3DMipmapLevelsCore(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = -1;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        assert (Mipmap.checkMipmapArgs(n2, n9, n10) == 0);
        assert (n3 >= 1 && n4 >= 1 && n5 >= 1);
        assert (n10 != 6656);
        ByteBuffer byteBuffer3 = null;
        ByteBuffer byteBuffer4 = null;
        int n19 = n6;
        int n20 = n7;
        int n21 = n8;
        int n22 = Mipmap.computeLog(n19);
        int n23 = Mipmap.computeLog(n20);
        if (n23 > n22) {
            n22 = n23;
        }
        if ((n23 = Mipmap.computeLog(n21)) > n22) {
            n22 = n23;
        }
        n22 += n11;
        Mipmap.retrieveStoreModes3D(gL, pixelStorageModes);
        boolean bl = pixelStorageModes.getUnpackSwapBytes();
        int n24 = Mipmap.elements_per_group(n9, n10);
        int n25 = pixelStorageModes.getUnpackRowLength() > 0 ? pixelStorageModes.getUnpackRowLength() : n3;
        int n26 = Mipmap.bytes_per_element(n10);
        int n27 = n26 * n24;
        if (n26 == 1) {
            bl = false;
        }
        int n28 = pixelStorageModes.getUnpackImageHeight() > 0 ? pixelStorageModes.getUnpackImageHeight() : n4;
        int n29 = n25 * n27;
        int n30 = n29 % pixelStorageModes.getUnpackAlignment();
        if (n30 != 0) {
            n29 += pixelStorageModes.getUnpackAlignment() - n30;
        }
        int n31 = n28 * n29;
        ByteBuffer byteBuffer5 = ByteBuffer.wrap(byteBuffer.array());
        n18 = pixelStorageModes.getUnpackSkipRows() * n29 + pixelStorageModes.getUnpackSkipPixels() * n27 + pixelStorageModes.getUnpackSkipImages() * n31;
        byteBuffer5.position(n18);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(32877, 0);
        gL.glPixelStorei(32878, 0);
        n23 = n11;
        if (n3 == n19 && n4 == n20 && n5 == n21) {
            if (n12 <= n23 && n23 <= n13) {
                gL.getGL2().glTexImage3D(n, n23, n2, n3, n4, n5, 0, n9, n10, (Buffer)byteBuffer5);
            }
            if (n22 == 0) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 0;
            }
            n17 = n19 / 2;
            n16 = n20 / 2;
            n15 = n21 / 2;
            if (n17 < 1) {
                n17 = 1;
            }
            if (n16 < 1) {
                n16 = 1;
            }
            if (n15 < 1) {
                n15 = 1;
            }
            n14 = Mipmap.imageSize3D(n17, n16, n15, n9, n10);
            try {
                switch (n10) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n14);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            if (byteBuffer3 != null) {
                switch (n10) {
                    case 5121: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractUByte(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_ubyte(n24, n3, n4, byteBuffer5, byteBuffer3, n26, n29, n27);
                        break;
                    }
                    case 5120: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractSByte(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_byte(n24, n3, n4, byteBuffer5, byteBuffer3, n26, n29, n27);
                        break;
                    }
                    case 5123: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractUShort(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_ushort(n24, n3, n4, byteBuffer5, byteBuffer3.asShortBuffer(), n26, n29, n27, bl);
                        break;
                    }
                    case 5122: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractSShort(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_short(n24, n3, n4, byteBuffer5, byteBuffer3.asShortBuffer(), n26, n29, n27, bl);
                        break;
                    }
                    case 5125: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractUInt(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_uint(n24, n3, n4, byteBuffer5, byteBuffer3.asIntBuffer(), n26, n29, n27, bl);
                        break;
                    }
                    case 5124: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractSInt(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_int(n24, n3, n4, byteBuffer5, byteBuffer3.asIntBuffer(), n26, n29, n27, bl);
                        break;
                    }
                    case 5126: {
                        if (n5 > 1) {
                            HalveImage.halveImage3D(n24, new ExtractFloat(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                            break;
                        }
                        HalveImage.halveImage_float(n24, n3, n4, byteBuffer5, byteBuffer3.asFloatBuffer(), n26, n29, n27, bl);
                        break;
                    }
                    case 32818: {
                        assert (n9 == 6407);
                        HalveImage.halveImagePackedPixel3D(3, new Extract332(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33634: {
                        assert (n9 == 6407);
                        HalveImage.halveImagePackedPixel3D(3, new Extract233rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33635: {
                        HalveImage.halveImagePackedPixel3D(3, new Extract565(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33636: {
                        HalveImage.halveImagePackedPixel3D(3, new Extract565rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 32819: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract4444(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33637: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract4444rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 32820: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract5551(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33638: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract1555rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 32821: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract8888(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33639: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract8888rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 36342: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract1010102(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    case 33640: {
                        HalveImage.halveImagePackedPixel3D(4, new Extract2101010rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            n19 = n3 / 2;
            n20 = n4 / 2;
            n21 = n5 / 2;
            if (n19 < 1) {
                n19 = 1;
            }
            if (n20 < 1) {
                n20 = 1;
            }
            if (n21 < 1) {
                n21 = 1;
            }
            bl = false;
            n29 = n19 * n27;
            n31 = n29 * n20;
            n14 = Mipmap.imageSize3D(n19, n20, n21, n9, n10);
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            try {
                switch (n10) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n14);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            n23 = n11 + 1;
        } else {
            n14 = Mipmap.imageSize3D(n19, n20, n21, n9, n10);
            try {
                switch (n10) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 32818: 
                    case 32819: 
                    case 32820: 
                    case 32821: 
                    case 33634: 
                    case 33635: 
                    case 33636: 
                    case 33637: 
                    case 33638: 
                    case 33639: 
                    case 33640: 
                    case 36342: {
                        byteBuffer3 = Buffers.newDirectByteBuffer((int)n14);
                        break;
                    }
                    default: {
                        return 100900;
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                return 100902;
            }
            ScaleInternal.gluScaleImage3D(gL, n9, n3, n4, n5, n10, byteBuffer5, n19, n20, n21, n10, byteBuffer3);
            bl = false;
            n29 = n19 * n27;
            n31 = n29 * n20;
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            if (n22 != 0) {
                n17 = n19 / 2;
                n16 = n20 / 2;
                n15 = n21 / 2;
                if (n17 < 1) {
                    n17 = 1;
                }
                if (n16 < 1) {
                    n16 = 1;
                }
                if (n15 < 1) {
                    n15 = 1;
                }
                n14 = Mipmap.imageSize3D(n17, n16, n15, n9, n10);
                try {
                    switch (n10) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 32818: 
                        case 32819: 
                        case 32820: 
                        case 32821: 
                        case 33634: 
                        case 33635: 
                        case 33636: 
                        case 33637: 
                        case 33638: 
                        case 33639: 
                        case 33640: 
                        case 36342: {
                            byteBuffer3 = Buffers.newDirectByteBuffer((int)n14);
                            break;
                        }
                        default: {
                            return 100900;
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
                    gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
                    gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
                    gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
                    gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
                    gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
                    gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
                    return 100902;
                }
            }
            n23 = n11;
        }
        gL.glPixelStorei(3312, 0);
        if (n12 <= n23 && n23 <= n13) {
            byteBuffer5.position(n18);
            gL.getGL2().glTexImage3D(n, n23, n2, n3, n4, n5, 0, n9, n10, (Buffer)byteBuffer5);
        }
        ++n23;
        while (n23 <= n22) {
            switch (n10) {
                case 5121: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractUByte(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_ubyte(n24, n3, n4, byteBuffer5, byteBuffer3, n26, n29, n27);
                    break;
                }
                case 5120: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractSByte(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_byte(n24, n3, n4, byteBuffer5, byteBuffer3, n26, n29, n27);
                    break;
                }
                case 5123: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractUShort(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_ushort(n24, n3, n4, byteBuffer5, byteBuffer3.asShortBuffer(), n26, n29, n27, bl);
                    break;
                }
                case 5122: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractSShort(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_short(n24, n3, n4, byteBuffer5, byteBuffer3.asShortBuffer(), n26, n29, n27, bl);
                    break;
                }
                case 5125: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractUInt(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_uint(n24, n3, n4, byteBuffer5, byteBuffer3.asIntBuffer(), n26, n29, n27, bl);
                    break;
                }
                case 5124: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractSInt(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_int(n24, n3, n4, byteBuffer5, byteBuffer3.asIntBuffer(), n26, n29, n27, bl);
                    break;
                }
                case 5126: {
                    if (n5 > 1) {
                        HalveImage.halveImage3D(n24, new ExtractFloat(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n27, n29, n31, bl);
                        break;
                    }
                    HalveImage.halveImage_float(n24, n3, n4, byteBuffer5, byteBuffer3.asFloatBuffer(), n26, n29, n27, bl);
                    break;
                }
                case 32818: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract332(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33634: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract233rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33635: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract565(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33636: {
                    HalveImage.halveImagePackedPixel3D(3, new Extract565rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 32819: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract4444(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33637: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract4444rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 32820: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract5551(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33638: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract1555rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 32821: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract8888(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33639: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract8888rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 36342: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract1010102(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                case 33640: {
                    HalveImage.halveImagePackedPixel3D(4, new Extract2101010rev(), n3, n4, n5, byteBuffer5, byteBuffer3, n26, n29, n31, bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            byteBuffer2 = byteBuffer4;
            byteBuffer4 = byteBuffer3;
            byteBuffer3 = byteBuffer2;
            if (n19 > 1) {
                n19 /= 2;
                n29 /= 2;
            }
            if (n20 > 1) {
                n31 = n29 * (n20 /= 2);
            }
            if (n21 > 1) {
                n21 /= 2;
            }
            if (n12 <= n23 && n23 <= n13) {
                byteBuffer5.position(n18);
                gL.getGL2().glTexImage3D(n, n23, n2, n3, n4, n5, 0, n9, n10, (Buffer)byteBuffer5);
            }
            ++n23;
        }
        gL.glPixelStorei(3317, pixelStorageModes.getUnpackAlignment());
        gL.glPixelStorei(3315, pixelStorageModes.getUnpackSkipRows());
        gL.glPixelStorei(3316, pixelStorageModes.getUnpackSkipPixels());
        gL.glPixelStorei(3314, pixelStorageModes.getUnpackRowLength());
        gL.glPixelStorei(3312, pixelStorageModes.getUnpackSwapBytes() ? 1 : 0);
        gL.glPixelStorei(32877, pixelStorageModes.getUnpackSkipImages());
        gL.glPixelStorei(32878, pixelStorageModes.getUnpackImageHeight());
        return 0;
    }

    private static void writeTargaFile(String string, ByteBuffer byteBuffer, int n, int n2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(18);
            byteBuffer2.put(0, (byte)0).put(1, (byte)0);
            byteBuffer2.put(2, (byte)2);
            byteBuffer2.put(12, (byte)(n & 0xFF));
            byteBuffer2.put(13, (byte)(n >> 8));
            byteBuffer2.put(14, (byte)(n2 & 0xFF));
            byteBuffer2.put(15, (byte)(n2 >> 8));
            byteBuffer2.put(16, (byte)24);
            fileOutputStream.write(byteBuffer2.array());
            fileOutputStream.write(byteBuffer.array());
            byteBuffer.clear();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

