/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.tess.Triangulation;
import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec3f;
import com.jogamp.math.VectorUtil;
import com.jogamp.math.Vert2fImmutable;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.geom.plane.Path2F;
import com.jogamp.math.geom.plane.Winding;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jogamp.opengl.Debug;

public final class OutlineShape
implements Comparable<OutlineShape> {
    private static final boolean FORCE_COMPLEXSHAPE = Debug.debug((String)"graph.curve.triangulation.force.complexshape");
    private static final boolean FORCE_SIMPLESHAPE = Debug.debug((String)"graph.curve.triangulation.force.simpleshape");
    public static final float DEFAULT_SHARPNESS = 0.5f;
    private static final int DIRTY_BOUNDS = 1;
    private static final int DIRTY_VERTICES = 2;
    private static final int DIRTY_TRIANGLES = 4;
    private static final int DIRTY_CONVEX = 8;
    private static final int OVERRIDE_CONVEX = 16;
    final ArrayList<Outline> outlines;
    private final AABBox bbox;
    private final ArrayList<Triangle> triangles;
    private final ArrayList<Vertex> vertices;
    private int addedVerticeCount;
    private boolean complexShape;
    private VerticesState outlineState;
    private int dirtyBits;
    private float sharpness;
    private final Vec3f tmpV1 = new Vec3f();
    private final Vec3f tmpV2 = new Vec3f();
    private final Vec3f tmpV3 = new Vec3f();
    private static Comparator<Outline> reversSizeComparator = new Comparator<Outline>(){

        @Override
        public int compare(Outline outline, Outline outline2) {
            return outline2.compareTo(outline);
        }
    };

    public OutlineShape() {
        this.outlines = new ArrayList(3);
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox = new AABBox();
        this.triangles = new ArrayList();
        this.vertices = new ArrayList();
        this.addedVerticeCount = 0;
        this.complexShape = FORCE_COMPLEXSHAPE;
        this.dirtyBits = 0;
        this.sharpness = 0.5f;
    }

    public final int getAddedVerticeCount() {
        return this.addedVerticeCount;
    }

    public final float getSharpness() {
        return this.sharpness;
    }

    public final void setSharpness(float f) {
        if (this.sharpness != f) {
            this.clearCache();
            this.sharpness = f;
        }
    }

    public final void clear() {
        this.outlines.clear();
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox.reset();
        this.vertices.clear();
        this.triangles.clear();
        this.addedVerticeCount = 0;
        this.complexShape = FORCE_COMPLEXSHAPE;
        this.dirtyBits = 0;
    }

    public final void clearCache() {
        this.vertices.clear();
        this.triangles.clear();
        this.dirtyBits |= 0xE;
    }

    public final int getOutlineCount() {
        return this.outlines.size();
    }

    public final int getVertexCount() {
        int n = 0;
        for (Outline outline : this.outlines) {
            n += outline.getVertexCount();
        }
        return n;
    }

    public final Winding getWindingOfLastOutline() {
        return this.getLastOutline().getWinding();
    }

    public final void setWindingOfLastOutline(Winding winding) {
        this.getLastOutline().setWinding(winding);
    }

    public boolean isComplex() {
        if (!FORCE_COMPLEXSHAPE && !FORCE_SIMPLESHAPE && 0 == (0x10 & this.dirtyBits) && 0 != (8 & this.dirtyBits)) {
            this.complexShape = false;
            int n = this.getOutlineCount();
            for (int i = 0; i < n && !this.complexShape; ++i) {
                this.complexShape = this.getOutline(i).isComplex();
            }
            this.dirtyBits &= 0xFFFFFFF7;
        }
        return this.complexShape;
    }

    public void setOverrideConvex(boolean bl) {
        if (!FORCE_COMPLEXSHAPE && !FORCE_SIMPLESHAPE) {
            this.dirtyBits |= 0x10;
            this.complexShape = bl;
        }
    }

    public void clearOverrideConvex() {
        this.dirtyBits &= 0xFFFFFFEF;
        this.dirtyBits |= 8;
    }

    public final void addEmptyOutline() {
        if (!this.getLastOutline().isEmpty()) {
            this.outlines.add(new Outline());
        }
    }

    public final void addOutline(Outline outline) throws NullPointerException {
        this.addOutline(this.outlines.size(), outline);
    }

    public final void addOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        if (this.outlines.size() == n) {
            Outline outline2 = this.getLastOutline();
            if (outline.isEmpty() && outline2.isEmpty()) {
                return;
            }
            if (outline2.isEmpty()) {
                this.outlines.set(n - 1, outline);
                if (0 == (this.dirtyBits & 1)) {
                    this.bbox.resize(outline.getBounds());
                }
                this.dirtyBits |= 0xE;
                return;
            }
        }
        this.outlines.add(n, outline);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(outline.getBounds());
        }
        this.dirtyBits |= 0xE;
    }

    public final void addOutlineShape(OutlineShape outlineShape) throws NullPointerException {
        if (null == outlineShape) {
            throw new NullPointerException("OutlineShape is null");
        }
        this.closeLastOutline(true);
        for (int i = 0; i < outlineShape.getOutlineCount(); ++i) {
            this.addOutline(outlineShape.getOutline(i));
        }
    }

    public final void setOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        this.outlines.set(n, outline);
        this.dirtyBits |= 0xF;
    }

    public final Outline removeOutline(int n) throws IndexOutOfBoundsException {
        this.dirtyBits |= 0xF;
        return this.outlines.remove(n);
    }

    public final Outline getLastOutline() {
        return this.outlines.get(this.outlines.size() - 1);
    }

    public final Outline getOutline(int n) throws IndexOutOfBoundsException {
        return this.outlines.get(n);
    }

    public final void addVertex(Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(vertex.getCoord());
        }
        this.dirtyBits |= 0xE;
    }

    public final void addVertex(int n, Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(n, vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(vertex.getCoord());
        }
        this.dirtyBits |= 0xE;
    }

    public final void addVertex(float f, float f2, boolean bl) {
        this.addVertex(new Vertex(f, f2, 0.0f, bl));
    }

    public final void addVertex(int n, float f, float f2, boolean bl) {
        this.addVertex(n, new Vertex(f, f2, 0.0f, bl));
    }

    public final void addVertex(float f, float f2, float f3, boolean bl) {
        this.addVertex(new Vertex(f, f2, f3, bl));
    }

    public final void addVertex(int n, float f, float f2, float f3, boolean bl) {
        this.addVertex(n, new Vertex(f, f2, f3, bl));
    }

    public final void addVertex(float[] fArray, int n, int n2, boolean bl) {
        this.addVertex(new Vertex(fArray, n, n2, bl));
    }

    public final void addVertex(int n, float[] fArray, int n2, int n3, boolean bl) {
        this.addVertex(n, new Vertex(fArray, n2, n3, bl));
    }

    public final void closeLastOutline(boolean bl) {
        if (this.getLastOutline().setClosed(bl)) {
            this.dirtyBits |= 0xE;
        }
    }

    public void addPath(Path2F path2F, boolean bl) {
        this.addPath(path2F.iterator(null), bl);
    }

    public final void addPath(Path2F.Iterator iterator, boolean bl) {
        float[] fArray = iterator.points();
        while (iterator.hasNext()) {
            int n = iterator.index();
            Path2F.SegmentType segmentType = iterator.next();
            switch (segmentType) {
                case MOVETO: {
                    Outline outline = this.getLastOutline();
                    int n2 = outline.getVertexCount();
                    if (0 == n2) {
                        this.addVertex(fArray, n, 2, true);
                        break;
                    }
                    if (!bl) {
                        this.closeLastOutline(false);
                        this.addEmptyOutline();
                        this.addVertex(fArray, n, 2, true);
                        break;
                    }
                    Vertex vertex = outline.getVertex(n2 - 1);
                    if (vertex.x() == fArray[n + 0] && vertex.y() == fArray[n + 1]) break;
                }
                case LINETO: {
                    this.addVertex(fArray, n, 2, true);
                    break;
                }
                case QUADTO: {
                    this.addVertex(fArray, n, 2, false);
                    this.addVertex(fArray, n + 2, 2, true);
                    break;
                }
                case CUBICTO: {
                    this.addVertex(fArray, n, 2, false);
                    this.addVertex(fArray, n + 2, 2, false);
                    this.addVertex(fArray, n + 4, 2, true);
                    break;
                }
                case CLOSE: {
                    this.closeLastOutline(true);
                    this.addEmptyOutline();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled Segment Type: " + segmentType);
                }
            }
            bl = false;
        }
    }

    public void addPathRev(Path2F path2F, boolean bl) {
        this.addPathRev(path2F.iterator(null), bl);
    }

    public final void addPathRev(Path2F.Iterator iterator, boolean bl) {
        float[] fArray = iterator.points();
        while (iterator.hasNext()) {
            int n = iterator.index();
            Path2F.SegmentType segmentType = iterator.next();
            switch (segmentType) {
                case MOVETO: {
                    Outline outline = this.getLastOutline();
                    int n2 = outline.getVertexCount();
                    if (0 == n2) {
                        this.addVertex(0, fArray, n, 2, true);
                        break;
                    }
                    if (!bl) {
                        this.closeLastOutline(false);
                        this.addEmptyOutline();
                        this.addVertex(0, fArray, n, 2, true);
                        break;
                    }
                    Vertex vertex = outline.getVertex(0);
                    if (vertex.x() == fArray[n + 0] && vertex.y() == fArray[n + 1]) break;
                }
                case LINETO: {
                    this.addVertex(0, fArray, n, 2, true);
                    break;
                }
                case QUADTO: {
                    this.addVertex(0, fArray, n, 2, false);
                    this.addVertex(0, fArray, n + 2, 2, true);
                    break;
                }
                case CUBICTO: {
                    this.addVertex(0, fArray, n, 2, false);
                    this.addVertex(0, fArray, n + 2, 2, false);
                    this.addVertex(0, fArray, n + 4, 2, true);
                    break;
                }
                case CLOSE: {
                    this.closeLastOutline(true);
                    this.addEmptyOutline();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled Segment Type: " + segmentType);
                }
            }
            bl = false;
        }
    }

    public final void moveTo(float f, float f2, float f3) {
        if (0 == this.getLastOutline().getVertexCount()) {
            this.addVertex(f, f2, f3, true);
        } else {
            this.closeLastOutline(false);
            this.addEmptyOutline();
            this.addVertex(f, f2, f3, true);
        }
    }

    public final void lineTo(float f, float f2, float f3) {
        this.addVertex(f, f2, f3, true);
    }

    public final void quadTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.addVertex(f, f2, f3, false);
        this.addVertex(f4, f5, f6, true);
    }

    public final void cubicTo(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.addVertex(f, f2, f3, false);
        this.addVertex(f4, f5, f6, false);
        this.addVertex(f7, f8, f9, true);
    }

    public final void closePath() {
        if (0 < this.getLastOutline().getVertexCount()) {
            this.closeLastOutline(true);
            this.addEmptyOutline();
        }
    }

    public final VerticesState getOutlineState() {
        return this.outlineState;
    }

    public final void setIsQuadraticNurbs() {
        this.outlineState = VerticesState.QUADRATIC_NURBS;
    }

    private void subdivideTriangle(Outline outline, Vertex vertex, Vertex vertex2, Vertex vertex3, int n) {
        VectorUtil.midpoint((Vec3f)this.tmpV1, (Vec3f)vertex.getCoord(), (Vec3f)vertex2.getCoord());
        VectorUtil.midpoint((Vec3f)this.tmpV3, (Vec3f)vertex2.getCoord(), (Vec3f)vertex3.getCoord());
        VectorUtil.midpoint((Vec3f)this.tmpV2, (Vec3f)this.tmpV1, (Vec3f)this.tmpV3);
        vertex2.setCoord(this.tmpV2);
        vertex2.setOnCurve(true);
        outline.addVertex(n, new Vertex(this.tmpV1, false));
        outline.addVertex(n + 2, new Vertex(this.tmpV3, false));
        this.addedVerticeCount += 2;
    }

    private void checkOverlaps() {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(3);
        int n = this.getOutlineCount();
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                Outline outline = this.getOutline(i);
                int n2 = outline.getVertexCount();
                for (int j = 0; j < outline.getVertexCount(); ++j) {
                    Vertex vertex = outline.getVertex(j);
                    if (vertex.isOnCurve()) continue;
                    Vertex vertex2 = outline.getVertex((j + 1) % n2);
                    Vertex vertex3 = outline.getVertex((j + n2 - 1) % n2);
                    Vertex vertex4 = bl ? this.checkTriOverlaps0(vertex3, vertex, vertex2) : null;
                    if (null == vertex4 && !arrayList.contains(vertex)) continue;
                    arrayList.remove(vertex);
                    this.subdivideTriangle(outline, vertex3, vertex, vertex2, j);
                    j += 3;
                    n2 += 2;
                    this.addedVerticeCount += 2;
                    if (vertex4 == null || vertex4.isOnCurve() || arrayList.contains(vertex4)) continue;
                    arrayList.add(vertex4);
                }
            }
            bl = false;
        } while (!arrayList.isEmpty());
    }

    private Vertex checkTriOverlaps0(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        int n = this.getOutlineCount();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            for (int j = 0; j < n2; ++j) {
                Vertex vertex4 = outline.getVertex(j);
                if (vertex4.isOnCurve() || vertex4 == vertex || vertex4 == vertex2 || vertex4 == vertex3) continue;
                Vertex vertex5 = outline.getVertex((j + 1) % n2);
                Vertex vertex6 = outline.getVertex((j + n2 - 1) % n2);
                if (vertex6 == vertex3 || vertex5 == vertex) continue;
                if (VectorUtil.isInTriangle3((Vec3f)vertex.getCoord(), (Vec3f)vertex2.getCoord(), (Vec3f)vertex3.getCoord(), (Vec3f)vertex4.getCoord(), (Vec3f)vertex5.getCoord(), (Vec3f)vertex6.getCoord(), (Vec3f)this.tmpV1, (Vec3f)this.tmpV2, (Vec3f)this.tmpV3)) {
                    return vertex4;
                }
                if (!VectorUtil.testTri2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex2, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex6, (Vert2fImmutable)vertex4) && !VectorUtil.testTri2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex2, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex4, (Vert2fImmutable)vertex5) && !VectorUtil.testTri2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex2, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex6, (Vert2fImmutable)vertex5)) continue;
                return vertex4;
            }
        }
        return null;
    }

    private void cleanupOutlines() {
        boolean bl = VerticesState.QUADRATIC_NURBS != this.outlineState;
        int n = this.getOutlineCount();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            if (bl) {
                for (int j = 0; j < n2; ++j) {
                    Vertex vertex = outline.getVertex(j);
                    int n3 = (j + 1) % n2;
                    Vertex vertex2 = outline.getVertex(n3);
                    if (vertex.isOnCurve() || vertex2.isOnCurve()) continue;
                    VectorUtil.midpoint((Vec3f)this.tmpV1, (Vec3f)vertex.getCoord(), (Vec3f)vertex2.getCoord());
                    System.err.println("XXX: Cubic: " + j + ": " + vertex + ", " + n3 + ": " + vertex2);
                    Vertex vertex3 = new Vertex(this.tmpV1, true);
                    ++n2;
                    ++this.addedVerticeCount;
                    outline.addVertex(++j, vertex3);
                }
            }
            if (0 >= n2) {
                this.outlines.remove(outline);
                --i;
                --n;
                continue;
            }
            if (0 >= n2 || !outline.getVertex(0).getCoord().isEqual(outline.getLastVertex().getCoord())) continue;
            outline.removeVertex(n2 - 1);
        }
        this.outlineState = VerticesState.QUADRATIC_NURBS;
        this.checkOverlaps();
    }

    private int generateVertexIds() {
        int n = 0;
        for (int i = 0; i < this.outlines.size(); ++i) {
            ArrayList<Vertex> arrayList = this.outlines.get(i).getVertices();
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList.get(j).setId(n++);
            }
        }
        return n;
    }

    public final ArrayList<Vertex> getVertices() {
        if (0 != (2 & this.dirtyBits)) {
            this.vertices.clear();
            for (int i = 0; i < this.outlines.size(); ++i) {
                this.vertices.addAll(this.outlines.get(i).getVertices());
            }
            this.dirtyBits &= 0xFFFFFFFD;
        }
        return this.vertices;
    }

    public static void printPerf(PrintStream printStream) {
    }

    private void triangulateImpl() {
        if (0 < this.outlines.size()) {
            this.sortOutlines();
            this.generateVertexIds();
            this.triangles.clear();
            Triangulator triangulator = Triangulation.create();
            triangulator.setComplexShape(this.isComplex());
            for (int i = 0; i < this.outlines.size(); ++i) {
                triangulator.addCurve(this.triangles, this.outlines.get(i), this.sharpness);
            }
            triangulator.generate(this.triangles);
            this.addedVerticeCount += triangulator.getAddedVerticeCount();
            triangulator.reset();
        }
    }

    public final ArrayList<Triangle> getTriangles(VerticesState verticesState) {
        boolean bl;
        if (verticesState != VerticesState.QUADRATIC_NURBS) {
            throw new IllegalStateException("destinationType " + verticesState.name() + " not supported (currently " + this.outlineState.name() + ")");
        }
        if (0 != (4 & this.dirtyBits)) {
            this.cleanupOutlines();
            this.triangulateImpl();
            bl = true;
            this.dirtyBits |= 2;
            this.dirtyBits &= 0xFFFFFFFB;
        } else {
            bl = false;
        }
        if (Region.DEBUG_INSTANCE) {
            System.err.println("OutlineShape.getTriangles().X: " + this.triangles.size() + ", updated " + bl);
            if (bl) {
                int n = 0;
                for (Triangle triangle : this.triangles) {
                    System.err.printf("- [%d]: %s%n", n++, triangle);
                }
            }
        }
        return this.triangles;
    }

    public final OutlineShape transform(AffineTransform affineTransform) {
        OutlineShape outlineShape = new OutlineShape();
        int n = this.outlines.size();
        for (int i = 0; i < n; ++i) {
            outlineShape.addOutline(this.outlines.get(i).transform(affineTransform));
        }
        return outlineShape;
    }

    private void sortOutlines() {
        Collections.sort(this.outlines, reversSizeComparator);
    }

    @Override
    public final int compareTo(OutlineShape outlineShape) {
        float f;
        float f2 = this.getBounds().getSize();
        if (FloatUtil.isEqual2((float)f2, (float)(f = outlineShape.getBounds().getSize()))) {
            return 0;
        }
        if (f2 < f) {
            return -1;
        }
        return 1;
    }

    private void validateBoundingBox() {
        this.dirtyBits &= 0xFFFFFFFE;
        this.bbox.reset();
        for (int i = 0; i < this.outlines.size(); ++i) {
            this.bbox.resize(this.outlines.get(i).getBounds());
        }
    }

    public final AABBox getBounds() {
        if (0 != (this.dirtyBits & 1)) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof OutlineShape)) {
            return false;
        }
        OutlineShape outlineShape = (OutlineShape)object;
        if (this.getOutlineState() != outlineShape.getOutlineState()) {
            return false;
        }
        if (this.getOutlineCount() != outlineShape.getOutlineCount()) {
            return false;
        }
        if (!this.getBounds().equals((Object)outlineShape.getBounds())) {
            return false;
        }
        for (int i = this.getOutlineCount() - 1; i >= 0; --i) {
            if (this.getOutline(i).equals(outlineShape.getOutline(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(super.hashCode());
    }

    public void print(PrintStream printStream) {
        int n = this.getOutlineCount();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            printStream.printf("- OL[%d]: %s%n", n2, outline.getWinding());
            for (int j = 0; j < n2; ++j) {
                Vertex vertex = outline.getVertex(j);
                printStream.printf("-- OS[%d][%d]: %s%n", i, j, vertex);
            }
        }
    }

    public static enum VerticesState {
        UNDEFINED(0),
        QUADRATIC_NURBS(1);

        public final int state;

        private VerticesState(int n2) {
            this.state = n2;
        }
    }
}

