/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.math.VectorUtil;
import com.jogamp.math.Vert2fImmutable;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.Winding;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.curve.tess.CDTriangulator2D;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.HEdge;

public class Loop {
    private final AABBox box = new AABBox();
    private final GraphOutline initialOutline;
    private final boolean complexShape;
    private HEdge root;
    private final List<GraphOutline> outlines = new ArrayList<GraphOutline>();

    private Loop(GraphOutline graphOutline, int n, boolean bl) {
        this.initialOutline = graphOutline;
        this.complexShape = bl;
        this.root = this.initFromPolyline(this.initialOutline, n);
    }

    public static Loop createBoundary(GraphOutline graphOutline, boolean bl) {
        Loop loop = new Loop(graphOutline, 3, bl);
        if (null == loop.root) {
            return null;
        }
        return loop;
    }

    public HEdge getHEdge() {
        return this.root;
    }

    public boolean isSimplex() {
        return this.root.getNext().getNext().getNext() == this.root;
    }

    private HEdge initFromPolyline(GraphOutline graphOutline, int n) {
        Winding winding;
        this.outlines.add(graphOutline);
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        if (arrayList.size() < 3) {
            System.err.println("Graph: Loop.initFromPolyline: GraphOutline's vertices < 3: " + arrayList.size());
            if (GraphOutline.DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        Winding winding2 = winding = 3 == n ? Winding.CCW : Winding.CW;
        if (3 == n && Winding.CCW != winding2) {
            System.err.println("Loop.init.xx.01: BOUNDARY req CCW but has " + winding2);
            Thread.dumpStack();
        }
        HEdge hEdge = null;
        HEdge hEdge2 = null;
        if (winding2 == winding || 3 == n) {
            int n2 = arrayList.size() - 1;
            for (int i = 0; i <= n2; ++i) {
                GraphVertex graphVertex = arrayList.get(i);
                this.box.resize(graphVertex.x(), graphVertex.y(), graphVertex.z());
                HEdge hEdge3 = new HEdge(graphVertex, n);
                graphVertex.addEdge(hEdge3);
                if (hEdge2 != null) {
                    hEdge2.setNext(hEdge3);
                    hEdge3.setPrev(hEdge2);
                } else {
                    hEdge = hEdge3;
                }
                if (i == n2) {
                    hEdge3.setNext(hEdge);
                    hEdge.setPrev(hEdge3);
                }
                hEdge2 = hEdge3;
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                GraphVertex graphVertex = arrayList.get(i);
                this.box.resize(graphVertex.x(), graphVertex.y(), graphVertex.z());
                HEdge hEdge4 = new HEdge(graphVertex, n);
                graphVertex.addEdge(hEdge4);
                if (hEdge2 != null) {
                    hEdge2.setNext(hEdge4);
                    hEdge4.setPrev(hEdge2);
                } else {
                    hEdge = hEdge4;
                }
                if (i == 0) {
                    hEdge4.setNext(hEdge);
                    hEdge.setPrev(hEdge4);
                }
                hEdge2 = hEdge4;
            }
        }
        return hEdge;
    }

    public void addConstraintCurveHole(GraphOutline graphOutline) {
        if (null == this.initFromPolyline(graphOutline, 2)) {
            return;
        }
        GraphVertex graphVertex = this.locateClosestVertex(graphOutline);
        if (null == graphVertex) {
            System.err.println("Graph: Loop.locateClosestVertex returns null; root valid? " + (null != this.root));
            if (GraphOutline.DEBUG) {
                Thread.dumpStack();
            }
            return;
        }
        HEdge hEdge = graphVertex.findBoundEdge();
        HEdge hEdge2 = hEdge.getPrev();
        HEdge hEdge3 = new HEdge(this.root.getGraphPoint(), 1);
        HEdge.connect(this.root.getPrev(), hEdge3);
        HEdge.connect(hEdge3, hEdge);
        HEdge hEdge4 = hEdge3.getSibling();
        if (hEdge4 == null) {
            hEdge4 = new HEdge(hEdge3.getNext().getGraphPoint(), 1);
            HEdge.makeSiblings(hEdge3, hEdge4);
        }
        HEdge.connect(hEdge2, hEdge4);
        HEdge.connect(hEdge4, this.root);
    }

    private GraphVertex locateClosestVertex(GraphOutline graphOutline) {
        float f = Float.MAX_VALUE;
        ArrayList<GraphVertex> arrayList = this.initialOutline.getGraphPoint();
        if (arrayList.size() < 2) {
            return null;
        }
        ArrayList<GraphVertex> arrayList2 = graphOutline.getGraphPoint();
        HEdge hEdge = null;
        GraphVertex graphVertex = null;
        int n = arrayList.size();
        GraphVertex graphVertex2 = arrayList.get(0);
        for (int i = 1; i < n; ++i) {
            GraphVertex graphVertex3 = arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                GraphVertex graphVertex4 = arrayList2.get(j);
                float f2 = graphVertex2.getCoord().dist(graphVertex4.getCoord());
                if (!(f2 < f)) continue;
                boolean bl = false;
                for (GraphVertex graphVertex5 : arrayList2) {
                    if (graphVertex5 != graphVertex2 && graphVertex5 != graphVertex3 && graphVertex5 != graphVertex4 && (bl = VectorUtil.isInCircle((Vert2fImmutable)graphVertex2.getPoint(), (Vert2fImmutable)graphVertex3.getPoint(), (Vert2fImmutable)graphVertex4.getPoint(), (Vert2fImmutable)graphVertex5.getPoint()))) break;
                }
                if (bl) continue;
                graphVertex = graphVertex4;
                f = f2;
                hEdge = graphVertex2.findBoundEdge();
            }
            graphVertex2 = graphVertex3;
        }
        if (hEdge != null) {
            this.root = hEdge;
        }
        return graphVertex;
    }

    public final Triangle cut(boolean bl) {
        if (!CDTriangulator2D.DEBUG) {
            return this.cut0(bl);
        }
        return this.cutDbg(bl);
    }

    private final Triangle cut0(boolean bl) {
        HEdge hEdge = this.root.getNext();
        if (this.isSimplex()) {
            Vertex vertex = this.root.getGraphPoint().getPoint();
            Vertex vertex2 = hEdge.getGraphPoint().getPoint();
            Vertex vertex3 = hEdge.getNext().getGraphPoint().getPoint();
            if (this.complexShape && this.intersectsOutline(vertex, vertex2, vertex3)) {
                return null;
            }
            return new Triangle(vertex, vertex2, vertex3, this.checkVerticesBoundary(this.root));
        }
        HEdge hEdge2 = this.root.getPrev();
        HEdge hEdge3 = this.isValidNeighbor(hEdge.getNext(), bl);
        if (hEdge3 == null) {
            this.root = this.root.getNext();
            return null;
        }
        GraphVertex graphVertex = this.root.getGraphPoint();
        GraphVertex graphVertex2 = hEdge.getGraphPoint();
        GraphVertex graphVertex3 = hEdge3.getGraphPoint();
        HEdge hEdge4 = new HEdge(graphVertex3, 1);
        HEdge.connect(hEdge4, this.root);
        HEdge.connect(hEdge, hEdge4);
        HEdge hEdge5 = hEdge4.getSibling();
        if (hEdge5 == null) {
            hEdge5 = new HEdge(hEdge4.getNext().getGraphPoint(), 1);
            HEdge.makeSiblings(hEdge4, hEdge5);
        }
        HEdge.connect(hEdge2, hEdge5);
        HEdge.connect(hEdge5, hEdge3);
        Triangle triangle = this.createTriangle(graphVertex.getPoint(), graphVertex2.getPoint(), graphVertex3.getPoint(), this.root);
        this.root = hEdge3;
        return triangle;
    }

    private final Triangle cutDbg(boolean bl) {
        HEdge hEdge = this.root.getNext();
        if (this.isSimplex()) {
            Vertex vertex = this.root.getGraphPoint().getPoint();
            Vertex vertex2 = hEdge.getGraphPoint().getPoint();
            Vertex vertex3 = hEdge.getNext().getGraphPoint().getPoint();
            if (this.complexShape && this.intersectsOutlineDbg(vertex, vertex2, vertex3)) {
                System.err.printf("Loop.cut.X0: last-simplex intersects%n", new Object[0]);
                return null;
            }
            Triangle triangle = new Triangle(vertex, vertex2, vertex3, this.checkVerticesBoundary(this.root));
            System.err.printf("Loop.cut.X1: last-simplex %s%n", triangle);
            return triangle;
        }
        HEdge hEdge2 = this.root.getPrev();
        HEdge hEdge3 = this.isValidNeighborDbg(hEdge.getNext(), bl);
        if (hEdge3 == null) {
            this.root = this.root.getNext();
            System.err.printf("Loop.cut.0: null-cut %s%n", hEdge.getNext().getGraphPoint());
            return null;
        }
        GraphVertex graphVertex = this.root.getGraphPoint();
        GraphVertex graphVertex2 = hEdge.getGraphPoint();
        GraphVertex graphVertex3 = hEdge3.getGraphPoint();
        HEdge hEdge4 = new HEdge(graphVertex3, 1);
        HEdge.connect(hEdge4, this.root);
        HEdge.connect(hEdge, hEdge4);
        HEdge hEdge5 = hEdge4.getSibling();
        if (hEdge5 == null) {
            hEdge5 = new HEdge(hEdge4.getNext().getGraphPoint(), 1);
            HEdge.makeSiblings(hEdge4, hEdge5);
        }
        HEdge.connect(hEdge2, hEdge5);
        HEdge.connect(hEdge5, hEdge3);
        Triangle triangle = this.createTriangle(graphVertex.getPoint(), graphVertex2.getPoint(), graphVertex3.getPoint(), this.root);
        this.root = hEdge3;
        System.err.printf("Loop.cut.1: new-cut %s -> %s%n", hEdge3.getGraphPoint(), triangle);
        return triangle;
    }

    private final boolean intersectsOutline(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        for (GraphOutline graphOutline : this.outlines) {
            ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
            int n = arrayList.size();
            if (n < 2) continue;
            Vertex vertex4 = arrayList.get(0).getPoint();
            for (int i = 1; i < n; ++i) {
                Vertex vertex5 = arrayList.get(i).getPoint();
                if (vertex4 != vertex3 && vertex5 != vertex3) {
                    if (vertex4 != vertex && vertex5 != vertex && VectorUtil.testSeg2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex4, (Vert2fImmutable)vertex5)) {
                        return true;
                    }
                    if (vertex4 != vertex2 && vertex5 != vertex2 && VectorUtil.testSeg2SegIntersection((Vert2fImmutable)vertex2, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex4, (Vert2fImmutable)vertex5)) {
                        return true;
                    }
                }
                vertex4 = vertex5;
            }
        }
        return false;
    }

    private final boolean intersectsOutlineDbg(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        for (GraphOutline graphOutline : this.outlines) {
            ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
            int n = arrayList.size();
            if (n < 2) continue;
            Vertex vertex4 = arrayList.get(0).getPoint();
            for (int i = 1; i < n; ++i) {
                Vertex vertex5 = arrayList.get(i).getPoint();
                if (vertex4 != vertex3 && vertex5 != vertex3) {
                    if (vertex4 != vertex && vertex5 != vertex && VectorUtil.testSeg2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex4, (Vert2fImmutable)vertex5)) {
                        System.err.printf("Loop.intersection.b-a1.1: %d/%d %s to%n-a1 %s, with%n-v0 %s%n-v1 %s%n", i, n - 1, vertex3, vertex, vertex4, vertex5);
                        return true;
                    }
                    if (vertex4 != vertex2 && vertex5 != vertex2 && VectorUtil.testSeg2SegIntersection((Vert2fImmutable)vertex2, (Vert2fImmutable)vertex3, (Vert2fImmutable)vertex4, (Vert2fImmutable)vertex5)) {
                        System.err.printf("Loop.intersection.b-a2.1: %d/%d %s to%n-a2 %s, with%n-v0 %s%n-v1 %s%n", i, n - 1, vertex3, vertex2, vertex4, vertex5);
                        return true;
                    }
                }
                vertex4 = vertex5;
            }
        }
        return false;
    }

    private final HEdge isValidNeighbor(HEdge hEdge, boolean bl) {
        Vertex vertex;
        Vertex vertex2;
        GraphVertex graphVertex = this.root.getGraphPoint();
        GraphVertex graphVertex2 = this.root.getNext().getGraphPoint();
        Vertex vertex3 = graphVertex.getPoint();
        if (!VectorUtil.isCCW((Vert2fImmutable)vertex3, (Vert2fImmutable)(vertex2 = graphVertex2.getPoint()), (Vert2fImmutable)(vertex = hEdge.getGraphPoint().getPoint())) || this.complexShape && this.intersectsOutline(vertex3, vertex2, vertex)) {
            return null;
        }
        if (!bl) {
            return hEdge;
        }
        for (HEdge hEdge2 = hEdge.getNext(); hEdge2 != hEdge; hEdge2 = hEdge2.getNext()) {
            GraphVertex graphVertex3 = hEdge2.getGraphPoint();
            Vertex vertex4 = graphVertex3.getPoint();
            if (graphVertex3 == graphVertex || graphVertex3 == graphVertex2 || vertex4 == vertex || !VectorUtil.isInCircle((Vert2fImmutable)vertex3, (Vert2fImmutable)vertex2, (Vert2fImmutable)vertex, (Vert2fImmutable)vertex4)) continue;
            return null;
        }
        return hEdge;
    }

    private final HEdge isValidNeighborDbg(HEdge hEdge, boolean bl) {
        Vertex vertex;
        Vertex vertex2;
        GraphVertex graphVertex = this.root.getGraphPoint();
        GraphVertex graphVertex2 = this.root.getNext().getGraphPoint();
        Vertex vertex3 = graphVertex.getPoint();
        if (!VectorUtil.isCCW((Vert2fImmutable)vertex3, (Vert2fImmutable)(vertex2 = graphVertex2.getPoint()), (Vert2fImmutable)(vertex = hEdge.getGraphPoint().getPoint()))) {
            System.err.printf("Loop.isInCircle.X: !CCW %s, of%n- %s%n- %s%n- %s%n", vertex, vertex3, vertex2, vertex);
            return null;
        }
        if (this.complexShape && this.intersectsOutlineDbg(vertex3, vertex2, vertex)) {
            return null;
        }
        if (!bl) {
            return hEdge;
        }
        for (HEdge hEdge2 = hEdge.getNext(); hEdge2 != hEdge; hEdge2 = hEdge2.getNext()) {
            GraphVertex graphVertex3 = hEdge2.getGraphPoint();
            Vertex vertex4 = graphVertex3.getPoint();
            if (graphVertex3 == graphVertex || graphVertex3 == graphVertex2 || vertex4 == vertex) continue;
            double d = VectorUtil.inCircleVal((Vert2fImmutable)vertex3, (Vert2fImmutable)vertex2, (Vert2fImmutable)vertex, (Vert2fImmutable)vertex4);
            if (d > 2.220446049250313E-16) {
                System.err.printf("Loop.isInCircle.1: %30.30f: %s, of%n- %s%n- %s%n- %s%n", d, vertex, vertex3, vertex2, vertex4);
                return null;
            }
            System.err.printf("Loop.isInCircle.0: %30.30f: %s, of%n- %s%n- %s%n- %s%n", d, vertex, vertex3, vertex2, vertex4);
        }
        System.err.printf("Loop.isInCircle.0: %s%n", vertex);
        return hEdge;
    }

    private Triangle createTriangle(Vertex vertex, Vertex vertex2, Vertex vertex3, HEdge hEdge) {
        return new Triangle(vertex, vertex2, vertex3, this.checkVerticesBoundary(hEdge));
    }

    private boolean[] checkVerticesBoundary(HEdge hEdge) {
        boolean[] blArray = new boolean[3];
        if (hEdge.getGraphPoint().isBoundaryContained()) {
            blArray[0] = true;
        }
        if (hEdge.getNext().getGraphPoint().isBoundaryContained()) {
            blArray[1] = true;
        }
        if (hEdge.getNext().getNext().getGraphPoint().isBoundaryContained()) {
            blArray[2] = true;
        }
        return blArray;
    }

    public boolean checkInside(Vertex vertex) {
        if (!this.box.contains(vertex.x(), vertex.y(), vertex.z())) {
            return false;
        }
        boolean bl = false;
        HEdge hEdge = this.root;
        HEdge hEdge2 = this.root.getNext();
        do {
            Vertex vertex2 = hEdge.getGraphPoint().getPoint();
            Vertex vertex3 = hEdge2.getGraphPoint().getPoint();
            if (vertex3.y() > vertex.y() != vertex2.y() > vertex.y() && vertex.x() < (vertex2.x() - vertex3.x()) * (vertex.y() - vertex3.y()) / (vertex2.y() - vertex3.y()) + vertex3.x()) {
                bl = !bl;
            }
            hEdge = hEdge2;
            hEdge2 = hEdge.getNext();
        } while (hEdge != this.root);
        return bl;
    }

    public int computeLoopSize() {
        int n = 0;
        HEdge hEdge = this.root;
        do {
            ++n;
        } while ((hEdge = hEdge.getNext()) != this.root);
        return n;
    }
}

