/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.font.Font;
import com.jogamp.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;

final class TypecastHMetrics
implements Font.Metrics {
    private final TypecastFont fontImpl;
    private final HeadTable headTable;
    private final int unitsPerEM;
    private final float unitsPerEM_inv;
    private final AABBox bbox;
    private final HheaTable hheaTable;

    public TypecastHMetrics(TypecastFont typecastFont) {
        this.fontImpl = typecastFont;
        this.headTable = this.fontImpl.font.getHeadTable();
        this.hheaTable = this.fontImpl.font.getHheaTable();
        this.unitsPerEM = this.headTable.getUnitsPerEm();
        this.unitsPerEM_inv = 1.0f / (float)this.unitsPerEM;
        int n = this.headTable.getXMax() - this.headTable.getXMin();
        int n2 = this.headTable.getYMax() - this.headTable.getYMin();
        short s = this.headTable.getXMin();
        int n3 = -(this.headTable.getYMin() + n2);
        int n4 = s + n;
        int n5 = n3 + n2;
        this.bbox = new AABBox((float)s, (float)n3, 0.0f, (float)n4, (float)n5, 0.0f);
    }

    @Override
    public int getAscentFU() {
        return this.hheaTable.getAscender();
    }

    @Override
    public float getAscent() {
        return this.getScale(this.getAscentFU());
    }

    @Override
    public int getDescentFU() {
        return this.hheaTable.getDescender();
    }

    @Override
    public float getDescent() {
        return this.getScale(this.getDescentFU());
    }

    @Override
    public int getLineGapFU() {
        return this.hheaTable.getLineGap();
    }

    @Override
    public float getLineGap() {
        return this.getScale(this.getLineGapFU());
    }

    @Override
    public int getMaxExtendFU() {
        return this.hheaTable.getXMaxExtent();
    }

    @Override
    public float getMaxExtend() {
        return this.getScale(this.getMaxExtendFU());
    }

    @Override
    public final int getUnitsPerEM() {
        return this.unitsPerEM;
    }

    @Override
    public final float getScale(int n) {
        return (float)n * this.unitsPerEM_inv;
    }

    @Override
    public final AABBox getBoundsFU(AABBox aABBox) {
        return aABBox.copy(this.bbox);
    }

    @Override
    public AABBox getBounds(AABBox aABBox) {
        return aABBox.copy(this.bbox).scale2(this.unitsPerEM_inv);
    }
}

