/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.macosx.OSXUtil;

public class OSXDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    long nsWindow = 0L;

    public OSXDummyUpstreamSurfaceHook(int n, int n2) {
        super(n, n2);
    }

    public final void create(ProxySurface proxySurface) {
        if (0L == this.nsWindow && 0L == proxySurface.getSurfaceHandle()) {
            OSXUtil.WinAndView winAndView = OSXUtil.CreateNSWindow2(0, 0, 64, 64);
            this.nsWindow = winAndView.win;
            if (0L == this.nsWindow) {
                throw new NativeWindowException("Error NS window 0");
            }
            long l = winAndView.view;
            if (0L == l) {
                throw new NativeWindowException("Error NS view 0");
            }
            proxySurface.setSurfaceHandle(l);
            proxySurface.addUpstreamOptionBits(64);
        }
        proxySurface.addUpstreamOptionBits(256);
    }

    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            if (0L == this.nsWindow || 0L == proxySurface.getSurfaceHandle()) {
                throw new InternalError("Owns upstream surface, but no OSX view/window: " + proxySurface + ", nsWindow 0x" + Long.toHexString(this.nsWindow));
            }
            final long l = this.nsWindow;
            this.nsWindow = 0L;
            proxySurface.setSurfaceHandle(0L);
            proxySurface.clearUpstreamOptionBits(64);
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    OSXUtil.DestroyNSWindow(l);
                }
            });
        }
    }
}

