/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.MonitorMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MonitorModeUtil {
    public static int getIndex(List<MonitorMode> list, MonitorMode monitorMode) {
        return list.indexOf(monitorMode);
    }

    public static int getIndexByHashCode(List<MonitorMode> list, MonitorMode monitorMode) {
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (monitorMode.hashCode() != list.get(i).hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    public static MonitorMode getByNativeSizeRateIdAndRotation(List<MonitorMode> list, MonitorMode.SizeAndRRate sizeAndRRate, int n, int n2) {
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (!monitorMode.getSizeAndRRate().equals(sizeAndRRate) || monitorMode.getId() != n || monitorMode.getRotation() != n2) continue;
                return monitorMode;
            }
        }
        return null;
    }

    public static void sort(List<MonitorMode> list, boolean bl) {
        if (bl) {
            Collections.sort(list);
        } else {
            Collections.sort(list, MonitorMode.monitorModeComparatorInv);
        }
    }

    public static List<MonitorMode> filterBySurfaceSize(List<MonitorMode> list, SurfaceSize surfaceSize) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (!monitorMode.getSurfaceSize().equals((Object)surfaceSize)) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByRotation(List<MonitorMode> list, int n) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (monitorMode.getRotation() != n) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByBpp(List<MonitorMode> list, int n) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (monitorMode.getSurfaceSize().getBitsPerPixel() != n) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByFlags(List<MonitorMode> list, int n) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (monitorMode.getFlags() != n) continue;
                arrayList.add(monitorMode);
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByResolution(List<MonitorMode> list, DimensionImmutable dimensionImmutable) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            int n = dimensionImmutable.getHeight() * dimensionImmutable.getWidth();
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                DimensionImmutable dimensionImmutable2 = monitorMode.getSurfaceSize().getResolution();
                int n4 = Math.abs(n - dimensionImmutable2.getHeight() * dimensionImmutable2.getWidth());
                if (n4 < n2) {
                    n2 = n4;
                    n3 = i;
                }
                if (!dimensionImmutable2.equals((Object)dimensionImmutable)) continue;
                arrayList.add(monitorMode);
            }
            if (arrayList.size() == 0 && 0 <= n3) {
                arrayList.add(list.get(n3));
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> filterByRate(List<MonitorMode> list, float f) {
        ArrayList<MonitorMode> arrayList = new ArrayList<MonitorMode>();
        if (null != list && list.size() > 0) {
            float f2 = Float.MAX_VALUE;
            int n = -1;
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                float f3 = Math.abs(f - monitorMode.getRefreshRate());
                if (f3 < f2) {
                    f2 = f3;
                    n = i;
                }
                if (0.0f != f3) continue;
                arrayList.add(monitorMode);
            }
            if (arrayList.size() == 0 && 0 <= n) {
                arrayList.add(list.get(n));
            }
        }
        return arrayList;
    }

    public static List<MonitorMode> getHighestAvailableBpp(List<MonitorMode> list) {
        if (null != list && list.size() > 0) {
            int n = -1;
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                int n2 = monitorMode.getSurfaceSize().getBitsPerPixel();
                if (n2 <= n) continue;
                n = n2;
            }
            return MonitorModeUtil.filterByBpp(list, n);
        }
        return new ArrayList<MonitorMode>();
    }

    public static List<MonitorMode> getHighestAvailableRate(List<MonitorMode> list) {
        if (null != list && list.size() > 0) {
            float f = -1.0f;
            for (int i = 0; null != list && i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                float f2 = monitorMode.getRefreshRate();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return MonitorModeUtil.filterByRate(list, f);
        }
        return new ArrayList<MonitorMode>();
    }
}

