/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.math.FloatUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import java.util.ArrayList;
import java.util.List;
import jogamp.newt.MonitorDeviceImpl;
import jogamp.newt.ScreenImpl;

public class MonitorModeProps {
    public static final int NUM_RESOLUTION_PROPERTIES = 2;
    public static final int NUM_SURFACE_SIZE_PROPERTIES = 1;
    public static final int NUM_SIZEANDRATE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES_ALL = 8;
    public static final int IDX_MONITOR_MODE_BPP = 3;
    public static final int IDX_MONITOR_MODE_ROT = 7;
    public static final int MIN_MONITOR_DEVICE_PROPERTIES = 17;
    public static final int IDX_MONITOR_DEVICE_SIZEMM = 4;
    public static final int IDX_MONITOR_DEVICE_VIEWPORT = 6;

    private static DimensionImmutable streamInSizeMM(int[] nArray, int n) {
        if (MonitorDevice.DEFAULT_SCREEN_MM_SIZE_OVERRIDE || 0 >= nArray[n] || 0 >= nArray[n + 1]) {
            nArray[n + 0] = MonitorDevice.DEFAULT_SCREEN_MM_SIZE.getWidth();
            nArray[n + 1] = MonitorDevice.DEFAULT_SCREEN_MM_SIZE.getHeight();
        }
        Dimension dimension = new Dimension(nArray[n++], nArray[n++]);
        return dimension;
    }

    private static DimensionImmutable streamInResolution(int[] nArray, int n) {
        if (MonitorDevice.DEFAULT_MODE_PIXEL_SIZE_OVERRIDE || 0 >= nArray[n] || 0 >= nArray[n + 1]) {
            nArray[n + 0] = MonitorDevice.DEFAULT_MODE_PIXEL_SIZE.getWidth();
            nArray[n + 1] = MonitorDevice.DEFAULT_MODE_PIXEL_SIZE.getHeight();
        }
        Dimension dimension = new Dimension(nArray[n++], nArray[n++]);
        return dimension;
    }

    private static SurfaceSize streamInSurfaceSize(DimensionImmutable dimensionImmutable, int[] nArray, int n) {
        return new SurfaceSize(dimensionImmutable, nArray[n]);
    }

    private static MonitorMode.SizeAndRRate streamInSizeAndRRate(SurfaceSize surfaceSize, int[] nArray, int n) {
        if (MonitorDevice.DEFAULT_MODE_REFRESH_OVERRIDE || 0 >= nArray[n]) {
            nArray[n] = MonitorDevice.DEFAULT_MODE_REFRESH * 100;
        }
        float f = (float)nArray[n++] / 100.0f;
        int n2 = nArray[n++];
        return new MonitorMode.SizeAndRRate(surfaceSize, f, n2);
    }

    private static MonitorMode streamInMonitorMode0(MonitorMode.SizeAndRRate sizeAndRRate, int[] nArray, int n) {
        int n2 = nArray[n++];
        int n3 = nArray[n++];
        return new MonitorMode(n2, sizeAndRRate, n3);
    }

    public static MonitorMode streamInMonitorMode(int[] nArray, Cache cache, int[] nArray2, int n) {
        int n2 = nArray2[n];
        if (8 != n2) {
            throw new RuntimeException("property count should be 8, but is " + n2 + ", len " + (nArray2.length - n));
        }
        if (8 > nArray2.length - n) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + (nArray2.length - n));
        }
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray2, ++n);
        n += 2;
        if (null != cache) {
            dimensionImmutable = (DimensionImmutable)cache.resolutions.getOrAdd((Object)dimensionImmutable);
        }
        SurfaceSize surfaceSize = MonitorModeProps.streamInSurfaceSize(dimensionImmutable, nArray2, n);
        ++n;
        if (null != cache) {
            surfaceSize = (SurfaceSize)cache.surfaceSizes.getOrAdd((Object)surfaceSize);
        }
        MonitorMode.SizeAndRRate sizeAndRRate = MonitorModeProps.streamInSizeAndRRate(surfaceSize, nArray2, n);
        n += 2;
        if (null != cache) {
            sizeAndRRate = (MonitorMode.SizeAndRRate)cache.sizeAndRates.getOrAdd((Object)sizeAndRRate);
        }
        MonitorMode monitorMode = MonitorModeProps.streamInMonitorMode0(sizeAndRRate, nArray2, n);
        if (null != cache) {
            monitorMode = (MonitorMode)cache.monitorModes.getOrAdd((Object)monitorMode);
        }
        if (null != nArray && null != cache) {
            int n3 = cache.monitorModes.indexOf((Object)monitorMode);
            if (0 > n3) {
                throw new InternalError("Invalid index of current unified mode " + monitorMode);
            }
            nArray[0] = n3;
        }
        return monitorMode;
    }

    public static int[] streamOutMonitorMode(MonitorMode monitorMode) {
        int[] nArray = new int[8];
        int n = 0;
        nArray[n++] = 8;
        nArray[n++] = monitorMode.getSurfaceSize().getResolution().getWidth();
        nArray[n++] = monitorMode.getSurfaceSize().getResolution().getHeight();
        nArray[n++] = monitorMode.getSurfaceSize().getBitsPerPixel();
        nArray[n++] = (int)(monitorMode.getRefreshRate() * 100.0f);
        nArray[n++] = monitorMode.getFlags();
        nArray[n++] = monitorMode.getId();
        nArray[n++] = monitorMode.getRotation();
        if (8 != n) {
            throw new InternalError("wrong number of attributes: got " + n + " != should " + 8);
        }
        return nArray;
    }

    public static MonitorDevice streamInMonitorDevice(Cache cache, ScreenImpl screenImpl, long l, String string, float[] fArray, boolean bl, int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = nArray[n];
        if (17 > n3) {
            throw new RuntimeException("property count should be >= 17, but is " + n3 + ", len " + (nArray.length - n));
        }
        if (17 > nArray.length - n) {
            throw new RuntimeException("properties array too short (min), should be >= 17, is " + (nArray.length - n));
        }
        if (n3 > nArray.length - n) {
            throw new RuntimeException("properties array too short (count), should be >= " + n3 + ", is " + (nArray.length - n));
        }
        int n4 = n + n3;
        ArrayList arrayList = cache.monitorModes.getData();
        int n5 = ++n;
        int n6 = nArray[n5];
        int n7 = ++n;
        ++n;
        boolean bl2 = 0 != nArray[n7];
        boolean bl3 = 0 != nArray[n++];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInSizeMM(nArray, n);
        n += 2;
        Rectangle rectangle = new Rectangle(nArray[n++], nArray[n++], nArray[n++], nArray[n++]);
        Rectangle rectangle2 = new Rectangle(nArray[n++], nArray[n++], nArray[n++], nArray[n++]);
        if (bl && null != fArray) {
            rectangle2.scaleInv(fArray[0], fArray[1]);
        }
        int n8 = nArray[n++];
        int n9 = nArray[n++];
        MonitorMode monitorMode = MonitorModeProps.getByNativeIdAndRotation(arrayList, n8, n9);
        ArrayHashSet arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
        while (n < n4) {
            n9 = nArray[n++];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                MonitorMode monitorMode2 = (MonitorMode)arrayList.get(n2);
                if (monitorMode2.getId() != n9) continue;
                arrayHashSet.add((Object)monitorMode2);
            }
        }
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, l, n6, string, bl2, bl3, dimensionImmutable, monitorMode, fArray, rectangle, rectangle2, (ArrayHashSet<MonitorMode>)arrayHashSet);
        if (null != cache && (monitorDevice = (MonitorDevice)cache.monitorDevices.getOrAdd((Object)monitorDevice)).isPrimary()) {
            cache.setPrimary(monitorDevice);
        }
        if (null != nArray2) {
            n2 = cache.monitorDevices.indexOf((Object)monitorDevice);
            if (0 > n2) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray2[0] = n2;
        }
        return monitorDevice;
    }

    private static MonitorMode getByNativeIdAndRotation(List<MonitorMode> list, int n, int n2) {
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MonitorMode monitorMode = list.get(i);
                if (monitorMode.getId() != n || monitorMode.getRotation() != n2) continue;
                return monitorMode;
            }
        }
        return null;
    }

    public static MonitorDevice streamInMonitorDevice(Cache cache, ScreenImpl screenImpl, long l, String string, MonitorMode monitorMode, float[] fArray, boolean bl, ArrayHashSet<MonitorMode> arrayHashSet, int[] nArray, int n, int[] nArray2) {
        int n2 = nArray[n];
        if (14 != n2) {
            throw new RuntimeException("property count should be == 14, but is " + n2 + ", len " + (nArray.length - n));
        }
        if (14 > nArray.length - n) {
            throw new RuntimeException("properties array too short (min), should be >= 14, is " + (nArray.length - n));
        }
        if (n2 > nArray.length - n) {
            throw new RuntimeException("properties array too short (count), should be >= " + n2 + ", is " + (nArray.length - n));
        }
        int n3 = ++n;
        int n4 = nArray[n3];
        int n5 = ++n;
        ++n;
        boolean bl2 = 0 != nArray[n5];
        boolean bl3 = 0 != nArray[n++];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInSizeMM(nArray, n);
        n += 2;
        Rectangle rectangle = new Rectangle(nArray[n++], nArray[n++], nArray[n++], nArray[n++]);
        Rectangle rectangle2 = new Rectangle(nArray[n++], nArray[n++], nArray[n++], nArray[n++]);
        if (bl && null != fArray) {
            rectangle2.scaleInv(fArray[0], fArray[1]);
        }
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, l, n4, string, bl2, bl3, dimensionImmutable, monitorMode, fArray, rectangle, rectangle2, arrayHashSet);
        if (null != cache && (monitorDevice = (MonitorDevice)cache.monitorDevices.getOrAdd((Object)monitorDevice)).isPrimary()) {
            cache.setPrimary(monitorDevice);
        }
        if (null != nArray2) {
            int n6 = cache.monitorDevices.indexOf((Object)monitorDevice);
            if (0 > n6) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray2[0] = n6;
        }
        return monitorDevice;
    }

    public static int[] streamOutMonitorDevice(MonitorDevice monitorDevice) {
        int n = monitorDevice.getSupportedModes().size();
        if (0 == n) {
            throw new RuntimeException("no supported modes: " + monitorDevice);
        }
        int[] nArray = new int[17 + n - 1];
        int n2 = 0;
        nArray[n2++] = nArray.length;
        nArray[n2++] = monitorDevice.getId();
        nArray[n2++] = monitorDevice.isClone() ? 1 : 0;
        nArray[n2++] = monitorDevice.isPrimary() ? 1 : 0;
        nArray[n2++] = monitorDevice.getSizeMM().getWidth();
        nArray[n2++] = monitorDevice.getSizeMM().getHeight();
        nArray[n2++] = monitorDevice.getViewport().getX();
        nArray[n2++] = monitorDevice.getViewport().getY();
        nArray[n2++] = monitorDevice.getViewport().getWidth();
        nArray[n2++] = monitorDevice.getViewport().getHeight();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getX();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getY();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getWidth();
        nArray[n2++] = monitorDevice.getViewportInWindowUnits().getHeight();
        nArray[n2++] = monitorDevice.getCurrentMode().getId();
        nArray[n2++] = monitorDevice.getCurrentMode().getRotation();
        List<MonitorMode> list = monitorDevice.getSupportedModes();
        for (int i = 0; i < list.size(); ++i) {
            nArray[n2++] = list.get(i).getId();
        }
        if (nArray.length != n2) {
            throw new InternalError("wrong number of attributes: got " + n2 + " != should " + nArray.length);
        }
        return nArray;
    }

    static void identifyMonitorDevices(Cache cache) {
        ArrayList arrayList = cache.monitorDevices.toArrayList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            MonitorDevice monitorDevice = (MonitorDevice)arrayList.get(i);
            if (monitorDevice.isClone()) continue;
            for (int j = i + 1; j < n; ++j) {
                MonitorDevice monitorDevice2 = (MonitorDevice)arrayList.get(j);
                if (monitorDevice2.isClone()) continue;
                float f = monitorDevice2.getViewport().coverage(monitorDevice.getViewport());
                if (FloatUtil.isZero((float)(1.0f - f))) {
                    ((MonitorDeviceImpl)monitorDevice2).setIsClone(true);
                    if (!Screen.DEBUG) continue;
                    System.err.printf("MonitorCloneTest[%d of %d]: %f -> _is_ covered%n", j, i, Float.valueOf(f));
                    System.err.printf("  Monitor[%d] %s%n", j, monitorDevice2.toString());
                    System.err.printf("  Monitor[%d] %s%n", i, monitorDevice.toString());
                    continue;
                }
                if (!Screen.DEBUG) continue;
                System.err.printf("MonitorDevice-CloneTest[%d of %d]: %f -> not covered%n", j, i, Float.valueOf(f));
                System.err.printf("  Monitor[%d] %s%n", j, monitorDevice2.toString());
                System.err.printf("  Monitor[%d] %s%n", i, monitorDevice.toString());
            }
        }
    }

    public static final void swapRotatePair(int n, int[] nArray, int n2, int n3) {
        if (0 == n || 180 == n) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n2];
            nArray[n2] = nArray[n2 + 1];
            nArray[n2 + 1] = n5;
            ++n4;
            n2 += 2;
        }
    }

    public static class Cache {
        public final ArrayHashSet<DimensionImmutable> resolutions = new ArrayHashSet(false, 16, 0.75f);
        public final ArrayHashSet<SurfaceSize> surfaceSizes = new ArrayHashSet(false, 16, 0.75f);
        public final ArrayHashSet<MonitorMode.SizeAndRRate> sizeAndRates = new ArrayHashSet(false, 16, 0.75f);
        public final ArrayHashSet<MonitorMode> monitorModes = new ArrayHashSet(false, 16, 0.75f);
        public final ArrayHashSet<MonitorDevice> monitorDevices = new ArrayHashSet(false, 16, 0.75f);
        private MonitorDevice primary = null;

        public final void setPrimary(MonitorDevice monitorDevice) {
            this.primary = monitorDevice;
        }

        public final MonitorDevice getPrimary() {
            return this.primary;
        }
    }
}

