/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Clock;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.graph.FontSet01;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class PerfTextRendererNEWT00 {
    static final Instant t0i = Clock.getMonotonicTime();
    static final long t0 = Clock.currentNanos();
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static int win_width = 1280;
    static int win_height = 720;
    static int loop_count = 1;
    static boolean do_perf = false;
    static boolean do_snap = false;
    static boolean do_vsync = false;
    static Font font;
    private final Vec4f fg_color = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final String text_long = "JOGL: Java\u2122 Binding for OpenGL\u00ae, providing hardware-accelerated 3D graphics.\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus.\nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies\nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit.\nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est.\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi.\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper\nMaecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem,\nI \u201cAsk Jeff\u201d or \u2018Ask Jeff\u2019. Take the chef d\u2019\u0153uvre! Two of [of] (of) \u2018of\u2019 \u201cof\u201d of? of! of*.\nLes Wo\u00ebvres, the F\u00f4ret de W\u0153vres, the Voire and Vauvise. Yves is in heaven.\nLyford\u2019s in Texas & L\u2019Anse-aux-Griffons in Qu\u00e9bec; the \u0141yna in Poland. Yriarte is in Yale.\nKyoto and Ryotsu are both in Japan, Kwikpak on the Yukon delta, Kv\u00e6ven in Norway\u2026\nVon-Vincke-Stra\u00dfe in M\u00fcnster, Vdovino in Russia, Ytterbium in the periodic table.\nMi\u0142osz and W\u016b W\u016d all in the library? 1510\u20131620, 11:00 pm, and the 1980s are over.\nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \n-------Press H to change text---------";
    public static final String text_1b = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est. \nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi. \nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem, \nI \u201cAsk Jeff\u201d or \u2018Ask Jeff\u2019. Take the chef d\u2019\u0153uvre! Two ofabcdefh";
    public static final String text_1s = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus.";
    public static final String text_1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est. \nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi. \nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem, \n-------Press H to change text---------";

    public static void main(String[] stringArray) throws IOException, GLException, InterruptedException {
        String string = text_1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                win_width = MiscUtils.atoi(stringArray[++i], win_width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                win_height = MiscUtils.atoi(stringArray[++i], win_height);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-font")) {
                font = FontFactory.get((InputStream)IOUtil.getResource((String)stringArray[++i], (ClassLoader)PerfTextRendererNEWT00.class.getClassLoader(), PerfTextRendererNEWT00.class).getInputStream(), (boolean)true);
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-loop")) {
                if (0 < (loop_count = MiscUtils.atoi(stringArray[++i], loop_count))) continue;
                loop_count = Integer.MAX_VALUE;
                continue;
            }
            if (stringArray[i].equals("-long_text")) {
                string = text_long;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                do_vsync = true;
                continue;
            }
            if (stringArray[i].equals("-perf")) {
                do_perf = true;
                continue;
            }
            if (!stringArray[i].equals("-snap")) continue;
            do_snap = true;
        }
        System.err.println("Excessuive performance test enabled: " + do_perf);
        System.err.println("VSync requested: " + do_vsync);
        if (bl) {
            MiscUtils.waitForKey("Start");
        }
        PerfTextRendererNEWT00 perfTextRendererNEWT00 = new PerfTextRendererNEWT00();
        perfTextRendererNEWT00.test(2, 4, string);
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void test(int n, int n2, String string) throws InterruptedException, GLException, IOException {
        int n3;
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        Instant instant = Clock.getMonotonicTime();
        long l = Clock.currentNanos();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, win_width, win_height, false);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        if (!do_vsync) {
            gL2ES2.setSwapInterval(0);
        }
        if (0 != (n3 = gL2ES2.glGetError())) {
            System.err.println("Initial GL Error: " + n3);
        }
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(JoglVersion.getAllAvailableCapabilitiesInfo((AbstractGraphicsDevice)windowContext.window.getScreen().getDisplay().getGraphicsDevice(), null).toString());
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null, (boolean)false).toString());
        System.err.println("VSync Swap Interval: " + gL2ES2.getSwapInterval());
        System.err.println("GLDrawable surface size: " + windowContext.context.getGLDrawable().getSurfaceWidth() + " x " + windowContext.context.getGLDrawable().getSurfaceHeight());
        System.err.println("Requested Caps: " + gLCapabilities);
        System.err.println("Requested Region-RenderModes: " + Region.getRenderModeString((int)n));
        System.err.println("Chosen Caps: " + windowContext.window.getChosenCapabilities());
        System.err.println("Chosen Font: " + font.getFullFamilyName());
        GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        RegionRenderer regionRenderer = RegionRenderer.create((RegionRenderer.GLCallback)RegionRenderer.defaultBlendEnable, (RegionRenderer.GLCallback)RegionRenderer.defaultBlendDisable);
        regionRenderer.setHintBits(2);
        regionRenderer.setAAQuality(1);
        regionRenderer.setSampleCount(n2);
        GLRegion gLRegion = GLRegion.create((GLProfile)gL2ES2.getGLProfile(), (int)n, null, (Font)font, (CharSequence)string);
        System.err.println("Region post ctor w/ pre-calculated buffer size");
        gLRegion.printBufferStats(System.err);
        Perf perf = new Perf();
        if (do_perf) {
            gLRegion.perfCounter().enable(true);
        }
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        AffineTransform affineTransform3 = new AffineTransform();
        for (int i = 0; i < loop_count; ++i) {
            long l2 = Clock.currentNanos();
            if (null != perf) {
                ++perf.count;
            }
            gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            regionRenderer.init(gL2ES2);
            regionRenderer.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
            gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
            regionRenderer.reshapeOrtho(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0.1f, 1000.0f);
            gL2ES2.glClear(16640);
            gLRegion.clear(gL2ES2);
            long l3 = Clock.currentNanos();
            float f = font.getAdvanceWidth(font.getGlyphID('X'));
            affineTransform.setToTranslation(2.0f * f, 0.0f);
            AABBox aABBox = font.getGlyphBounds((CharSequence)string, affineTransform2, affineTransform3);
            AABBox aABBox2 = TextRegionUtil.addStringToRegion((Region)gLRegion, (Font)font, (AffineTransform)affineTransform, (CharSequence)string, (Vec4f)this.fg_color, (AffineTransform)affineTransform2, (AffineTransform)affineTransform3);
            long l4 = Clock.currentNanos();
            float f2 = (float)gLDrawable.getSurfaceWidth() / (aABBox2.getWidth() + 4.0f * f);
            if (0 == i && !do_perf) {
                System.err.println("Text_1: tbox " + aABBox);
                System.err.println("Text_1: rbox " + aABBox2);
                System.err.println("Font scale: " + f2);
            }
            f = (float)gLDrawable.getSurfaceHeight() - 2.0f * f2 * font.getLineHeight();
            aABBox = regionRenderer.getMatrix();
            aABBox.loadMvIdentity();
            aABBox.translateMv(0.0f, f, -1000.0f);
            aABBox.scaleMv(f2, f2, 1.0f);
            gLRegion.draw(gL2ES2, regionRenderer);
            long l5 = Clock.currentNanos();
            if (null != perf) {
                long l6 = l3 - l2;
                long l7 = l4 - l3;
                long l8 = l5 - l4;
                long l9 = l5 - l3;
                perf.td_graph += l6;
                perf.td_txt += l7;
                perf.td_draw += l8;
                perf.td_txt_draw += l9;
                if (0 == i) {
                    Duration duration = Duration.between(Clock.getMonotonicStartupTime(), t0i);
                    Duration duration2 = Duration.between(Clock.getMonotonicStartupTime(), instant);
                    long l10 = l - t0;
                    long l11 = l2 - t0;
                    long l12 = l3 - t0;
                    long l13 = l4 - t0;
                    long l14 = l5 - t0;
                    System.err.printf("%n%n%3d: Perf Launch:%n- loading GlueGen - loading test %,6d [ms]%n- loading GlueGen - start test   %,6d [ms]%n- loading test    - start test   %,6d [ms]%n- loading test    - gl           %,6d [ms]%n- loading test    - graph        %,6d [ms]%n- loading test    - txt          %,6d [ms]%n- loading test    - draw         %,6d [ms]%n", i + 1, duration.toMillis(), duration2.toMillis(), TimeUnit.NANOSECONDS.toMillis(l10), TimeUnit.NANOSECONDS.toMillis(l11), TimeUnit.NANOSECONDS.toMillis(l12), TimeUnit.NANOSECONDS.toMillis(l13), TimeUnit.NANOSECONDS.toMillis(l14));
                    perf.print(System.err, i + 1, "Launch");
                }
            }
            if (loop_count - 1 == i && do_snap) {
                gL2ES2.glFinish();
                PerfTextRendererNEWT00.printScreen(gLReadBufferUtil, n, gLDrawable, (GL)gL2ES2, false, n2);
            }
            gLDrawable.swapBuffers();
            if (null != perf && loop_count / 2 - 1 == i) {
                if (do_perf) {
                    gLRegion.perfCounter().print(System.err);
                }
                perf.print(System.err, i + 1, "Frame" + (i + 1));
                perf.clear();
                if (do_perf) {
                    gLRegion.perfCounter().clear();
                }
            }
            if (0 != i && loop_count - 1 != i) continue;
            System.err.println("GLRegion: for " + gL2ES2.getGLProfile() + " using int32_t indiced: " + gLRegion.usesI32Idx());
            System.err.println("GLRegion: " + gLRegion);
            System.err.println("Text length: " + string.length());
            gLRegion.printBufferStats(System.err);
            if (do_perf) {
                gLRegion.perfCounter().print(System.err);
            }
            perf.print(System.err, i + 1, "Frame" + (i + 1));
        }
        gLRegion.destroy(gL2ES2);
        PerfTextRendererNEWT00.sleep();
        gLReadBufferUtil.dispose((GL)gL2ES2);
        regionRenderer.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    public static void printScreen(GLReadBufferUtil gLReadBufferUtil, int n, GLDrawable gLDrawable, GL gL, boolean bl, int n2) throws GLException, IOException {
        String string = Region.getRenderModeString((int)n);
        String string2 = String.format((Locale)null, "%s-msaa%02d-%03dx%03d-%s%04d", "TestTextRendererNEWT00-snap0", gLDrawable.getChosenGLCapabilities().getNumSamples(), gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), string, n2);
        String string3 = "./" + string2 + ".png";
        if (gLReadBufferUtil.readPixels(gL, false)) {
            gLReadBufferUtil.write(new File(string3));
        }
    }

    static {
        try {
            font = FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeSans.ttf", (ClassLoader)FontSet01.class.getClassLoader(), FontSet01.class).getInputStream(), (boolean)true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class Perf {
        public long td_graph = 0L;
        public long td_txt = 0L;
        public long td_draw = 0L;
        public long td_txt_draw = 0L;
        public long count = 0L;

        public Perf() {
            Instant instant = Clock.getMonotonicStartupTime();
            Instant instant2 = Clock.getMonotonicTime();
            Instant instant3 = Clock.getWallClockTime();
            Duration duration = Duration.between(instant, instant2);
            System.err.printf("Perf: Elapsed since startup: %,d [ms], %,d [ns]%n", duration.toMillis(), duration.toNanos());
            System.err.printf("- monotonic startup %s, %,d [ms]%n", instant, instant.toEpochMilli());
            System.err.printf("- monotonic current %s, %,d [ms]%n", instant2, instant2.toEpochMilli());
            System.err.printf("-      wall current %s%n", instant3);
            long l = Clock.currentNanos();
            System.err.printf("- currentNanos: Elapsed %,d [ns]%n", l - t0);
            System.err.printf("  - test-startup %,13d [ns]%n", t0);
            System.err.printf("  - test-current %,13d [ns]%n", l);
        }

        public void clear() {
            this.td_graph = 0L;
            this.td_txt = 0L;
            this.td_draw = 0L;
            this.td_txt_draw = 0L;
            this.count = 0L;
        }

        public void print(PrintStream printStream, long l, String string) {
            printStream.printf("%3d / %3d: Perf %s:   Total: graph %,2d, txt %,2d, draw %,2d, txt+draw %,2d [ms]%n", this.count, l, string, TimeUnit.NANOSECONDS.toMillis(this.td_graph), TimeUnit.NANOSECONDS.toMillis(this.td_txt), TimeUnit.NANOSECONDS.toMillis(this.td_draw), TimeUnit.NANOSECONDS.toMillis(this.td_txt_draw));
            printStream.printf("%3d / %3d: Perf %s: PerLoop: graph %,4d, txt %,4d, draw %,4d, txt+draw %,4d [ns]%n", this.count, l, string, this.td_graph / this.count, this.td_txt / this.count, this.td_draw / this.count, this.td_txt_draw / this.count);
        }
    }
}

