/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.util.IOUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT01
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static boolean useMSAA = true;
    static int win_width = 1024;
    static int win_height = 640;
    static Font font;
    static float fontSize;
    static String customStr;
    private GLReadBufferUtil screenshot;
    int lastRow = -1;
    private int screenshot_num = 0;

    @BeforeClass
    public static void setup() throws IOException {
        if (null == font) {
            font = FontFactory.get((int)0).get(1, 0);
        }
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWT01.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                win_width = TestTextRendererNEWT01.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                win_height = TestTextRendererNEWT01.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-noMSAA")) {
                useMSAA = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-font")) {
                font = FontFactory.get((InputStream)IOUtil.getResource((String)stringArray[++i], (ClassLoader)TestTextRendererNEWT01.class.getClassLoader(), TestTextRendererNEWT01.class).getInputStream(), (boolean)true);
                continue;
            }
            if (stringArray[i].equals("-fontSize")) {
                fontSize = MiscUtils.atof(stringArray[++i], fontSize);
                continue;
            }
            if (!stringArray[i].equals("-text")) continue;
            customStr = stringArray[++i];
        }
        String string = TestTextRendererNEWT01.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void test00TextRendererNONE00() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(0, 0);
    }

    @Test
    public void test01TextRendererMSAA04() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(0, 4);
    }

    @Test
    public void test02TextRendererVBAA04() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(2, 4);
    }

    void testTextRendererImpl(int n, int n2) throws InterruptedException, GLException, IOException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        if (0 < n2 && !Region.isVBAA((int)n)) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n2);
        }
        System.err.println("Requested: " + gLCapabilities);
        System.err.println("Requested: " + Region.getRenderModeString((int)n));
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, win_width, win_height, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        System.err.println("Chosen: " + windowContext.window.getChosenCapabilities());
        RegionRenderer regionRenderer = RegionRenderer.create((RegionRenderer.GLCallback)RegionRenderer.defaultBlendEnable, (RegionRenderer.GLCallback)RegionRenderer.defaultBlendDisable);
        regionRenderer.setHintBits(2);
        TextRegionUtil textRegionUtil = new TextRegionUtil(n);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        regionRenderer.init(gL2ES2);
        regionRenderer.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        this.screenshot = new GLReadBufferUtil(false, false);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        regionRenderer.reshapeOrtho(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0.1f, 1000.0f);
        int[] nArray = new int[]{n2};
        gL2ES2.glClear(16640);
        if (null == customStr) {
            float[] fArray = windowContext.window.getPixelsPerMM(new float[2]);
            float[] fArray2 = FontScale.ppmmToPPI((float[])fArray, (float[])new float[2]);
            float f = fontSize / fArray[1];
            int n3 = font.getMetrics().getUnitsPerEM();
            String string = String.format("Resolution dpiV %.2f, %.2f px/mm", Float.valueOf(fArray2[1]), Float.valueOf(fArray[1]));
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, string, 0, 0, -1000, nArray);
            string = String.format("Font %s, unitsPerEM %d, size %.2f px %2f mm", font.getFullFamilyName(), n3, Float.valueOf(fontSize), Float.valueOf(f));
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, string, 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "012345678901234567890123456789", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "Hello World", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "4567890123456", 4, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "I like JogAmp", 4, -1, -1000, nArray);
            int n4 = 0;
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "GlueGen", n4++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOAL", n4++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOGL", n4++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOCL", n4++, -1, -1000, nArray);
        } else {
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, customStr, 0, 0, -1000, nArray);
        }
        gL2ES2.glFinish();
        this.printScreen(n, gLDrawable, (GL)gL2ES2, false, n2);
        gLDrawable.swapBuffers();
        TestTextRendererNEWT01.sleep();
        this.screenshot.dispose((GL)gL2ES2);
        regionRenderer.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    void renderString(GLDrawable gLDrawable, GL2ES2 gL2ES2, RegionRenderer regionRenderer, TextRegionUtil textRegionUtil, String string, int n, int n2, int n3, int[] nArray) {
        int n4 = gLDrawable.getSurfaceHeight();
        float f = 0.0f;
        float f2 = n4;
        if (0 > n2) {
            n2 = this.lastRow + 1;
        }
        AABBox aABBox = font.getMetricBounds((CharSequence)string);
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        pMVMatrix4f.loadMvIdentity();
        pMVMatrix4f.translateMv(f += fontSize * font.getAdvanceWidth(font.getGlyphID('X')) * (float)n, f2 -= fontSize * aABBox.getHeight() * (float)(n2 + 1), (float)n3);
        pMVMatrix4f.scaleMv(fontSize, fontSize, 1.0f);
        textRegionUtil.drawString3D(gL2ES2, regionRenderer, font, (CharSequence)string, null);
        this.lastRow = n2;
    }

    public void printScreen(int n, GLDrawable gLDrawable, GL gL, boolean bl, int n2) throws GLException, IOException {
        String string = this.getSimpleTestName(".") + "-snap" + this.screenshot_num;
        ++this.screenshot_num;
        String string2 = Region.getRenderModeString((int)n);
        String string3 = String.format((Locale)null, "%s-msaa%02d-fontsz%02.1f-%03dx%03d-%s%04d", string, gLDrawable.getChosenGLCapabilities().getNumSamples(), Float.valueOf(fontSize), gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), string2, n2);
        String string4 = "./" + string3 + ".png";
        if (this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(new File(string4));
        }
    }

    static {
        fontSize = 24.0f;
        customStr = null;
    }
}

