/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.graph.FontSet01;
import com.jogamp.opengl.test.junit.graph.GPUTextRendererListenerBase01;
import com.jogamp.opengl.test.junit.graph.MSAATool;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import java.io.File;
import java.io.IOException;
import jogamp.common.os.PlatformPropsImpl;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT20
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static int win_width = 1024;
    static int win_height = 640;
    static int[] aaQualitySet = new int[]{0, 1};
    static int[] sampleSet = new int[]{4};
    static Font[] fontSet = new Font[0];

    @BeforeClass
    public static void setup() {
        if (fontSet.length == 0) {
            try {
                fontSet = FontSet01.getSet00();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWT20.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                win_width = TestTextRendererNEWT20.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                win_height = TestTextRendererNEWT20.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-font")) {
                fontSet = new Font[]{FontFactory.get((File)new File(stringArray[++i]))};
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                sampleSet = new int[]{TestTextRendererNEWT20.atoi(stringArray[++i])};
                continue;
            }
            if (!stringArray[i].equals("-aaq")) continue;
            aaQualitySet = new int[]{TestTextRendererNEWT20.atoi(stringArray[++i])};
        }
        String string = TestTextRendererNEWT20.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        if (!gLCapabilitiesImmutable.getSampleBuffers()) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(true));
        }
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void test00TextRendererVBAA01() throws InterruptedException, GLException, IOException {
        if (Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = TestTextRendererNEWT20.createWindow("TTRN20", (GLCapabilitiesImmutable)gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        final TextGLListener textGLListener = new TextGLListener(gLProfile, 2, 1, 4, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        textGLListener.setHeadBox(2, true);
        gLWindow.display();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                textGLListener.setHeadBox(1, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
                textGLListener.setHeadBox(2, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
            }
        };
        for (Font font : fontSet) {
            if (!textGLListener.setFont(font)) continue;
            for (int n : aaQualitySet) {
                textGLListener.getRenderer().setAAQuality(n);
                for (int n2 : sampleSet) {
                    textGLListener.getRenderer().setSampleCount(n2);
                    runnable.run();
                }
            }
        }
        TestTextRendererNEWT20.destroyWindow(gLWindow);
    }

    @Test
    public void test10TextRendererMSAA01() throws InterruptedException, GLException, IOException {
        if (Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = TestTextRendererNEWT20.createWindow("TTRN20", (GLCapabilitiesImmutable)gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        final TextGLListener textGLListener = new TextGLListener(gLProfile, 1, -1, 4, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        textGLListener.setHeadBox(2, true);
        gLWindow.display();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                textGLListener.setHeadBox(1, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
                textGLListener.setHeadBox(2, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
            }
        };
        for (Font font : fontSet) {
            if (!textGLListener.setFont(font)) continue;
            for (int n : sampleSet) {
                textGLListener.getRenderer().setSampleCount(n);
                runnable.run();
            }
        }
        TestTextRendererNEWT20.destroyWindow(gLWindow);
    }

    @Test
    public void test20TextRendererFSAA01() throws InterruptedException, GLException, IOException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        System.err.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = TestTextRendererNEWT20.createWindow("TTRN20", (GLCapabilitiesImmutable)gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        final TextGLListener textGLListener = new TextGLListener(gLProfile, 0, -1, 0, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        textGLListener.setHeadBox(2, true);
        gLWindow.display();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                textGLListener.setHeadBox(1, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
                textGLListener.setHeadBox(2, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
            }
        };
        for (Font font : fontSet) {
            if (!textGLListener.setFont(font)) continue;
            runnable.run();
        }
        TestTextRendererNEWT20.destroyWindow(gLWindow);
    }

    @Test
    public void test30TextRendererNoSampling() throws InterruptedException, GLException, IOException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = TestTextRendererNEWT20.createWindow("TTRN20", (GLCapabilitiesImmutable)gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        final TextGLListener textGLListener = new TextGLListener(gLProfile, 0, -1, 0, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        textGLListener.setHeadBox(2, true);
        gLWindow.display();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                textGLListener.setHeadBox(1, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
                textGLListener.setHeadBox(2, false);
                gLWindow.display();
                textGLListener.printScreenOnGLThread((GLAutoDrawable)gLWindow, "./", gLWindow.getTitle(), "", false);
                TestTextRendererNEWT20.sleep();
            }
        };
        for (Font font : fontSet) {
            if (!textGLListener.setFont(font)) continue;
            runnable.run();
        }
        TestTextRendererNEWT20.destroyWindow(gLWindow);
    }

    private static class TextGLListener
    extends GPUTextRendererListenerBase01 {
        public TextGLListener(GLProfile gLProfile, int n, int n2, int n3, boolean bl, boolean bl2) {
            super(gLProfile, n, n2, n3, true, bl, bl2);
        }

        @Override
        public void attachInputListenerTo(GLWindow gLWindow) {
            super.attachInputListenerTo(gLWindow);
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.setSwapInterval(1);
            gL2ES2.glEnable(2929);
            System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null, (boolean)false).toString());
            MSAATool.dump(gLAutoDrawable);
            this.getRenderer().setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            super.display(gLAutoDrawable);
        }
    }
}

