/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.util.StringUtil;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import java.io.IOException;

public abstract class TextRendererGLELBase
implements GLEventListener {
    public final int renderModes;
    protected final int[] vbaaSampleCount;
    protected final float[] staticRGBAColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private boolean exclusivePMVMatrix = true;
    private PMVMatrix4f sharedPMVMatrix = null;
    private RegionRenderer.GLCallback enableCallback = null;
    private RegionRenderer.GLCallback disableCallback = null;
    protected RegionRenderer renderer = null;
    protected TextRegionUtil textRenderUtil = null;
    protected final AffineTransform tempT1 = new AffineTransform();
    protected final AffineTransform tempT2 = new AffineTransform();
    protected float pixelScale = 1.0f;
    protected float dpiH = 96.0f;
    boolean flipVerticalInGLOrientation = false;
    int lastRow = -1;

    public static Font getFont(int n, int n2, int n3) {
        try {
            return FontFactory.get((int)n).get(n2, n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public TextRendererGLELBase(int n, int[] nArray) {
        this.renderModes = n;
        this.vbaaSampleCount = nArray;
    }

    public void setSharedPMVMatrix(PMVMatrix4f pMVMatrix4f) {
        this.sharedPMVMatrix = pMVMatrix4f;
    }

    public void setRendererCallbacks(RegionRenderer.GLCallback gLCallback, RegionRenderer.GLCallback gLCallback2) {
        this.enableCallback = gLCallback;
        this.disableCallback = gLCallback2;
    }

    public void setFlipVerticalInGLOrientation(boolean bl) {
        this.flipVerticalInGLOrientation = bl;
    }

    public final RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final TextRegionUtil getTextRenderUtil() {
        return this.textRenderUtil;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.exclusivePMVMatrix = null == this.sharedPMVMatrix;
        this.renderer = RegionRenderer.create((PMVMatrix4f)this.sharedPMVMatrix, (RegionRenderer.GLCallback)this.enableCallback, (RegionRenderer.GLCallback)this.disableCallback);
        this.getRenderer().setHintBits(2);
        this.textRenderUtil = new TextRegionUtil(this.renderModes);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.renderer.init(gL2ES2);
        this.renderer.setColorStatic(this.staticRGBAColor[0], this.staticRGBAColor[1], this.staticRGBAColor[2], this.staticRGBAColor[3]);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            float[] fArray = FontScale.ppmmToPPI((float[])((Window)object).getPixelsPerMM(new float[2]));
            this.dpiH = fArray[1];
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null != this.renderer) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.renderer.enable(gL2ES2, true);
            if (this.exclusivePMVMatrix) {
                this.renderer.reshapeOrtho(n3, n4, 0.1f, 1000.0f);
                this.pixelScale = 1.0f;
            } else {
                this.renderer.reshapeNotify(n, n2, n3, n4);
            }
            this.renderer.enable(gL2ES2, false);
        }
    }

    public abstract void display(GLAutoDrawable var1);

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null != this.renderer) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.renderer.destroy(gL2ES2);
        }
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, float f2, float f3, float f4, boolean bl) {
        int n2 = this.lastRow + 1;
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, bl, null);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, float f2, float f3, float f4, GLRegion gLRegion) {
        int n2 = this.lastRow + 1;
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, false, gLRegion);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, int n2, float f2, float f3, float f4, boolean bl) {
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, bl, null);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, int n2, float f2, float f3, float f4, GLRegion gLRegion) {
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, false, gLRegion);
    }

    private void renderStringImpl(GLAutoDrawable gLAutoDrawable, Font font, float f, CharSequence charSequence, int n, int n2, float f2, float f3, float f4, boolean bl, GLRegion gLRegion) {
        if (null != this.renderer) {
            float f5;
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            float f6 = f2;
            if (!this.exclusivePMVMatrix) {
                f5 = 1.0f - f3;
            } else {
                int n3 = gLAutoDrawable.getSurfaceHeight();
                f5 = (float)n3 - f3;
            }
            float f7 = this.pixelScale * f;
            int n4 = StringUtil.getLineCount((CharSequence)charSequence);
            float f8 = font.getLineHeight();
            f6 += f7 * font.getAdvanceWidth(font.getGlyphID('X')) * (float)n;
            f5 -= f7 * f8 * (float)(n2 + 1);
            PMVMatrix4f pMVMatrix4f = this.renderer.getMatrix();
            if (!this.exclusivePMVMatrix) {
                pMVMatrix4f.pushMv();
            } else {
                pMVMatrix4f.loadMvIdentity();
            }
            pMVMatrix4f.translateMv(f6, f5, f4);
            if (this.flipVerticalInGLOrientation && gLAutoDrawable.isGLOriented()) {
                pMVMatrix4f.scaleMv(f7, -1.0f * f7, 1.0f);
            } else {
                pMVMatrix4f.scaleMv(f7, f7, 1.0f);
            }
            this.renderer.enable(gL2ES2, true);
            if (bl) {
                this.textRenderUtil.drawString3D(gL2ES2, this.renderer, font, charSequence, null);
            } else if (null != gLRegion) {
                TextRegionUtil.drawString3D((GL2ES2)gL2ES2, (GLRegion)gLRegion, (RegionRenderer)this.renderer, (Font)font, (CharSequence)charSequence, null, (AffineTransform)this.tempT1, (AffineTransform)this.tempT2);
            } else {
                TextRegionUtil.drawString3D((GL2ES2)gL2ES2, (int)this.renderModes, (RegionRenderer)this.renderer, (Font)font, (CharSequence)charSequence, null, (AffineTransform)this.tempT1, (AffineTransform)this.tempT2);
            }
            this.renderer.enable(gL2ES2, false);
            if (!this.exclusivePMVMatrix) {
                pMVMatrix4f.popMv();
            }
            this.lastRow = n2 + n4;
        }
    }
}

