/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class GLProfile0XBase
extends UITestCase {
    protected static void validateGLProfileGL4bc(GLProfile gLProfile) {
        Assert.assertTrue((boolean)gLProfile.isGL4bc());
        Assert.assertTrue((boolean)gLProfile.isGL4());
        Assert.assertTrue((boolean)gLProfile.isGL3bc());
        Assert.assertTrue((boolean)gLProfile.isGL3());
        Assert.assertTrue((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertTrue((boolean)gLProfile.isGL2GL3());
        Assert.assertTrue((boolean)gLProfile.isGL4ES3());
        Assert.assertTrue((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertTrue((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGL4bc(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertTrue((boolean)gL.isGL4bc());
        Assert.assertTrue((boolean)gL.isGL4());
        Assert.assertTrue((boolean)gL.isGL3bc());
        Assert.assertTrue((boolean)gL.isGL3());
        Assert.assertTrue((boolean)gL.isGL2());
        Assert.assertTrue((boolean)gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gL.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gL.isGL4ES3());
        }
        Assert.assertTrue((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertTrue((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertTrue((boolean)gLContext.isGL4bc());
        Assert.assertTrue((boolean)gLContext.isGL4());
        Assert.assertTrue((boolean)gLContext.isGL3bc());
        Assert.assertTrue((boolean)gLContext.isGL3());
        Assert.assertTrue((boolean)gLContext.isGL2());
        Assert.assertTrue((boolean)gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gLContext.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gLContext.isGL4ES3());
        }
        Assert.assertTrue((boolean)gLContext.isGL3ES3());
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertTrue((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGL4(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertTrue((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertTrue((boolean)gLProfile.isGL3());
        Assert.assertFalse((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertTrue((boolean)gLProfile.isGL2GL3());
        Assert.assertTrue((boolean)gLProfile.isGL4ES3());
        Assert.assertTrue((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertFalse((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGL4(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertTrue((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertTrue((boolean)gL.isGL3());
        Assert.assertFalse((boolean)gL.isGL2());
        Assert.assertTrue((boolean)gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gL.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gL.isGL4ES3());
        }
        Assert.assertTrue((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertFalse((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertTrue((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertTrue((boolean)gLContext.isGL3());
        Assert.assertFalse((boolean)gLContext.isGL2());
        Assert.assertTrue((boolean)gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gLContext.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gLContext.isGL4ES3());
        }
        Assert.assertTrue((boolean)gLContext.isGL3ES3());
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertFalse((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGL3bc(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertTrue((boolean)gLProfile.isGL3bc());
        Assert.assertTrue((boolean)gLProfile.isGL3());
        Assert.assertTrue((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertTrue((boolean)gLProfile.isGL2GL3());
        Assert.assertFalse((boolean)gLProfile.isGL4ES3());
        Assert.assertTrue((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertTrue((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGL3bc(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertTrue((boolean)gL.isGL3bc());
        Assert.assertTrue((boolean)gL.isGL3());
        Assert.assertTrue((boolean)gL.isGL2());
        Assert.assertTrue((boolean)gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gL.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gL.isGL4ES3());
        }
        Assert.assertTrue((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertTrue((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertTrue((boolean)gLContext.isGL3bc());
        Assert.assertTrue((boolean)gLContext.isGL3());
        Assert.assertTrue((boolean)gLContext.isGL2());
        Assert.assertTrue((boolean)gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gLContext.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gLContext.isGL4ES3());
        }
        Assert.assertTrue((boolean)gLContext.isGL3ES3());
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertTrue((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGL3(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertTrue((boolean)gLProfile.isGL3());
        Assert.assertFalse((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertTrue((boolean)gLProfile.isGL2GL3());
        Assert.assertFalse((boolean)gLProfile.isGL4ES3());
        Assert.assertTrue((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertFalse((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGL3(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertTrue((boolean)gL.isGL3());
        Assert.assertFalse((boolean)gL.isGL2());
        Assert.assertTrue((boolean)gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gL.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gL.isGL4ES3());
        }
        Assert.assertTrue((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertFalse((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertTrue((boolean)gLContext.isGL3());
        Assert.assertFalse((boolean)gLContext.isGL2());
        Assert.assertTrue((boolean)gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue((boolean)gLContext.isGL4ES3());
        } else {
            Assert.assertFalse((boolean)gLContext.isGL4ES3());
        }
        Assert.assertTrue((boolean)gLContext.isGL3ES3());
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertFalse((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGL2(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertFalse((boolean)gLProfile.isGL3());
        Assert.assertTrue((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertTrue((boolean)gLProfile.isGL2GL3());
        Assert.assertFalse((boolean)gLProfile.isGL4ES3());
        Assert.assertFalse((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertTrue((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGL2(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertFalse((boolean)gL.isGL3());
        Assert.assertTrue((boolean)gL.isGL2());
        Assert.assertTrue((boolean)gL.isGL2GL3());
        Assert.assertFalse((boolean)gL.isGL4ES3());
        Assert.assertFalse((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertTrue((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertFalse((boolean)gLContext.isGL3());
        Assert.assertTrue((boolean)gLContext.isGL2());
        Assert.assertTrue((boolean)gLContext.isGL2GL3());
        Assert.assertFalse((boolean)gLContext.isGL4ES3());
        Assert.assertFalse((boolean)gLContext.isGL3ES3());
        Assert.assertFalse((boolean)bl);
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertTrue((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES3(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertFalse((boolean)gLProfile.isGL3());
        Assert.assertFalse((boolean)gLProfile.isGL2());
        Assert.assertTrue((boolean)gLProfile.isGLES3());
        Assert.assertTrue((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertFalse((boolean)gLProfile.isGL2GL3());
        Assert.assertTrue((boolean)gLProfile.isGL4ES3());
        Assert.assertTrue((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertFalse((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGLES3(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertFalse((boolean)gL.isGL3());
        Assert.assertFalse((boolean)gL.isGL2());
        Assert.assertFalse((boolean)gL.isGL2GL3());
        Assert.assertTrue((boolean)gL.isGL4ES3());
        Assert.assertTrue((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertFalse((boolean)gL.isGL2ES1());
        Assert.assertTrue((boolean)gL.isGLES3());
        Assert.assertTrue((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertFalse((boolean)gLContext.isGL3());
        Assert.assertFalse((boolean)gLContext.isGL2());
        Assert.assertFalse((boolean)gLContext.isGL2GL3());
        Assert.assertTrue((boolean)gLContext.isGL4ES3());
        Assert.assertTrue((boolean)gLContext.isGL3ES3());
        Assert.assertTrue((boolean)bl);
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertFalse((boolean)gLContext.isGL2ES1());
        Assert.assertTrue((boolean)gLContext.isGLES3());
        Assert.assertTrue((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES2(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertFalse((boolean)gLProfile.isGL3());
        Assert.assertFalse((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertTrue((boolean)gLProfile.isGLES2());
        Assert.assertFalse((boolean)gLProfile.isGLES1());
        Assert.assertFalse((boolean)gLProfile.isGL2GL3());
        Assert.assertFalse((boolean)gLProfile.isGL4ES3());
        Assert.assertFalse((boolean)gLProfile.isGL3ES3());
        Assert.assertTrue((boolean)gLProfile.isGL2ES2());
        Assert.assertFalse((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGLES2(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertFalse((boolean)gL.isGL3());
        Assert.assertFalse((boolean)gL.isGL2());
        Assert.assertFalse((boolean)gL.isGL2GL3());
        Assert.assertFalse((boolean)gL.isGL4ES3());
        Assert.assertFalse((boolean)gL.isGL3ES3());
        Assert.assertTrue((boolean)gL.isGL2ES2());
        Assert.assertFalse((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertTrue((boolean)gL.isGLES2());
        Assert.assertFalse((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertFalse((boolean)gLContext.isGL3());
        Assert.assertFalse((boolean)gLContext.isGL2());
        Assert.assertFalse((boolean)gLContext.isGL2GL3());
        Assert.assertFalse((boolean)gLContext.isGL4ES3());
        Assert.assertFalse((boolean)gLContext.isGL3ES3());
        Assert.assertFalse((boolean)bl);
        Assert.assertTrue((boolean)gLContext.isGL2ES2());
        Assert.assertFalse((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertTrue((boolean)gLContext.isGLES2());
        Assert.assertFalse((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES1(GLProfile gLProfile) {
        Assert.assertFalse((boolean)gLProfile.isGL4bc());
        Assert.assertFalse((boolean)gLProfile.isGL4());
        Assert.assertFalse((boolean)gLProfile.isGL3bc());
        Assert.assertFalse((boolean)gLProfile.isGL3());
        Assert.assertFalse((boolean)gLProfile.isGL2());
        Assert.assertFalse((boolean)gLProfile.isGLES3());
        Assert.assertFalse((boolean)gLProfile.isGLES2());
        Assert.assertTrue((boolean)gLProfile.isGLES1());
        Assert.assertFalse((boolean)gLProfile.isGL2GL3());
        Assert.assertFalse((boolean)gLProfile.isGL4ES3());
        Assert.assertFalse((boolean)gLProfile.isGL3ES3());
        Assert.assertFalse((boolean)gLProfile.isGL2ES2());
        Assert.assertTrue((boolean)gLProfile.isGL2ES1());
    }

    protected static void validateGLES1(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse((boolean)gL.isGL4bc());
        Assert.assertFalse((boolean)gL.isGL4());
        Assert.assertFalse((boolean)gL.isGL3bc());
        Assert.assertFalse((boolean)gL.isGL3());
        Assert.assertFalse((boolean)gL.isGL2());
        Assert.assertFalse((boolean)gL.isGL2GL3());
        Assert.assertFalse((boolean)gL.isGL4ES3());
        Assert.assertFalse((boolean)gL.isGL3ES3());
        Assert.assertFalse((boolean)gL.isGL2ES2());
        Assert.assertTrue((boolean)gL.isGL2ES1());
        Assert.assertFalse((boolean)gL.isGLES3());
        Assert.assertFalse((boolean)gL.isGLES2());
        Assert.assertTrue((boolean)gL.isGLES1());
        Assert.assertFalse((boolean)gLContext.isGL4bc());
        Assert.assertFalse((boolean)gLContext.isGL4());
        Assert.assertFalse((boolean)gLContext.isGL3bc());
        Assert.assertFalse((boolean)gLContext.isGL3());
        Assert.assertFalse((boolean)gLContext.isGL2());
        Assert.assertFalse((boolean)gLContext.isGL2GL3());
        Assert.assertFalse((boolean)gLContext.isGL4ES3());
        Assert.assertFalse((boolean)gLContext.isGL3ES3());
        Assert.assertFalse((boolean)bl);
        Assert.assertFalse((boolean)gLContext.isGL2ES2());
        Assert.assertTrue((boolean)gLContext.isGL2ES1());
        Assert.assertFalse((boolean)gLContext.isGLES3());
        Assert.assertFalse((boolean)gLContext.isGLES2());
        Assert.assertTrue((boolean)gLContext.isGLES1());
    }

    protected static void validateGLProfileGL2GL3(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else {
            throw new GLException("GL2GL3 is neither GL4bc, GL3bc, GL2, GL4 nor GL3");
        }
    }

    protected static void validateGL2GL3(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else {
            throw new GLException("GL2GL3 is neither GL4bc, GL3bc, GL2, GL4 nor GL3");
        }
    }

    protected static void validateGLProfileGL4ES3(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else {
            throw new GLException("GL4ES3 is neither GL4bc, GL4 nor GLES3");
        }
    }

    protected static void validateGL4ES3(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else {
            throw new GLException("GL4ES3 is neither GL4bc, GL4 nor GLES3");
        }
    }

    protected static void validateGLProfileGL2ES2(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (gLProfile.isGLES2()) {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else {
            throw new GLException("GL2ES2 is neither GL4bc, GL3bc, GL2, GL4, GL3, GLES3 nor GLES2");
        }
    }

    protected static void validateGL2ES2(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else if (gL.isGLES2()) {
            GLProfile0XBase.validateGLES2(gL);
        } else {
            throw new GLException("GL2ES2 is neither GL4bc, GL3bc, GL2, GL4, GL3, GLES3 nor GLES2");
        }
    }

    protected static void validateGLProfileGL2ES1(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGLES1()) {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        } else {
            throw new GLException("GL2ES1 is neither GL4bc, GL3bc, GL2 nor GLES1");
        }
    }

    protected static void validateGL2ES1(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGLES1()) {
            GLProfile0XBase.validateGLES1(gL);
        } else {
            throw new GLException("GL2ES1 is neither GL4bc, GL3bc, GL2 nor GLES1");
        }
    }

    protected static void validateOffline(String string, GLProfile gLProfile) {
        System.err.println("GLProfile Mapping " + string + " -> " + gLProfile);
        boolean bl = GLContext.isGLES3CompatibleAvailable((AbstractGraphicsDevice)GLProfile.getDefaultDevice());
        if (gLProfile.getImplName().equals("GL4bc")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2GL3"));
            if (bl) {
                Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            } else {
                Assert.assertFalse((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            }
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL3bc")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL2")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL4")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2GL3"));
            if (bl) {
                Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            } else {
                Assert.assertFalse((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            }
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL3")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES3")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GLES3"));
            if (bl) {
                Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            } else {
                Assert.assertFalse((boolean)GLProfile.isAvailable((String)"GL4ES3"));
            }
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES2")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GLES2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES1")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GLES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
        }
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (gLProfile.isGLES2()) {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else if (gLProfile.isGLES1()) {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        }
        if (string == "GL4bc") {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (string == "GL3bc") {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (string == "GL2") {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (string == "GL4") {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (string == "GL3") {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (string == "GLES3") {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (string == "GLES2") {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else if (string == "GLES1") {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        } else if (string == "GL2GL3") {
            GLProfile0XBase.validateGLProfileGL2GL3(gLProfile);
        } else if (string == "GL4ES3") {
            GLProfile0XBase.validateGLProfileGL4ES3(gLProfile);
        } else if (string == "GL2ES2") {
            GLProfile0XBase.validateGLProfileGL2ES2(gLProfile);
        } else if (string == "GL2ES1") {
            GLProfile0XBase.validateGLProfileGL2ES1(gLProfile);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void validateOnline(String string, GLProfile gLProfile, GL gL) {
        GLContext gLContext = gL.getContext();
        GLProfile gLProfile2 = gL.getGLProfile();
        System.err.println("GLContext Mapping " + string + " -> " + gLProfile + " -> " + gLProfile2 + " -> " + gLContext.getGLVersion());
        System.err.println("GL impl. class " + gL.getClass().getName());
        if (gL.isGL4()) {
            Assert.assertNotNull((Object)gL.getGL4());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4");
        }
        if (gL.isGL4bc()) {
            Assert.assertNotNull((Object)gL.getGL4bc());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4bc");
        }
        if (gL.isGL3()) {
            Assert.assertNotNull((Object)gL.getGL3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3");
        }
        if (gL.isGL3bc()) {
            Assert.assertNotNull((Object)gL.getGL3bc());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3bc");
        }
        if (gL.isGL2()) {
            Assert.assertNotNull((Object)gL.getGL2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2");
        }
        if (gL.isGLES3()) {
            Assert.assertNotNull((Object)gL.getGLES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES3");
        }
        if (gL.isGLES2()) {
            Assert.assertNotNull((Object)gL.getGLES2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES2");
        }
        if (gL.isGLES1()) {
            Assert.assertNotNull((Object)gL.getGLES1());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES1");
        }
        if (gL.isGL4ES3()) {
            Assert.assertNotNull((Object)gL.getGL4ES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4ES3");
        }
        if (gL.isGL3ES3()) {
            Assert.assertNotNull((Object)gL.getGL3ES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3ES3");
        }
        if (gL.isGL2GL3()) {
            Assert.assertNotNull((Object)gL.getGL2GL3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2GL3");
        }
        if (gL.isGL2ES2()) {
            Assert.assertNotNull((Object)gL.getGL2ES2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2ES2");
        }
        if (gL.isGL2ES1()) {
            Assert.assertNotNull((Object)gL.getGL2ES1());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2ES1");
        }
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else if (gL.isGLES2()) {
            GLProfile0XBase.validateGLES2(gL);
        } else if (gL.isGLES1()) {
            GLProfile0XBase.validateGLES1(gL);
        }
        if (string == "GL4bc") {
            GLProfile0XBase.validateGL4bc(gL);
            return;
        } else if (string == "GL3bc") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else {
                if (!gL.isGL3bc()) throw new GLException("GL3bc is neither GL4bc nor GL3bc");
                GLProfile0XBase.validateGL3bc(gL);
            }
            return;
        } else if (string == "GL2") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else if (gL.isGL3bc()) {
                GLProfile0XBase.validateGL3bc(gL);
                return;
            } else {
                if (!gL.isGL2()) throw new GLException("GL2 is neither GL4bc, GL3bc, GL2");
                GLProfile0XBase.validateGL2(gL);
            }
            return;
        } else if (string == "GL4") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else {
                if (!gL.isGL4()) throw new GLException("GL4 is neither GL4bc, nor GL4");
                GLProfile0XBase.validateGL4(gL);
            }
            return;
        } else if (string == "GL3") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else if (gL.isGL3bc()) {
                GLProfile0XBase.validateGL3bc(gL);
                return;
            } else if (gL.isGL4()) {
                GLProfile0XBase.validateGL4(gL);
                return;
            } else {
                if (!gL.isGL3()) throw new GLException("GL3 is neither GL4bc, GL3bc, GL4 nor GL3");
                GLProfile0XBase.validateGL3(gL);
            }
            return;
        } else if (string == "GLES3") {
            GLProfile0XBase.validateGLES3(gL);
            return;
        } else if (string == "GLES2") {
            if (gL.isGLES3()) {
                GLProfile0XBase.validateGLES3(gL);
                return;
            } else {
                if (!gL.isGLES2()) throw new GLException("GLES2 is neither GLES3 nor GLES2");
                GLProfile0XBase.validateGLES2(gL);
            }
            return;
        } else if (string == "GLES1") {
            GLProfile0XBase.validateGLES1(gL);
            return;
        } else if (string == "GL2GL3") {
            GLProfile0XBase.validateGL2GL3(gL);
            return;
        } else if (string == "GL4ES3") {
            GLProfile0XBase.validateGL4ES3(gL);
            return;
        } else if (string == "GL2ES2") {
            GLProfile0XBase.validateGL2ES2(gL);
            return;
        } else {
            if (string != "GL2ES1") return;
            GLProfile0XBase.validateGL2ES1(gL);
        }
    }

    protected void validateOnlineOnscreen(final String string, final GLProfile gLProfile) throws InterruptedException {
        boolean bl;
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLStrings((GL)gL, null, (boolean)false));
                GLProfile0XBase.validateOnline(string, gLProfile, gL);
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        gLWindow.display();
        Thread.sleep(100L);
        boolean bl2 = Platform.OSType.MACOS == Platform.getOSType();
        boolean bl3 = bl = null != System.getProperty("jogl.disable.openglarbcontext") && !bl2;
        if (bl) {
            Assert.assertFalse((String)"Property 'jogl.disable.openglarbcontext' set, but created w/ ARB", (boolean)gLWindow.getContext().isCreatedWithARBMethod());
        }
        gLWindow.destroy();
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
    }

    protected void validateOnlineOffscreen(final String string, final GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        boolean bl;
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 128, 128);
        Assert.assertNotNull((Object)gLOffscreenAutoDrawable);
        gLOffscreenAutoDrawable.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLStrings((GL)gL, null, (boolean)false));
                GLProfile0XBase.validateOnline(string, gLCapabilitiesImmutable.getGLProfile(), gL);
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLOffscreenAutoDrawable.display();
        Thread.sleep(100L);
        boolean bl2 = Platform.OSType.MACOS == Platform.getOSType();
        boolean bl3 = bl = PropertyAccess.isPropertyDefined((String)"jogl.disable.openglarbcontext", (boolean)true) && !bl2;
        if (bl) {
            Assert.assertFalse((String)"Property 'jogl.disable.openglarbcontext' set, but created w/ ARB", (boolean)gLOffscreenAutoDrawable.getContext().isCreatedWithARBMethod());
        }
        gLOffscreenAutoDrawable.destroy();
    }
}

