/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.DumpGLInfo;
import com.jogamp.opengl.test.junit.util.GLClearColor;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1146GLContextDialogToolTipAWT
extends UITestCase {
    static final int NB_TEST = 5;
    static final int ACTION_DELAY = 500;
    static final int MOVE_DELAY = 2;
    static final int MOVE_ITER = 100;
    static final int TOOLTIP_WAIT = 3000;

    static AbstractButton findButton(int n, Container container, String string) {
        AbstractButton abstractButton = null;
        int n2 = container.getComponentCount();
        for (int i = 0; null == abstractButton && i < n2; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton2 = (AbstractButton)component;
                String string2 = abstractButton2.getText();
                if (!string.equals(string2)) continue;
                abstractButton = abstractButton2;
                continue;
            }
            if (!(component instanceof Container)) continue;
            abstractButton = TestBug1146GLContextDialogToolTipAWT.findButton(n + 1, (Container)component, string);
        }
        return abstractButton;
    }

    private void oneTest(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        final JDialog jDialog = new JDialog((Window)null);
        jDialog.setMinimumSize(new Dimension(500, 300));
        jDialog.setPreferredSize(new Dimension(500, 300));
        jDialog.setModal(false);
        GLEventListenerCounter gLEventListenerCounter = new GLEventListenerCounter();
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas.addGLEventListener((GLEventListener)new DumpGLInfo(Platform.getNewline() + Platform.getNewline() + "Pre-ToolTip", false, false, false));
        gLCanvas.addGLEventListener((GLEventListener)new GLClearColor(1.0f, 0.0f, 0.0f, 1.0f));
        gLCanvas.addGLEventListener((GLEventListener)gLEventListenerCounter);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)gLCanvas, "Center");
        jPanel.setPreferredSize(new Dimension(300, 300));
        GLEventListenerCounter gLEventListenerCounter2 = new GLEventListenerCounter();
        final GLCanvas gLCanvas2 = new GLCanvas(gLCapabilitiesImmutable);
        gLCanvas2.addGLEventListener((GLEventListener)new DumpGLInfo(Platform.getNewline() + Platform.getNewline() + "Post-ToolTip", false, false, false));
        gLCanvas2.addGLEventListener((GLEventListener)new GLClearColor(0.0f, 0.0f, 1.0f, 1.0f));
        gLCanvas2.addGLEventListener((GLEventListener)gLEventListenerCounter2);
        final JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gLCanvas2, "Center");
        jPanel2.setPreferredSize(new Dimension(300, 300));
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText("Approved");
        jFileChooser.setApproveButtonToolTipText("Tool-Tip for Approved");
        jFileChooser.setAccessory(jPanel);
        Locale locale = jFileChooser.getLocale();
        final String string = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        new InterruptSource.Thread(){

            public void run() {
                try {
                    Object object;
                    Cloneable cloneable;
                    Point point;
                    Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFileChooser, true, null));
                    Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLCanvas, true, null));
                    AbstractButton abstractButton = TestBug1146GLContextDialogToolTipAWT.findButton(0, jFileChooser, "Approved");
                    if (null != abstractButton) {
                        point = abstractButton.getLocationOnScreen();
                        cloneable = abstractButton.getSize();
                        point.translate(((Dimension)cloneable).width / 2, ((Dimension)cloneable).height / 2);
                        System.err.println("OK Button: " + abstractButton.getClass().getSimpleName() + "; " + abstractButton + ", " + point);
                    } else {
                        System.err.println("OK Button: NULL");
                        point = null;
                    }
                    AbstractButton abstractButton2 = TestBug1146GLContextDialogToolTipAWT.findButton(0, jFileChooser, string);
                    if (null != abstractButton) {
                        cloneable = abstractButton2.getLocationOnScreen();
                        object = abstractButton2.getSize();
                        ((Point)cloneable).translate(((Dimension)object).width / 2, ((Dimension)object).height / 2);
                        System.err.println("CANCEL Button: " + abstractButton2.getClass().getSimpleName() + "; " + abstractButton2 + ", " + cloneable);
                    } else {
                        cloneable = null;
                        System.err.println("CANCEL Button: NULL");
                    }
                    object = new Robot();
                    if (null != point) {
                        AWTRobotUtil.mouseMove((Robot)object, point, 100, 2);
                        Thread.sleep(3000L);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    jFileChooser.setAccessory(jPanel2);
                                    jFileChooser.validate();
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLCanvas2, true, null));
                    }
                    if (null != cloneable) {
                        AWTRobotUtil.mouseClick((Robot)object, (Point)cloneable, 100, 2, 500);
                    } else {
                        jFileChooser.cancelSelection();
                    }
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }.start();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jDialog.setVisible(true);
                    jFileChooser.showOpenDialog(jDialog);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    gLCanvas.destroy();
                    gLCanvas2.destroy();
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter2.initCount);
    }

    @Test(timeout=180000L)
    public void test01() {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        for (int i = 0; i < 5; ++i) {
            System.out.println("Iteration  " + i + " / " + 5);
            this.oneTest((GLCapabilitiesImmutable)gLCapabilities);
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug1146GLContextDialogToolTipAWT.class.getName()});
    }
}

