/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1398Deadlock02AWT
extends UITestCase {
    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    protected void runTestGL(GLCapabilities gLCapabilities, final boolean bl) throws InterruptedException {
        final Frame frame = new Frame("TestBug1398AWT");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2());
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setUpdateFPSFrames(10, System.err);
        frame.add((Component)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                animator.stop();
                frame.dispose();
                System.exit(0);
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(512, 512);
                    if (bl) {
                        frame.setExtendedState(6);
                    }
                    frame.validate();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        animator.start();
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized((Component)gLCanvas, true, null));
        Assert.assertEquals((Object)true, (Object)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLCanvas, true, null));
        Thread.sleep(1000L);
        Assert.assertTrue((0 < animator.getTotalFPSFrames() ? 1 : 0) != 0);
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test(timeout=10000L)
    public void test01NoDeadlock() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile Default: " + gLProfile);
        if (gLProfile.isGL2ES2()) {
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities, false);
        } else {
            System.out.println("not a GL2ES2 profile");
        }
    }

    @Test(timeout=10000L)
    public void test02TriggerDeadlock() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile Default: " + gLProfile);
        if (gLProfile.isGL2ES2()) {
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities, true);
        } else {
            System.out.println("not a GL2ES2 profile");
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug1398Deadlock02AWT.class.getName()});
    }
}

