/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestDestroyGLAutoDrawableNewtAWT
extends UITestCase {
    static long duration = 100L;

    static void destroyGLAD(GLAutoDrawable gLAutoDrawable, int n) {
        String string = Thread.currentThread().toString();
        System.err.println(string + ": Destroy mode " + n + ": Start: Realised " + gLAutoDrawable.isRealized());
        gLAutoDrawable.destroy();
        System.err.println(string + ": Destroy mode " + n + ": End: Realised " + gLAutoDrawable.isRealized());
    }

    protected void runTestGL(int n) throws InterruptedException, InvocationTargetException, AWTException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("TestDestroyGLAutoDrawableNewtAWT Mode " + n);
        gLWindow.addGLEventListener((GLEventListener)new RedSquareES2().setVerbose(false));
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyNotify(WindowEvent windowEvent) {
                System.err.println("Window DestroyNotify: " + windowEvent);
            }

            public void windowDestroyed(WindowEvent windowEvent) {
                System.err.println("Window Destroyed: " + windowEvent);
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                System.err.println("Window Focus Gained: " + windowEvent);
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                System.err.println("Window Focus Lost: " + windowEvent);
            }
        });
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                System.err.println("KEY PRESSED: " + keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                System.err.println("KEY RELEASED: " + keyEvent);
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 81: {
                        TestDestroyGLAutoDrawableNewtAWT.destroyGLAD((GLAutoDrawable)gLWindow, 10);
                    }
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                System.err.println("MOUSE PRESSED: " + mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                System.err.println("MOUSE RELEASED: " + mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                System.err.println("MOUSE CLICKED: " + mouseEvent);
                TestDestroyGLAutoDrawableNewtAWT.destroyGLAD((GLAutoDrawable)gLWindow, 11);
            }
        };
        gLWindow.setSize(256, 256);
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(30, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(30L);
        }
        System.err.println("AWT Robot Init");
        int[] nArray = AWTRobotUtil.getCenterLocation(gLWindow, false);
        Point point = new Point(nArray[0], nArray[1]);
        AWTRobotUtil.awtRobotMouseMove(robot, point.x, point.y);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.awtRobotMouseMove(robot, point.x, point.y);
        AWTRobotUtil.waitForIdle(robot);
        System.err.println("AWT Robot OK");
        switch (n) {
            case 1: {
                animator.stop();
                try {
                    gLWindow.invoke(true, gLAutoDrawable -> {
                        TestDestroyGLAutoDrawableNewtAWT.destroyGLAD(gLAutoDrawable, 1);
                        return true;
                    });
                }
                catch (GLException gLException) {
                    System.err.println("Expected exception: " + gLException.getMessage());
                }
                break;
            }
            case 2: {
                gLWindow.runOnEDTIfAvail(true, () -> TestDestroyGLAutoDrawableNewtAWT.destroyGLAD((GLAutoDrawable)gLWindow, 2));
                break;
            }
            case 3: {
                new InterruptSource.Thread(() -> TestDestroyGLAutoDrawableNewtAWT.destroyGLAD((GLAutoDrawable)gLWindow, 3)).start();
                break;
            }
            case 10: {
                gLWindow.addKeyListener(keyListener);
                AWTRobotUtil.waitForIdle(robot);
                AWTRobotUtil.newtKeyPress(0, robot, true, (short)81, 10);
                AWTRobotUtil.newtKeyPress(0, robot, false, (short)81, 100);
                break;
            }
            case 11: {
                gLWindow.addMouseListener((MouseListener)mouseAdapter);
                AWTRobotUtil.waitForIdle(robot);
                AWTRobotUtil.mouseClick(robot, point, 1, 100, 0);
                break;
            }
            default: {
                TestDestroyGLAutoDrawableNewtAWT.destroyGLAD((GLAutoDrawable)gLWindow, 0);
            }
        }
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
    }

    @Test
    public void test00OnThread() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(0);
    }

    @Test
    public void test01RenderThread() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(1);
    }

    @Test
    public void test02EDTThread() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(2);
    }

    @Test
    public void test03ExtThread() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(3);
    }

    @Test
    public void test10EDTKeyEvent() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(10);
    }

    @Test
    public void test11EDTMouseEvent() throws InterruptedException, InvocationTargetException, AWTException {
        this.runTestGL(11);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestDestroyGLAutoDrawableNewtAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

