/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.FBOMix2DemosES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOAutoDrawableFactoryNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    @Test
    public void test01a_GL2ES2_Demo1_SingleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        this.testGLFBODrawableImpl(gLCapabilities, 1, (GLEventListener)new GearsES2(0));
    }

    @Test
    public void test01b_GL2ES2_Demo1_SingleBuffer_NoTex() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        this.testGLFBODrawableImpl(gLCapabilities, 0, (GLEventListener)new GearsES2(0));
    }

    @Test
    public void test01c_GL2ES2_Demo1_SingleBuffer_NoTexNoDepth() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setDepthBits(0);
        this.testGLFBODrawableImpl(gLCapabilities, 0, (GLEventListener)new GearsES2(0));
    }

    @Test
    public void test02a_GL2ES2_Demo1_DoubleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(true);
        this.testGLFBODrawableImpl(gLCapabilities, 1, (GLEventListener)new GearsES2(0));
    }

    @Test
    public void test03a_GL2ES2_Demo2MSAA4_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 1, new MultisampleDemoES2(true));
    }

    @Test
    public void test03b_GL2ES2_Demo2MSAA4_NoTex() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new MultisampleDemoES2(true));
    }

    @Test
    public void test03c_GL2ES2_Demo2MSAA4_NoTexNoDepth() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setDepthBits(0);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new MultisampleDemoES2(true));
    }

    @Test
    public void test04_GL2ES2_FBODemoMSAA4_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        FBOMix2DemosES2 fBOMix2DemosES2 = new FBOMix2DemosES2(0);
        fBOMix2DemosES2.setDoRotation(false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 1, fBOMix2DemosES2);
    }

    @Test
    public void test11_EGLES2_Demo0Normal() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GLES2")) {
            GLProfile gLProfile = GLProfile.get((String)"GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.testGLFBODrawableImpl(gLCapabilities, 1, (GLEventListener)new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    @Test
    public void test13_EGLES2_Demo0MSAA4() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GLES2")) {
            GLProfile gLProfile = GLProfile.get((String)"GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            this.testGLFBODrawableImpl(gLCapabilities, 1, (GLEventListener)new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    @Test
    public void test21_GL3_Demo0Normal() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GL3")) {
            GLProfile gLProfile = GLProfile.get((String)"GL3");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.testGLFBODrawableImpl(gLCapabilities, 1, (GLEventListener)new GearsES2(0));
        } else {
            System.err.println("GL3 n/a");
        }
    }

    void testGLFBODrawableImpl(GLCapabilities gLCapabilities, int n, GLEventListener gLEventListener) throws InterruptedException {
        FBObject fBObject;
        Object object;
        FBObject.RenderAttachment renderAttachment;
        FBObject.RenderAttachment renderAttachment2;
        gLCapabilities.setFBO(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        GLOffscreenAutoDrawable.FBO fBO = (GLOffscreenAutoDrawable.FBO)gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull((Object)fBO);
        System.out.println("Requested:     " + gLCapabilities);
        System.out.println("Realized GLAD: " + fBO);
        System.out.println("Realized GLAD: " + fBO.getChosenGLCapabilities());
        Assert.assertTrue((String)"FBO drawable is initialized before ctx creation", (!fBO.isInitialized() ? 1 : 0) != 0);
        fBO.setFBOMode(n);
        fBO.display();
        GLContext gLContext = fBO.getContext();
        Assert.assertNotNull((Object)gLContext);
        Assert.assertTrue((boolean)gLContext.isCreated());
        Assert.assertTrue((String)"FBO drawable is not initialized after ctx creation", (boolean)fBO.isInitialized());
        boolean bl = gLCapabilities.getDepthBits() > 0;
        boolean bl2 = fBO.getRequestedGLCapabilities().getDepthBits() > 0;
        boolean bl3 = fBO.getChosenGLCapabilities().getDepthBits() > 0;
        System.out.println("Depth: exp " + bl + ", req " + bl2 + ", has " + bl3);
        Assert.assertEquals((String)"Depth: expected not passed to requested", (Object)bl, (Object)bl2);
        Assert.assertEquals((String)"Depth: requested not passed to chosen", (Object)bl2, (Object)bl3);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = fBO.getChosenGLCapabilities();
        System.out.println("Init GLAD: " + fBO);
        System.out.println("Init GLAD: " + gLCapabilitiesImmutable);
        FBObject fBObject2 = fBO.getFBObject(1028);
        FBObject fBObject3 = fBO.getFBObject(1029);
        System.out.println("Init front FBO: " + fBObject2);
        System.out.println("Init back  FBO: " + fBObject3);
        Assert.assertTrue((String)"FBO drawable is not initialized before ctx creation", (boolean)fBO.isInitialized());
        Assert.assertTrue((String)"FBO Front is not initialized before ctx creation", (boolean)fBObject2.isInitialized());
        Assert.assertTrue((String)"FBO Back  is not initialized before ctx creation", (boolean)fBObject3.isInitialized());
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            Assert.assertNotEquals((String)("FBO are equal: " + fBObject2 + " == " + fBObject3), (Object)fBObject2, (Object)fBObject3);
            Assert.assertNotSame((Object)fBObject2, (Object)fBObject3);
        } else {
            Assert.assertEquals((String)("FBO are not equal: " + fBObject2 + " != " + fBObject3), (Object)fBObject2, (Object)fBObject3);
            Assert.assertSame((Object)fBObject2, (Object)fBObject3);
        }
        FBObject.Colorbuffer colorbuffer = fBO.getColorbuffer(1028);
        FBObject.Colorbuffer colorbuffer2 = 0 == fBO.getNumSamples() ? fBO.getColorbuffer(1029) : null;
        boolean bl4 = 0 != (1 & fBO.getFBOMode());
        System.out.println("Texture: exp " + bl4 + ", hasFront " + colorbuffer.isTextureAttachment());
        Assert.assertEquals((String)"Texture: Front", (Object)bl4, (Object)colorbuffer.isTextureAttachment());
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals((String)"Texture: Back", (Object)bl4, (Object)colorbuffer2.isTextureAttachment());
        }
        FBObject.Colorbuffer colorbuffer3 = fBObject2.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer3);
        FBObject.Colorbuffer colorbuffer4 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer4);
        Assert.assertEquals((String)"Texture: Front", (Object)bl4, (Object)colorbuffer3.isTextureAttachment());
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals((String)"Texture: Back", (Object)bl4, (Object)colorbuffer4.isTextureAttachment());
        } else {
            Assert.assertEquals((String)"Texture: MSAA Back is Texture", (Object)false, (Object)colorbuffer4.isTextureAttachment());
        }
        if (bl3) {
            renderAttachment2 = fBObject2.getDepthAttachment();
            Assert.assertNotNull((Object)renderAttachment2);
            renderAttachment = fBObject3.getDepthAttachment();
            Assert.assertNotNull((Object)renderAttachment);
        } else {
            renderAttachment2 = null;
            renderAttachment = null;
        }
        fBO.display();
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            Assert.assertNotEquals((String)("Color attachments are equal: " + colorbuffer4 + " == " + colorbuffer3), (Object)colorbuffer3, (Object)colorbuffer4);
            Assert.assertNotSame((Object)colorbuffer4, (Object)colorbuffer3);
            if (bl3) {
                Assert.assertNotEquals((String)("Depth attachments are equal: " + renderAttachment + " == " + renderAttachment2), (Object)renderAttachment2, (Object)renderAttachment);
                Assert.assertNotSame((Object)renderAttachment, (Object)renderAttachment2);
            }
        } else {
            Assert.assertEquals((Object)colorbuffer3, (Object)colorbuffer4);
            Assert.assertSame((Object)colorbuffer3, (Object)colorbuffer4);
            Assert.assertEquals((Object)renderAttachment2, (Object)renderAttachment);
            Assert.assertSame((Object)renderAttachment2, (Object)renderAttachment);
        }
        Assert.assertEquals((Object)colorbuffer, (Object)colorbuffer3);
        Assert.assertSame((Object)colorbuffer, (Object)colorbuffer3);
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals((Object)colorbuffer2, (Object)colorbuffer4);
            Assert.assertSame((Object)colorbuffer2, (Object)colorbuffer4);
        }
        if (gLCapabilitiesImmutable.getNumSamples() > 0) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject2 + " != " + object), (Object)fBObject2, (Object)object);
            Assert.assertSame((Object)fBObject2, (Object)object);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject3 + " != " + fBObject), (Object)fBObject3, (Object)fBObject);
            Assert.assertSame((Object)fBObject3, (Object)fBObject);
        } else if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject3 + " != " + object), (Object)fBObject3, (Object)object);
            Assert.assertSame((Object)fBObject3, (Object)object);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject2 + " != " + fBObject), (Object)fBObject2, (Object)fBObject);
            Assert.assertSame((Object)fBObject2, (Object)fBObject);
        } else {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject2 + " != " + object), (Object)fBObject2, (Object)object);
            Assert.assertSame((Object)fBObject2, (Object)object);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject3 + " != " + object), (Object)fBObject3, (Object)object);
            Assert.assertSame((Object)fBObject3, (Object)object);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject3 + " != " + fBObject), (Object)fBObject3, (Object)fBObject);
            Assert.assertSame((Object)fBObject3, (Object)fBObject);
            Assert.assertEquals((String)("FBO are not equal: " + fBObject2 + " != " + fBObject), (Object)fBObject2, (Object)fBObject);
            Assert.assertSame((Object)fBObject2, (Object)fBObject);
        }
        fBO.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        fBO.addGLEventListener((GLEventListener)object);
        fBO.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 1;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep, null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        FBObject fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize1.oldFront: " + fBObject2);
        System.out.println("Resize1.nowFront: " + fBObject);
        System.out.println("Resize1.oldBack : " + fBObject3);
        System.out.println("Resize1.nowBack : " + fBObject4);
        Assert.assertEquals((Object)fBObject2, (Object)fBObject);
        Assert.assertSame((Object)fBObject2, (Object)fBObject);
        Assert.assertEquals((Object)fBObject3, (Object)fBObject4);
        Assert.assertSame((Object)fBObject3, (Object)fBObject4);
        FBObject.Colorbuffer colorbuffer5 = fBObject.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer5);
        Assert.assertEquals((Object)colorbuffer3, (Object)colorbuffer5);
        Assert.assertSame((Object)colorbuffer3, (Object)colorbuffer5);
        FBObject.RenderAttachment renderAttachment3 = fBObject.getDepthAttachment();
        System.err.println("Resize1.oldDepth " + renderAttachment2);
        System.err.println("Resize1.newDepth " + renderAttachment3);
        if (bl3) {
            Assert.assertNotNull((Object)renderAttachment3);
        }
        Assert.assertEquals((Object)renderAttachment2, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment2, (Object)renderAttachment3);
        renderAttachment3 = fBObject4.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull((Object)renderAttachment3);
        }
        Assert.assertEquals((Object)renderAttachment, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment, (Object)renderAttachment3);
        colorbuffer5 = fBObject.getColorbuffer(colorbuffer3);
        Assert.assertNotNull((Object)colorbuffer5);
        Assert.assertEquals((Object)colorbuffer3, (Object)colorbuffer5);
        Assert.assertSame((Object)colorbuffer3, (Object)colorbuffer5);
        this.szStep = 4;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep, null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize2.oldFront: " + fBObject2);
        System.out.println("Resize2.nowFront: " + fBObject);
        System.out.println("Resize2.oldBack : " + fBObject3);
        System.out.println("Resize2.nowBack : " + fBObject4);
        if (gLCapabilitiesImmutable.getDoubleBuffered() && 0 == gLCapabilitiesImmutable.getNumSamples()) {
            Assert.assertEquals((Object)fBObject3, (Object)fBObject);
            Assert.assertEquals((Object)fBObject2, (Object)fBObject4);
        } else {
            Assert.assertEquals((Object)fBObject2, (Object)fBObject);
            Assert.assertEquals((Object)fBObject3, (Object)fBObject4);
        }
        colorbuffer5 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer5);
        Assert.assertEquals((Object)colorbuffer4, (Object)colorbuffer5);
        Assert.assertSame((Object)colorbuffer4, (Object)colorbuffer5);
        renderAttachment3 = fBObject3.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull((Object)renderAttachment3);
        }
        Assert.assertEquals((Object)renderAttachment, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment, (Object)renderAttachment3);
        renderAttachment3 = fBObject2.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull((Object)renderAttachment3);
        }
        Assert.assertEquals((Object)renderAttachment2, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment2, (Object)renderAttachment3);
        colorbuffer5 = fBObject3.getColorbuffer(colorbuffer4);
        Assert.assertNotNull((Object)colorbuffer5);
        Assert.assertEquals((Object)colorbuffer4, (Object)colorbuffer5);
        Assert.assertSame((Object)colorbuffer4, (Object)colorbuffer5);
        int n2 = gLCapabilitiesImmutable.getNumSamples();
        int n3 = n2 > 0 ? 0 : 4;
        System.out.println("Resize3.sampleCount: " + n2 + " -> " + n3);
        fBO.setNumSamples(fBO.getGL(), n3);
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 3;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep, null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.destroy();
        System.out.println("Fin: " + fBO);
    }

    public static void main(String[] stringArray) throws Exception {
        JUnitCore.main((String[])new String[]{TestFBOAutoDrawableFactoryNEWT.class.getName()});
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

