/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.GLFinishOnDisplay;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.Mix2TexturesES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOOnThreadSharedContext1DemoES2NEWT
extends UITestCase {
    static long duration = 500L;
    static int swapInterval = 1;
    static boolean showFPS = false;
    static boolean forceES2 = false;
    static boolean mainRun = false;

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval);
        if (mainRun) {
            gLWindow.setSize(512, 512);
        } else {
            gLWindow.setSize(256, 256);
        }
        gLWindow.setVisible(true);
        gLWindow.display();
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
        final Mix2TexturesES2 mix2TexturesES2 = new Mix2TexturesES2(1, 0, 0);
        final GLOffscreenAutoDrawable.FBO fBO = (GLOffscreenAutoDrawable.FBO)gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        fBO.setSharedAutoDrawable((GLAutoDrawable)gLWindow);
        fBO.setUpstreamWidget((Object)gLWindow);
        fBO.setTextureUnit(0);
        GearsES2 gearsES2 = new GearsES2(-1);
        fBO.addGLEventListener((GLEventListener)gearsES2);
        fBO.addGLEventListener((GLEventListener)new GLFinishOnDisplay());
        gearsES2.setIgnoreFocus(true);
        fBO.getNativeSurface().addSurfaceUpdatedListener(new SurfaceUpdatedListener(){

            public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
                mix2TexturesES2.setTexID0(fBO.getColorbuffer(1028).getName());
            }
        });
        fBO.display();
        System.err.println("FBOD1 " + fBO);
        Assert.assertTrue((boolean)fBO.isInitialized());
        mix2TexturesES2.setTexID0(fBO.getColorbuffer(1028).getName());
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                fBO.setSurfaceSize(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
            }
        });
        gLWindow.addGLEventListener((GLEventListener)mix2TexturesES2);
        gLWindow.addGLEventListener(new GLEventListener(){
            int i = 0;
            int c = 0;

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (mainRun) {
                    return;
                }
                final int n = gLAutoDrawable.getSurfaceWidth();
                final int n2 = gLAutoDrawable.getSurfaceHeight();
                ++this.c;
                if (n < 800) {
                    System.err.println("XXX: " + n + "x" + n2 + ", c " + this.c);
                    if (8 == this.c) {
                        TestFBOOnThreadSharedContext1DemoES2NEWT.this.snapshot(this.i++, "msaa" + fBO.getNumSamples(), gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                    }
                    if (9 == this.c) {
                        this.c = 0;
                        new InterruptSource.Thread(){

                            public void run() {
                                gLWindow.setSize(n + 256, n2 + 256);
                            }
                        }.start();
                    }
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        gearsES2 = new Animator(0);
        gearsES2.add((GLAutoDrawable)fBO);
        gearsES2.add((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }
        });
        gearsES2.start();
        gLWindow.setVisible(true);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        gearsES2.setUpdateFPSFrames(60, showFPS ? System.err : null);
        while (!quitAdapter.shouldQuit() && gearsES2.isAnimating() && gearsES2.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        gearsES2.stop();
        Assert.assertFalse((boolean)gearsES2.isAnimating());
        Assert.assertFalse((boolean)gearsES2.isStarted());
        fBO.destroy();
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
    }

    @Test
    public void test01() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        gLCapabilities.setAlphaBits(1);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-nomain")) continue;
            mainRun = false;
        }
        System.err.println("swapInterval " + swapInterval);
        System.err.println("forceES2 " + forceES2);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestFBOOnThreadSharedContext1DemoES2NEWT.class.getName()});
    }
}

