/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableDelegateOnOffscrnCapsNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        final Window window = NewtFactory.createWindow((CapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)window);
        window.setSize(200 * this.szStep, 150 * this.szStep);
        window.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible(window, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized(window, true, null));
        System.out.println("Window: " + window.getClass().getName());
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        System.out.println("Window Caps Pre_GL: " + capabilitiesImmutable);
        Assert.assertNotNull((Object)capabilitiesImmutable);
        Assert.assertTrue((capabilitiesImmutable.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getRedBits() > 5 ? 1 : 0) != 0);
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable((NativeSurface)window);
        Assert.assertNotNull((Object)gLDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        gLDrawable.setRealized(true);
        Assert.assertTrue((boolean)gLDrawable.isRealized());
        System.out.println("Window Caps PostGL   : " + window.getGraphicsConfiguration().getChosenCapabilities());
        System.out.println("Drawable   Post-GL(1): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLDrawable.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(1): " + gLCapabilitiesImmutable3);
        Assert.assertNotNull((Object)gLCapabilitiesImmutable3);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLCapabilitiesImmutable3.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLCapabilitiesImmutable3.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLCapabilitiesImmutable3.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLCapabilitiesImmutable3.isBitmap());
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull((Object)gLContext);
        int n = gLContext.makeCurrent();
        Assert.assertTrue((2 == n || 1 == n ? 1 : 0) != 0);
        gLContext.release();
        GLCapabilitiesImmutable gLCapabilitiesImmutable4 = gLDrawable.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(2): " + gLCapabilitiesImmutable4);
        System.out.println("Chosen     GL CTX (2): " + gLContext.getGLVersion());
        System.out.println("Drawable   Post-GL(2): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        Assert.assertNotNull((Object)gLCapabilitiesImmutable4);
        Assert.assertTrue((gLCapabilitiesImmutable4.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getRedBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getDepthBits() > 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLCapabilitiesImmutable4.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLCapabilitiesImmutable4.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLCapabilitiesImmutable4.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLCapabilitiesImmutable4.isBitmap());
        final GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, gLContext, window, false, null){

            protected void destroyImplInLock() {
                super.destroyImplInLock();
                window.destroy();
            }
        };
        window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                gLAutoDrawableDelegate.windowDestroyNotifyOp();
            }
        });
        window.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                gLAutoDrawableDelegate.windowRepaintOp();
            }

            public void windowResized(WindowEvent windowEvent) {
                gLAutoDrawableDelegate.windowResizedOp(window.getSurfaceWidth(), window.getSurfaceHeight());
            }
        });
        gLAutoDrawableDelegate.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLAutoDrawableDelegate.addGLEventListener((GLEventListener)snapshotGLEventListener);
        gLAutoDrawableDelegate.display();
        int[] nArray = gLAutoDrawableDelegate.getNativeSurface().convertToPixelUnits(new int[]{200 * this.szStep, 150 * this.szStep});
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLAutoDrawableDelegate.getSurfaceWidth() + "x" + gLAutoDrawableDelegate.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLAutoDrawableDelegate, nArray[0], nArray[1], null));
        snapshotGLEventListener.setMakeSnapshot();
        gLAutoDrawableDelegate.display();
        this.szStep = 1;
        window.setSize(200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLAutoDrawableDelegate.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLAutoDrawableDelegate.getSurfaceWidth() + "x" + gLAutoDrawableDelegate.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLAutoDrawableDelegate, nArray[0], nArray[1], null));
        snapshotGLEventListener.setMakeSnapshot();
        gLAutoDrawableDelegate.display();
        this.szStep = 4;
        window.setSize(200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLAutoDrawableDelegate.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLAutoDrawableDelegate.getSurfaceWidth() + "x" + gLAutoDrawableDelegate.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLAutoDrawableDelegate, nArray[0], nArray[1], null));
        snapshotGLEventListener.setMakeSnapshot();
        gLAutoDrawableDelegate.display();
        Thread.sleep(50L);
        gLAutoDrawableDelegate.destroy();
        System.out.println("Fin Drawable: " + gLDrawable);
        System.out.println("Fin Window: " + window);
    }

    @Test
    public void testAvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)false);
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getFactory((boolean)true))) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
    }

    @Test
    public void testGL2OnScreenSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenBitmapSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setBitmap(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new Gears(1));
    }

    @Test
    public void testES2OnScreenSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableDelegateOnOffscrnCapsNEWT.class.getName()});
    }
}

