/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableFactoryES2OffscrnCapsNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull((Object)gLOffscreenAutoDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLOffscreenAutoDrawable.getClass().getName() + ", " + gLOffscreenAutoDrawable.getNativeSurface().getClass().getName());
        Assert.assertTrue((boolean)gLOffscreenAutoDrawable.isRealized());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Drawable Caps Pre_GL : " + gLCapabilitiesImmutable3);
        Assert.assertNotNull((Object)gLCapabilitiesImmutable3);
        Assert.assertTrue((gLCapabilitiesImmutable3.getGreenBits() > 4 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getBlueBits() > 4 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getRedBits() > 4 ? 1 : 0) != 0);
        gLOffscreenAutoDrawable.display();
        GLCapabilitiesImmutable gLCapabilitiesImmutable4 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Chosen     GL CTX (1): " + gLOffscreenAutoDrawable.getContext().getGLVersion());
        System.out.println("Chosen     GL Caps(1): " + gLCapabilitiesImmutable4);
        System.out.println("Chosen     GL Caps(2): " + gLOffscreenAutoDrawable.getNativeSurface().getGraphicsConfiguration().getChosenCapabilities());
        Assert.assertNotNull((Object)gLCapabilitiesImmutable4);
        Assert.assertTrue((gLCapabilitiesImmutable4.getGreenBits() > 4 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getBlueBits() > 4 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getRedBits() > 4 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable4.getDepthBits() > 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLCapabilitiesImmutable4.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLCapabilitiesImmutable4.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLCapabilitiesImmutable4.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLCapabilitiesImmutable4.isBitmap());
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLOffscreenAutoDrawable.addGLEventListener((GLEventListener)snapshotGLEventListener);
        gLOffscreenAutoDrawable.display();
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep, null));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 1;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep, null));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 4;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep, null));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        Thread.sleep(50L);
        gLOffscreenAutoDrawable.destroy();
        System.out.println("Fin Drawable: " + gLOffscreenAutoDrawable);
    }

    @Test
    public void testES2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.class.getName()});
    }
}

