/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableFactoryGLProfileDeviceNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLProfile getProfile(AbstractGraphicsDevice abstractGraphicsDevice, String string) {
        if (!GLProfile.isAvailable((AbstractGraphicsDevice)abstractGraphicsDevice, (String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return GLProfile.get((AbstractGraphicsDevice)abstractGraphicsDevice, (String)string);
    }

    void doTest(boolean bl, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.err.println("Factory: " + gLDrawableFactory.getClass().getName());
        System.err.println("Requested GL Caps: " + gLCapabilitiesImmutable);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(abstractGraphicsDevice, gLCapabilitiesImmutable, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull((Object)gLOffscreenAutoDrawable);
        Assert.assertTrue((boolean)gLOffscreenAutoDrawable.isRealized());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        Assert.assertNotNull((Object)gLCapabilitiesImmutable2);
        gLOffscreenAutoDrawable.display();
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        Assert.assertNotNull((Object)gLCapabilitiesImmutable3);
        System.err.println("Choosen   GL Caps: " + gLCapabilitiesImmutable3);
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        GLEventListenerCounter gLEventListenerCounter = new GLEventListenerCounter();
        gLOffscreenAutoDrawable.addGLEventListener((GLEventListener)gLEventListenerCounter);
        gLOffscreenAutoDrawable.display();
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep, null));
        gLOffscreenAutoDrawable.display();
        this.szStep = 1;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep, null));
        gLOffscreenAutoDrawable.display();
        Thread.sleep(50L);
        AbstractGraphicsDevice abstractGraphicsDevice2 = gLOffscreenAutoDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
        gLOffscreenAutoDrawable.destroy();
        System.err.println("Fin isEGL " + bl + ", " + abstractGraphicsDevice2);
        System.err.println("Fin " + gLEventListenerCounter);
        Assert.assertTrue((String)("init count: " + gLEventListenerCounter), (gLEventListenerCounter.initCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("reshape count: " + gLEventListenerCounter), (gLEventListenerCounter.reshapeCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("display count: " + gLEventListenerCounter), (gLEventListenerCounter.displayCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("dispose count: " + gLEventListenerCounter), (gLEventListenerCounter.disposeCount > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)("EGL/Desktop not matching: isEGL " + bl + ", " + abstractGraphicsDevice2), (Object)bl, (Object)(abstractGraphicsDevice2 instanceof EGLGraphicsDevice));
    }

    @Test
    public void test00AvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)false);
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getFactory((boolean)true))) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
    }

    @Test
    public void test01ES2OnMobile() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)true);
        if (null == gLDrawableFactory) {
            System.err.println("Mobile Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GLES2");
        if (null != gLProfile) {
            Assert.assertTrue((String)("Not a GLES2 profile but " + gLProfile), (boolean)gLProfile.isGLES2());
            Assert.assertTrue((String)("Not a GL2ES2 profile but " + gLProfile), (boolean)gLProfile.isGL2ES2());
        }
        if (null == gLProfile) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory, abstractGraphicsDevice, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)gearsES2);
    }

    @Test
    public void test02GLOnMobile() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)true);
        if (null == gLDrawableFactory) {
            System.err.println("Mobile Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GL2GL3");
        if (null != gLProfile) {
            Assert.assertTrue((String)("Not a GL2GL3 profile but " + gLProfile), (boolean)gLProfile.isGL2GL3());
        }
        if (null == gLProfile || !gLProfile.isGL2ES2()) {
            if (null != gLProfile) {
                System.err.println("Not a GL2ES2 profile but " + gLProfile);
            }
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory, abstractGraphicsDevice, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)gearsES2);
    }

    @Test
    public void test11ES2OnDesktop() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)false);
        if (null == gLDrawableFactory) {
            System.err.println("Desktop Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GLES2");
        if (null != gLProfile) {
            Assert.assertTrue((String)("Not a GLES2 profile but " + gLProfile), (boolean)gLProfile.isGLES2());
            Assert.assertTrue((String)("Not a GL2ES2 profile but " + gLProfile), (boolean)gLProfile.isGL2ES2());
        }
        if (null == gLProfile) {
            return;
        }
        GLDrawableFactory gLDrawableFactory2 = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        if (null == gLDrawableFactory2) {
            System.err.println("Production Factory n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory2, abstractGraphicsDevice, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)gearsES2);
    }

    @Test
    public void test12GLOnDesktop() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((boolean)false);
        if (null == gLDrawableFactory) {
            System.err.println("Desktop Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GL2GL3");
        if (null != gLProfile) {
            Assert.assertTrue((String)("Not a GL2GL3 profile but " + gLProfile), (boolean)gLProfile.isGL2GL3());
        }
        if (null == gLProfile || !gLProfile.isGL2ES2()) {
            if (null != gLProfile) {
                System.err.println("Not a GL2ES2 profile but " + gLProfile);
            }
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(false, gLDrawableFactory, abstractGraphicsDevice, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)gearsES2);
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableFactoryGLProfileDeviceNEWT.class.getName()});
    }
}

