/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSize(200 * this.szStep, 150 * this.szStep);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        System.out.println("Window: " + gLWindow.getClass().getName());
        CapabilitiesImmutable capabilitiesImmutable = gLWindow.getGraphicsConfiguration().getChosenCapabilities();
        System.out.println("Window Caps Pre_GL: " + capabilitiesImmutable);
        Assert.assertNotNull((Object)capabilitiesImmutable);
        Assert.assertTrue((capabilitiesImmutable.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((capabilitiesImmutable.getRedBits() > 5 ? 1 : 0) != 0);
        GLDrawable gLDrawable = gLWindow.getDelegatedDrawable();
        Assert.assertNotNull((Object)gLDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        System.out.println("Window Caps PostGL   : " + gLWindow.getGraphicsConfiguration().getChosenCapabilities());
        System.out.println("Drawable   Post-GL(1): " + gLWindow.getClass().getName() + ", " + gLWindow.getNativeSurface().getClass().getName());
        gLDrawable = gLWindow.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(1): " + gLDrawable);
        Assert.assertNotNull((Object)gLDrawable);
        Assert.assertTrue((gLDrawable.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getRedBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getDepthBits() > 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLDrawable.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLDrawable.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLDrawable.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLDrawable.isBitmap());
        gLWindow.display();
        Object object = gLWindow.getContext();
        System.out.println("Chosen     GL CTX (2): " + object.getGLVersion());
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.isCreated());
        System.out.println("Chosen     GL Caps(2): " + gLWindow.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(2): " + gLWindow.getClass().getName() + ", " + gLWindow.getNativeSurface().getClass().getName());
        gLWindow.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.display();
        int[] nArray = gLWindow.getNativeSurface().convertToPixelUnits(new int[]{200 * this.szStep, 150 * this.szStep});
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        this.szStep = 1;
        gLWindow.setSize(200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLWindow.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        this.szStep = 4;
        gLWindow.setSize(200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLWindow.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        Thread.sleep(50L);
        gLWindow.destroy();
        System.out.println("Fin: " + gLWindow);
    }

    @Test
    public void testGL2OnScreenSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenBitmapSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setBitmap(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new Gears(1));
    }

    @Test
    public void testES2OnScreenSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OnScreenDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OnScreenDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OnScreenDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableGLWindowOnOffscrnCapsNEWT.class.getName()});
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

