/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    static void setComponentSize(final Frame frame, final Component component, final int n, final int n2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(n, n2);
                    component.setMinimumSize(dimension);
                    component.setPreferredSize(dimension);
                    component.setSize(dimension);
                    frame.pack();
                    frame.validate();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    void doTest(boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        if (!bl && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("onscreen layer n/a");
            return;
        }
        if (bl && !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = bl ? GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, (AbstractGraphicsDevice)abstractGraphicsDevice) : GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, (AbstractGraphicsDevice)abstractGraphicsDevice);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        Assert.assertNotNull((Object)newtCanvasAWT);
        Dimension dimension = new Dimension(200 * this.szStep, 150 * this.szStep);
        newtCanvasAWT.setShallUseOffscreenLayer(bl);
        newtCanvasAWT.setPreferredSize(dimension);
        newtCanvasAWT.setMinimumSize(dimension);
        newtCanvasAWT.setSize(dimension);
        final Frame frame = new Frame(this.getSimpleTestName("."));
        Assert.assertNotNull((Object)frame);
        frame.add((Component)newtCanvasAWT);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        System.out.println("Window: " + gLWindow.getClass().getName());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLWindow.getChosenGLCapabilities();
        System.out.println("Window Caps Pre_GL: " + gLCapabilitiesImmutable3);
        Assert.assertNotNull((Object)gLCapabilitiesImmutable3);
        Assert.assertTrue((gLCapabilitiesImmutable3.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getRedBits() > 5 ? 1 : 0) != 0);
        gLWindow.display();
        GLDrawable gLDrawable = gLWindow.getDelegatedDrawable();
        Assert.assertNotNull((Object)gLDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        System.out.println("Window Caps PostGL   : " + gLWindow.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(1): " + gLWindow.getClass().getName() + ", " + gLWindow.getNativeSurface().getClass().getName());
        gLDrawable = gLWindow.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(1): " + gLDrawable);
        Assert.assertNotNull((Object)gLDrawable);
        Assert.assertTrue((gLDrawable.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getRedBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getDepthBits() > 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLDrawable.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLDrawable.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLDrawable.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLDrawable.isBitmap());
        Object object = gLWindow.getContext();
        System.out.println("Chosen     GL CTX (2): " + object.getGLVersion());
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.isCreated());
        System.out.println("Chosen     GL Caps(2): " + gLWindow.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(2): " + gLWindow.getClass().getName() + ", " + gLWindow.getNativeSurface().getClass().getName());
        gLWindow.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.display();
        int[] nArray = gLWindow.getNativeSurface().convertToPixelUnits(new int[]{200 * this.szStep, 150 * this.szStep});
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        this.szStep = 1;
        TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.setComponentSize(frame, (Component)newtCanvasAWT, 200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLWindow.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        gLWindow.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        this.szStep = 4;
        TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.setComponentSize(frame, (Component)newtCanvasAWT, 200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLWindow.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue((String)("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight()), (boolean)GLTestUtil.waitForSize((GLDrawable)gLWindow, nArray[0], nArray[1], null));
        gLWindow.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLWindow.display();
        Thread.sleep(50L);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)newtCanvasAWT);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLWindow.destroy();
        System.out.println("Fin: " + newtCanvasAWT);
        System.out.println("Fin: " + gLWindow);
    }

    @Test
    public void testGL2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest(false, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        this.doTest(false, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(false, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(false, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenLayerAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest(true, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setFBO(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setStencilBits(1);
        this.doTest(true, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setFBO(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(true, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setFBO(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(true, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbuffer() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setOnscreen(true);
        this.doTest(true, (GLCapabilitiesImmutable)gLCapabilities, (GLEventListener)new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableNewtCanvasAWTOnOffscrnCapsAWT.class.getName()});
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

