/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDebugListener;
import com.jogamp.opengl.GLDebugMessage;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLDebug01NEWT
extends UITestCase {
    static String dbgTstMsg0 = "Hello World";
    static int dbgTstId0 = 42;

    static GLProfile getGLProfile(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return GLProfile.get((String)string);
    }

    GLWindow createWindow(GLProfile gLProfile, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setContextCreationFlags(bl ? 32 : 0);
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        Assert.assertNotNull((Object)gLWindow.getContext());
        Assert.assertNotNull((Object)gLWindow.getContext().isCreated());
        return gLWindow;
    }

    void destroyWindow(GLWindow gLWindow) {
        gLWindow.destroy();
    }

    void testX1GLDebugEnableDisable(GLProfile gLProfile, boolean bl, final String string, final int n) throws InterruptedException {
        GLWindow gLWindow = this.createWindow(gLProfile, bl);
        GLContext gLContext = gLWindow.getContext();
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(string, n);
        if (bl) {
            gLContext.addGLDebugListener((GLDebugListener)myGLDebugListener);
        }
        String string2 = gLContext.getGLDebugMessageExtension();
        System.err.println("glDebug extension: " + string2);
        System.err.println("glDebug enabled: " + gLContext.isGLDebugMessageEnabled());
        System.err.println("glDebug sync: " + gLContext.isGLDebugSynchronous());
        System.err.println("context version: " + gLContext.getGLVersion());
        Assert.assertEquals((Object)(null == string2 ? false : bl), (Object)gLContext.isGLDebugMessageEnabled());
        if (gLContext.isGLDebugMessageEnabled() && null != string && 0 <= n) {
            gLWindow.invoke(true, new GLRunnable(){

                public boolean run(GLAutoDrawable gLAutoDrawable) {
                    gLAutoDrawable.getContext().glDebugMessageInsert(33354, 33361, n, 37191, string);
                    return true;
                }
            });
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(gLWindow);
    }

    @Test
    public void test01GL2GL3DebugDisabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, false, null, -1);
    }

    @Test
    public void test02GL2GL3DebugEnabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, true, dbgTstMsg0, dbgTstId0);
    }

    @Test
    public void test11GLES2DebugDisabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, false, null, -1);
    }

    @Test
    public void test12GLES2DebugEnabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, true, dbgTstMsg0, dbgTstId0);
    }

    void testX3GLDebugError(GLProfile gLProfile) throws InterruptedException {
        GLWindow gLWindow = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(33350, 33356, 37190);
        gLWindow.getContext().addGLDebugListener((GLDebugListener)myGLDebugListener);
        gLWindow.invoke(true, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                gLAutoDrawable.getGL().glBindFramebuffer(-1, -1);
                return true;
            }
        });
        if (gLWindow.getContext().isGLDebugMessageEnabled()) {
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(gLWindow);
    }

    @Test
    public void test03GL2GL3DebugError() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX3GLDebugError(gLProfile);
    }

    @Test
    public void test13GLES2DebugError() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug01NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX3GLDebugError(gLProfile);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLDebug01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    public static class MyGLDebugListener
    implements GLDebugListener {
        int recSource;
        int recType;
        int recSeverity;
        String recMsg;
        int recId;
        boolean received = false;

        public MyGLDebugListener(int n, int n2, int n3) {
            this.recSource = n;
            this.recType = n2;
            this.recSeverity = n3;
            this.recMsg = null;
            this.recId = -1;
        }

        public MyGLDebugListener(String string, int n) {
            this.recSource = -1;
            this.recType = -1;
            this.recSeverity = -1;
            this.recMsg = string;
            this.recId = n;
        }

        public boolean received() {
            return this.received;
        }

        public void messageSent(GLDebugMessage gLDebugMessage) {
            System.err.println("XXX: " + gLDebugMessage);
            if (null != this.recMsg && this.recMsg.equals(gLDebugMessage.getDbgMsg()) && this.recId == gLDebugMessage.getDbgId()) {
                this.received = true;
            } else if (0 <= this.recSource && this.recSource == gLDebugMessage.getDbgSource() && this.recType == gLDebugMessage.getDbgType() && this.recSeverity == gLDebugMessage.getDbgSeverity()) {
                this.received = true;
            }
        }
    }
}

