/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.acore.GLReadBuffer00Base;
import com.jogamp.opengl.test.junit.jogl.acore.GLReadBuffer00BaseAWT;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLReadBuffer01GLJPanelAWT
extends GLReadBuffer00BaseAWT {
    static GLCapabilitiesImmutable caps = null;
    static boolean doSnapshot = true;
    static boolean keyFrame = false;

    @BeforeClass
    public static void initClass() {
        GLProfile.initSingleton();
    }

    @Override
    public void test(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final boolean bl, final boolean bl2) {
        AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(gLCapabilitiesImmutable.getGLProfile(), false);
        final JFrame jFrame = new JFrame();
        Dimension dimension = new Dimension(320, 240);
        final GLJPanel gLJPanel = this.createGLJPanel(bl2, bl, gLCapabilitiesImmutable, dimension);
        final GLReadBuffer00Base.TextRendererGLEL textRendererGLEL = new GLReadBuffer00Base.TextRendererGLEL(gLCapabilitiesImmutable.getGLProfile());
        final GLReadBuffer00BaseAWT.SnapshotGLELAWT snapshotGLELAWT = doSnapshot ? new GLReadBuffer00BaseAWT.SnapshotGLELAWT(textRendererGLEL, aWTGLReadBufferUtil, bl2) : null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setLocation(64, 64);
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    jPanel.setDoubleBuffered(bl);
                    jFrame.getContentPane().add(jPanel);
                    gLJPanel.addGLEventListener(new GLEventListener(){

                        public void init(GLAutoDrawable gLAutoDrawable) {
                            GL gL = gLAutoDrawable.getGL();
                            System.err.println(VersionUtil.getPlatformInfo());
                            System.err.println("GLEventListener init on " + Thread.currentThread());
                            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
                            System.err.println("INIT GL IS: " + gL.getClass().getName());
                            System.err.println(JoglVersion.getGLStrings((GL)gL, null, (boolean)false).toString());
                        }

                        public void dispose(GLAutoDrawable gLAutoDrawable) {
                        }

                        public void display(GLAutoDrawable gLAutoDrawable) {
                        }

                        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                        }
                    });
                    Object object = new GearsES2(1);
                    ((GearsES2)object).setFlipVerticalInGLOrientation(bl2);
                    ((GearsES2)object).setVerbose(false);
                    gLJPanel.addGLEventListener((GLEventListener)object);
                    object = new MultisampleDemoES2(gLCapabilitiesImmutable.getSampleBuffers());
                    ((MultisampleDemoES2)object).setClearBuffers(false);
                    gLJPanel.addGLEventListener((GLEventListener)object);
                    textRendererGLEL.setFlipVerticalInGLOrientation(bl2);
                    gLJPanel.addGLEventListener((GLEventListener)textRendererGLEL);
                    if (doSnapshot) {
                        gLJPanel.addGLEventListener((GLEventListener)snapshotGLELAWT);
                    }
                    jPanel.add((Component)gLJPanel);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        if (keyFrame) {
            TestGLReadBuffer01GLJPanelAWT.waitForKey((String)("Post init: Frame# " + textRendererGLEL.frameNo));
        }
        gLJPanel.display();
        final Dimension dimension2 = jFrame.getSize();
        final Dimension dimension3 = new Dimension(dimension2.width + 100, dimension2.height + 100);
        final Dimension dimension4 = new Dimension(dimension2.width - 100, dimension2.height - 100);
        try {
            for (int i = 0; i < 3; ++i) {
                String string = "Frame# " + textRendererGLEL.frameNo + ", user #" + (i + 1);
                System.err.println(string);
                if (keyFrame) {
                    TestGLReadBuffer01GLJPanelAWT.waitForKey((String)string);
                }
                textRendererGLEL.userCounter = i + 1;
                gLJPanel.display();
            }
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension3);
                    jFrame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension4);
                    jFrame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension2);
                    jFrame.validate();
                }
            });
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (doSnapshot) {
                gLJPanel.disposeGLEventListener((GLEventListener)snapshotGLELAWT, true);
            }
            Animator animator = new Animator((GLAutoDrawable)gLJPanel);
            animator.start();
            try {
                Thread.sleep(2L * duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            animator.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private GLJPanel createGLJPanel(boolean bl, boolean bl2, GLCapabilitiesImmutable gLCapabilitiesImmutable, Dimension dimension) {
        GLJPanel gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
        gLJPanel.setSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setDoubleBuffered(bl2);
        gLJPanel.setSkipGLOrientationVerticalFlip(bl);
        return gLJPanel;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-keyFrame")) {
                keyFrame = true;
                continue;
            }
            if (!stringArray[i].equals("-noSnapshot")) continue;
            doSnapshot = false;
        }
        JUnitCore.main((String[])new String[]{TestGLReadBuffer01GLJPanelAWT.class.getName()});
    }
}

