/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.VersionNumberString;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLVersionNumber;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLVersionParsing00NEWT
extends UITestCase {
    public static final String[] glVersionStrings00 = new String[]{"GL_VERSION_2_1 DummyTool 1.2.3", "2.1 Mesa 7.0.3-rc2", "4.2.12171 Compatibility Profile Context 9.01.8", "4.2.12198 Compatibility Profile Context 12.102.3.0", "2.1 Mesa 7.0.3-rc2 post odd", "4.2.12171 Compatibility Profile Context 9.01.8 post odd", "4.2.12198 Compatibility Profile Context 12.102.3.0 post odd", "OpenGL ES 2.0 Mesa 9.1.1", "OpenGL ES 2.0 14.10.1", "OpenGL ES GLSL ES 2.0 14.10.1", "OpenGL ES 2.0 3Com L3 11.33.44"};
    public static final String[] glVersionStrings01 = new String[]{"GL_VERSION_2_1 Dummy Tool 1.2", "2.1 Mesa 7.12", "2.1 Mesa 7.12-devel", "2.1 Mesa 7.12-devel (git-d6c318e)", "2.1 Mesa 7.12-devel la1 la2 li3", "4.3.0 NVIDIA 310.32", "OpenGL ES 2.0 Mesa 9.1", "OpenGL ES 2.0 14.10", "OpenGL ES GLSL ES 2.0 14.10", "OpenGL ES 2.0 3Com L3 11.33"};
    public static final String[] glVersionStrings02 = new String[]{"GL_VERSION_2_1", "OpenGL ES 2.0", "OpenGL ES GLSL ES 2.0", "OpenGL 2.1 LaLa", "4.2.11762 Compatibility Profile Context"};
    public static final VersionNumberString[] glVersionNumbers = new VersionNumberString[]{new VersionNumberString(2, 1, 0, glVersionStrings00[0]), new VersionNumberString(2, 1, 0, glVersionStrings00[1]), new VersionNumberString(4, 2, 0, glVersionStrings00[2]), new VersionNumberString(4, 2, 0, glVersionStrings00[3]), new VersionNumberString(2, 1, 0, glVersionStrings00[4]), new VersionNumberString(4, 2, 0, glVersionStrings00[5]), new VersionNumberString(4, 2, 0, glVersionStrings00[6]), new VersionNumberString(2, 0, 0, glVersionStrings00[7]), new VersionNumberString(2, 0, 0, glVersionStrings00[8]), new VersionNumberString(2, 0, 0, glVersionStrings00[9]), new VersionNumberString(2, 0, 0, glVersionStrings00[10]), new VersionNumberString(2, 1, 0, glVersionStrings01[0]), new VersionNumberString(2, 1, 0, glVersionStrings01[1]), new VersionNumberString(2, 1, 0, glVersionStrings01[2]), new VersionNumberString(2, 1, 0, glVersionStrings01[3]), new VersionNumberString(2, 1, 0, glVersionStrings01[4]), new VersionNumberString(4, 3, 0, glVersionStrings01[5]), new VersionNumberString(2, 0, 0, glVersionStrings01[6]), new VersionNumberString(2, 0, 0, glVersionStrings01[7]), new VersionNumberString(2, 0, 0, glVersionStrings01[8]), new VersionNumberString(2, 0, 0, glVersionStrings01[9]), new VersionNumberString(2, 1, 0, glVersionStrings02[0]), new VersionNumberString(2, 0, 0, glVersionStrings02[1]), new VersionNumberString(2, 0, 0, glVersionStrings02[2]), new VersionNumberString(2, 1, 0, glVersionStrings02[3]), new VersionNumberString(4, 2, 0, glVersionStrings02[4])};
    public static final VersionNumberString[] glVendorVersionNumbersWithSub = new VersionNumberString[]{new VersionNumberString(1, 2, 3, glVersionStrings00[0]), new VersionNumberString(7, 0, 3, glVersionStrings00[1]), new VersionNumberString(9, 1, 8, glVersionStrings00[2]), new VersionNumberString(12, 102, 3, glVersionStrings00[3]), new VersionNumberString(7, 0, 3, glVersionStrings00[4]), new VersionNumberString(9, 1, 8, glVersionStrings00[5]), new VersionNumberString(12, 102, 3, glVersionStrings00[6]), new VersionNumberString(9, 1, 1, glVersionStrings00[7]), new VersionNumberString(14, 10, 1, glVersionStrings00[8]), new VersionNumberString(14, 10, 1, glVersionStrings00[9]), new VersionNumberString(11, 33, 44, glVersionStrings00[10])};
    public static final VersionNumberString[] glVendorVersionNumbersNoSub = new VersionNumberString[]{new VersionNumberString(1, 2, 0, glVersionStrings01[0]), new VersionNumberString(7, 12, 0, glVersionStrings01[1]), new VersionNumberString(7, 12, 0, glVersionStrings01[2]), new VersionNumberString(7, 12, 0, glVersionStrings01[3]), new VersionNumberString(7, 12, 0, glVersionStrings01[4]), new VersionNumberString(310, 32, 0, glVersionStrings01[5]), new VersionNumberString(9, 1, 0, glVersionStrings01[6]), new VersionNumberString(14, 10, 0, glVersionStrings01[7]), new VersionNumberString(14, 10, 0, glVersionStrings01[8]), new VersionNumberString(11, 33, 0, glVersionStrings01[9])};
    public static final VersionNumberString[] glVendorVersionNumbersNone = new VersionNumberString[]{new VersionNumberString(0, 0, 0, glVersionStrings02[0]), new VersionNumberString(0, 0, 0, glVersionStrings02[1]), new VersionNumberString(0, 0, 0, glVersionStrings02[2]), new VersionNumberString(0, 0, 0, glVersionStrings02[3]), new VersionNumberString(0, 0, 0, glVersionStrings02[4])};

    @Test
    public void test01GLVersion() throws InterruptedException {
        for (int i = 0; i < glVersionNumbers.length; ++i) {
            VersionNumberString versionNumberString = glVersionNumbers[i];
            GLVersionNumber gLVersionNumber = GLVersionNumber.create((String)versionNumberString.getVersionString());
            System.err.println("Test[" + i + "]: " + versionNumberString + " -> " + gLVersionNumber + ", valid " + gLVersionNumber.isValid() + ", define [" + gLVersionNumber.hasMajor() + ":" + gLVersionNumber.hasMinor() + ":" + gLVersionNumber.hasSub() + "]");
            Assert.assertTrue((boolean)gLVersionNumber.hasMajor());
            Assert.assertTrue((boolean)gLVersionNumber.hasMinor());
            Assert.assertTrue((!gLVersionNumber.hasSub() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)gLVersionNumber.isValid());
            Assert.assertEquals((Object)versionNumberString, (Object)gLVersionNumber);
        }
        GLVersionNumber gLVersionNumber = GLVersionNumber.create((String)"GL_VERSION_2");
        System.err.println("Test-X1: " + gLVersionNumber + ", valid " + gLVersionNumber.isValid() + ", define [" + gLVersionNumber.hasMajor() + ":" + gLVersionNumber.hasMinor() + ":" + gLVersionNumber.hasSub() + "]");
        Assert.assertTrue((boolean)gLVersionNumber.hasMajor());
        Assert.assertTrue((!gLVersionNumber.hasMinor() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.hasSub() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.isValid() ? 1 : 0) != 0);
        gLVersionNumber = GLVersionNumber.create((String)"GL2 Buggy L3");
        System.err.println("Test-X2: " + gLVersionNumber + ", valid " + gLVersionNumber.isValid() + ", define [" + gLVersionNumber.hasMajor() + ":" + gLVersionNumber.hasMinor() + ":" + gLVersionNumber.hasSub() + "]");
        Assert.assertTrue((boolean)gLVersionNumber.hasMajor());
        Assert.assertTrue((!gLVersionNumber.hasMinor() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.hasSub() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.isValid() ? 1 : 0) != 0);
        gLVersionNumber = GLVersionNumber.create((String)"GL Nope");
        System.err.println("Test-X3: " + gLVersionNumber + ", valid " + gLVersionNumber.isValid() + ", define [" + gLVersionNumber.hasMajor() + ":" + gLVersionNumber.hasMinor() + ":" + gLVersionNumber.hasSub() + "]");
        Assert.assertTrue((!gLVersionNumber.hasMajor() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.hasMinor() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.hasSub() ? 1 : 0) != 0);
        Assert.assertTrue((!gLVersionNumber.isValid() ? 1 : 0) != 0);
    }

    private void testGLVendorVersionImpl(VersionNumberString[] versionNumberStringArray, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        for (int i = 0; i < versionNumberStringArray.length; ++i) {
            VersionNumberString versionNumberString = versionNumberStringArray[i];
            VersionNumberString versionNumberString2 = GLVersionNumber.createVendorVersion((String)versionNumberString.getVersionString());
            System.err.println("Test[" + bl + ":" + bl2 + ":" + bl3 + "][" + i + "]: " + versionNumberString + " -> " + versionNumberString2 + ", define [" + versionNumberString2.hasMajor() + ":" + versionNumberString2.hasMinor() + ":" + versionNumberString2.hasSub() + "]");
            Assert.assertEquals((Object)bl, (Object)versionNumberString2.hasMajor());
            Assert.assertEquals((Object)bl2, (Object)versionNumberString2.hasMinor());
            Assert.assertEquals((Object)bl3, (Object)versionNumberString2.hasSub());
            Assert.assertEquals((Object)versionNumberString, (Object)versionNumberString2);
        }
    }

    @Test
    public void test02GLVendorVersion() throws InterruptedException {
        this.testGLVendorVersionImpl(glVendorVersionNumbersWithSub, true, true, true);
        this.testGLVendorVersionImpl(glVendorVersionNumbersNoSub, true, true, false);
        this.testGLVendorVersionImpl(glVendorVersionNumbersNone, false, false, false);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLVersionParsing00NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

