/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMapBufferRead02NEWT
extends UITestCase {
    static final boolean DEBUG = false;
    static final float[] vertexData = new float[]{-0.3f, -0.2f, -0.1f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f};

    @Test
    public void testWriteRead01aMap() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead02NEWT.createVerticesFB(false), false);
    }

    @Test
    public void testWriteRead01bMap() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead02NEWT.createVerticesFB(true), false);
    }

    @Test
    public void testWriteRead02aMapRange() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL3") && GLProfile.isAvailable((String)"GLES3")) {
            System.err.println("Test requires GL3 or GLES3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead02NEWT.createVerticesFB(false), true);
    }

    @Test
    public void testWriteRead02bMapRange() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL3") && GLProfile.isAvailable((String)"GLES3")) {
            System.err.println("Test requires GL3 or GLES3 profile.");
            return;
        }
        this.testWriteRead01(TestMapBufferRead02NEWT.createVerticesFB(true), true);
    }

    static FloatBuffer createVerticesFB(boolean bl) {
        FloatBuffer floatBuffer;
        if (bl) {
            floatBuffer = Buffers.newDirectFloatBuffer((float[])vertexData);
        } else {
            floatBuffer = FloatBuffer.allocate(vertexData.length);
            for (int i = 0; i < vertexData.length; ++i) {
                floatBuffer.put(vertexData[i]);
            }
            floatBuffer.rewind();
        }
        return floatBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteRead01(FloatBuffer floatBuffer, boolean bl) throws InterruptedException {
        Assert.assertEquals((long)0L, (long)floatBuffer.position());
        Assert.assertEquals((long)vertexData.length, (long)floatBuffer.limit());
        Assert.assertEquals((long)vertexData.length, (long)floatBuffer.capacity());
        Assert.assertEquals((long)vertexData.length, (long)floatBuffer.remaining());
        Assert.assertEquals((float)-0.3f, (float)floatBuffer.get(0), (float)0.05f);
        Assert.assertEquals((float)0.6f, (float)floatBuffer.get(8), (float)0.05f);
        GLProfile gLProfile = GLProfile.getMaxProgrammable((boolean)true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, 800, 600, true);
        try {
            ByteBuffer byteBuffer;
            int n;
            int n2;
            int n3;
            GL gL = windowContext.context.getGL();
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, (long)(4 * floatBuffer.remaining()), (Buffer)floatBuffer, 35045);
            int n4 = gL.getBoundBuffer(34962);
            GLBufferStorage gLBufferStorage = gL.getBufferStorage(n4);
            System.err.println("gpu-01 GL_ARRAY_BUFFER -> bufferName " + n4 + " -> " + gLBufferStorage);
            Assert.assertEquals((String)"Buffer storage's bytes-buffer not null before map", null, (Object)gLBufferStorage.getMappedBuffer());
            if (bl) {
                n3 = 3;
                n2 = 4 * n3;
                n = 4 * floatBuffer.remaining() - n2;
                byteBuffer = gL.glMapBufferRange(34962, (long)n2, (long)n, 1);
            } else {
                n3 = 0;
                n2 = 0;
                n = 4 * floatBuffer.remaining();
                byteBuffer = gL.glMapBuffer(34962, 35000);
            }
            System.err.println("gpu-02 mapped GL_ARRAY_BUFFER, floatOffset " + n3 + ", byteOffset " + n2 + ", mapByteLength " + n + " -> " + byteBuffer);
            System.err.println("gpu-03 GL_ARRAY_BUFFER -> bufferName " + n4 + " -> " + gLBufferStorage);
            Assert.assertNotNull((Object)byteBuffer);
            Assert.assertEquals((String)"BufferStorage size less byteOffset not equals buffer storage size", (long)(gLBufferStorage.getSize() - (long)n2), (long)byteBuffer.capacity());
            Assert.assertEquals((String)"BufferStorage's bytes-buffer not equal with mapped bytes-buffer", (Object)gLBufferStorage.getMappedBuffer(), (Object)byteBuffer);
            Assert.assertEquals((String)"Buffer storage size not equals mapByteLength", (long)n, (long)byteBuffer.remaining());
            for (int i = 0; i < byteBuffer.remaining(); i += 4) {
                Assert.assertEquals((float)floatBuffer.get((n2 + i) / 4), (float)byteBuffer.getFloat(i), (float)1.0E-4f);
            }
            gL.glUnmapBuffer(34962);
            Assert.assertEquals((String)"Buffer storage's bytes-buffer not null after unmap", null, (Object)gLBufferStorage.getMappedBuffer());
        }
        finally {
            NEWTGLContext.destroyWindow(windowContext);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestMapBufferRead02NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

