/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextListNEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLOffscreenAutoDrawable sharedDrawable;
    Gears sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextListNEWT.setTestSupported((boolean)false);
        }
    }

    private void initShared() {
        this.sharedDrawable = GLDrawableFactory.getFactory((GLProfile)glp).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)caps, null, width, height);
        Assert.assertNotNull((Object)this.sharedDrawable);
        this.sharedGears = new Gears();
        Assert.assertNotNull((Object)this.sharedGears);
        this.sharedDrawable.addGLEventListener((GLEventListener)this.sharedGears);
        this.sharedDrawable.display();
    }

    private void releaseShared() {
        Assert.assertNotNull((Object)this.sharedDrawable);
        this.sharedDrawable.destroy();
        this.sharedDrawable = null;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable((GLAutoDrawable)this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        Gears gears = new Gears(bl2 ? 1 : 0);
        if (bl) {
            gears.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener((GLEventListener)gears);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        gLWindow.setPosition(n, n2);
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        this.initShared();
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), false, true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextListNEWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

