/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES1NEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLAutoDrawable sharedDrawable;
    GearsES1 sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2ES1")) {
            glp = GLProfile.get((String)"GL2ES1");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES1NEWT.setTestSupported((boolean)false);
        }
    }

    private void initShared() throws InterruptedException {
        GLDrawable gLDrawable = GLDrawableFactory.getFactory((GLProfile)glp).createDummyDrawable(null, true, (GLCapabilitiesImmutable)caps, null);
        gLDrawable.setRealized(true);
        this.sharedDrawable = new GLAutoDrawableDelegate(gLDrawable, null, null, true, null){};
        Assert.assertNotNull((Object)this.sharedDrawable);
        GLAutoDrawable gLAutoDrawable = this.sharedDrawable;
        Assert.assertTrue((boolean)GLTestUtil.waitForRealized(gLAutoDrawable, true, null));
        this.sharedGears = new GearsES1();
        Assert.assertNotNull((Object)this.sharedGears);
        this.sharedDrawable.addGLEventListener((GLEventListener)this.sharedGears);
        this.sharedDrawable.display();
        GLContext gLContext = this.sharedDrawable.getContext();
        Assert.assertTrue((String)"Master ctx not created", (boolean)GLTestUtil.waitForContextCreated(this.sharedDrawable, true, null));
        Assert.assertTrue((String)"Master Ctx is shared before shared creation", (!gLContext.isShared() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Master Gears is shared", (!this.sharedGears.usesSharedGears() ? 1 : 0) != 0);
    }

    private void releaseShared() {
        Assert.assertNotNull((Object)this.sharedDrawable);
        this.sharedDrawable.destroy();
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        GearsES1 gearsES1 = new GearsES1(bl2 ? 1 : 0);
        if (bl) {
            gearsES1.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener((GLEventListener)gearsES1);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow, true, null));
        MiscUtils.dumpSharedGLContext("Master Context", this.sharedDrawable.getContext());
        MiscUtils.dumpSharedGLContext("New    Context", gLWindow.getContext());
        if (bl) {
            Assert.assertEquals((String)"Master Context not shared as expected", (Object)true, (Object)this.sharedDrawable.getContext().isShared());
            Assert.assertEquals((String)"Master Context is different", (Object)this.sharedDrawable.getContext(), (Object)gLWindow.getContext().getSharedMaster());
        }
        Assert.assertEquals((String)"New    Context not shared as expected", (Object)bl, (Object)gLWindow.getContext().isShared());
        Assert.assertEquals((String)"Gears is not shared as expected", (Object)bl, (Object)gearsES1.usesSharedGears());
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        this.initShared();
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), false, true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES1NEWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

