/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT2
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;
    static boolean mainRun;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2ES2")) {
            glp = GLProfile.get((String)"GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT2.setTestSupported((boolean)false);
        }
    }

    protected GLWindow createGLWindow(int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared true");
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        return gLWindow;
    }

    @Test
    public void test01SyncedOneAnimatorCleanDtorOrder() throws InterruptedException {
        this.syncedOneAnimator(true);
    }

    @Test
    public void test02SyncedOneAnimatorDirtyDtorOrder() throws InterruptedException {
        this.syncedOneAnimator(false);
    }

    public void syncedOneAnimator(boolean bl) throws InterruptedException {
        Animator animator = new Animator(0);
        animator.start();
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setSyncObjects(gearsES2);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLWindow);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.createGLWindow(gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22);
        gLWindow2.setSharedAutoDrawable((GLAutoDrawable)gLWindow);
        animator.add((GLAutoDrawable)gLWindow2);
        gLWindow2.setVisible(true);
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLWindow gLWindow3 = this.createGLWindow(gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), gearsES23);
        gLWindow3.setSharedAutoDrawable((GLAutoDrawable)gLWindow);
        animator.add((GLAutoDrawable)gLWindow3);
        gLWindow3.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow3, false, null));
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow, true, null));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow2, true, null));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow3, true, null));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLWindow.getContext();
        GLContext gLContext2 = gLWindow2.getContext();
        GLContext gLContext3 = gLWindow3.getContext();
        List list = gLContext.getCreatedShares();
        List list2 = gLContext2.getCreatedShares();
        List list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertEquals((String)"Ctx1 Master Context is different", (Object)gLContext, (Object)gLContext.getSharedMaster());
        Assert.assertEquals((String)"Ctx2 Master Context is different", (Object)gLContext, (Object)gLContext2.getSharedMaster());
        Assert.assertEquals((String)"Ctx3 Master Context is different", (Object)gLContext, (Object)gLContext3.getSharedMaster());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
            gLWindow3.destroy();
            gLWindow2.destroy();
            gLWindow.destroy();
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. May trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
            gLWindow.destroy();
            gLWindow2.destroy();
            gLWindow3.destroy();
        }
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, false, null));
    }

    @Test
    public void test11AsyncEachAnimatorCleanDtorOrder() throws InterruptedException {
        this.asyncEachAnimator(true);
    }

    @Test
    public void test12AsyncEachAnimatorDirtyDtorOrder() throws InterruptedException {
        this.asyncEachAnimator(false);
    }

    public void asyncEachAnimator(boolean bl) throws InterruptedException {
        Animator animator = new Animator(0);
        GearsES2 gearsES2 = new GearsES2(0);
        gearsES2.setSyncObjects(gearsES2);
        GLWindow gLWindow = this.createGLWindow(0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        Animator animator2 = new Animator(0);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLWindow gLWindow2 = this.createGLWindow(gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22);
        gLWindow2.setSharedAutoDrawable((GLAutoDrawable)gLWindow);
        animator2.add((GLAutoDrawable)gLWindow2);
        animator2.start();
        gLWindow2.setVisible(true);
        Animator animator3 = new Animator(0);
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLWindow gLWindow3 = this.createGLWindow(gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), gearsES23);
        gLWindow3.setSharedAutoDrawable((GLAutoDrawable)gLWindow);
        animator3.add((GLAutoDrawable)gLWindow3);
        animator3.start();
        gLWindow3.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow3, false, null));
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow, true, null));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow2, true, null));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLWindow3, true, null));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLWindow.getContext();
        GLContext gLContext2 = gLWindow2.getContext();
        GLContext gLContext3 = gLWindow3.getContext();
        List list = gLContext.getCreatedShares();
        List list2 = gLContext2.getCreatedShares();
        List list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertEquals((String)"Ctx1 Master Context is different", (Object)gLContext, (Object)gLContext.getSharedMaster());
        Assert.assertEquals((String)"Ctx2 Master Context is different", (Object)gLContext, (Object)gLContext2.getSharedMaster());
        Assert.assertEquals((String)"Ctx3 Master Context is different", (Object)gLContext, (Object)gLContext3.getSharedMaster());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        animator2.stop();
        Assert.assertEquals((Object)false, (Object)animator2.isAnimating());
        animator3.stop();
        Assert.assertEquals((Object)false, (Object)animator3.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
            gLWindow3.destroy();
            gLWindow2.destroy();
            gLWindow.destroy();
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. May trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
            gLWindow.destroy();
            gLWindow2.destroy();
            gLWindow3.destroy();
        }
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow2, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForVisible((Window)gLWindow3, false, null));
        Assert.assertTrue((boolean)NewtTestUtil.waitForRealized((Window)gLWindow3, false, null));
    }

    public static void main(String[] stringArray) {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2NEWT2.class.getName()});
    }

    static {
        duration = 1000L;
        mainRun = false;
    }
}

