/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShutdownCompleteAWT
extends UITestCase {
    static long duration = 300L;
    static boolean initOnly = false;
    static boolean waitForKey = false;

    protected void runTestGL() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()));
        Assert.assertNotNull((Object)gLCanvas);
        frame.add((Component)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(256, 256);
                frame.setVisible(true);
            }
        });
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isVisible());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isDisplayable());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)true, (Object)gLCanvas.isRealized());
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove((Component)gLCanvas);
                frame.dispose();
            }
        });
    }

    @AfterClass
    public static void afterAll() {
        if (waitForKey) {
            JunitTracer.waitForKey((String)"Exit");
        }
    }

    protected void oneLife(boolean bl) throws InterruptedException, InvocationTargetException {
        long l = Platform.currentTimeMillis();
        GLProfile.initSingleton();
        long l2 = Platform.currentTimeMillis();
        if (!initOnly) {
            this.runTestGL();
        }
        long l3 = Platform.currentTimeMillis();
        if (bl) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, (boolean)false).toString());
        }
        long l4 = Platform.currentTimeMillis();
        GLProfile.shutdown();
        long l5 = Platform.currentTimeMillis();
        System.err.println("Total:                          " + (l5 - l) + "ms");
        System.err.println("  GLProfile.initSingleton():    " + (l2 - l) + "ms");
        System.err.println("  Demo Code:                    " + (l3 - l2) + "ms");
        System.err.println("  GLInfo:                       " + (l4 - l3) + "ms");
        System.err.println("  GLProfile.shutdown():         " + (l5 - l4) + "ms");
    }

    @Test
    public void test01OneLife() throws InterruptedException, InvocationTargetException {
        this.oneLife(false);
    }

    @Test
    public void test02AnotherLifeWithGLInfo() throws InterruptedException, InvocationTargetException {
        this.oneLife(true);
    }

    @Test
    public void test03AnotherLife() throws InterruptedException, InvocationTargetException {
        this.oneLife(true);
    }

    @Test
    public void test03TwoLifes() throws InterruptedException, InvocationTargetException {
        this.oneLife(false);
        this.oneLife(false);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-initOnly")) continue;
            initOnly = true;
        }
        if (waitForKey) {
            JunitTracer.waitForKey((String)"Start");
        }
        String string = TestShutdownCompleteAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

