/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.junit.util.VersionSemanticsUtil;
import com.jogamp.opengl.JoglVersion;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestVersionSemanticsNOUI
extends SingletonJunitCase {
    static final String jarFile = "jogl-all.jar";
    static final JogampVersion curVersion = JoglVersion.getInstance();
    static final VersionNumberString curVersionNumber = new VersionNumberString(curVersion.getImplementationVersion());
    static final String excludesDefault = "jogamp";
    static final String excludesStereoPackageAndAppletUtils = excludesDefault + ";com.jogamp.opengl.util.stereo;com.jogamp.newt.util.applet";

    public void testVersionV212V213() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.2", "2.1.3", excludesDefault);
    }

    public void testVersionV213V214() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.3", "2.1.4", excludesDefault);
    }

    public void testVersionV214V215() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.4", "2.1.5", excludesDefault);
    }

    public void testVersionV215V220() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.5", "2.2.0", excludesDefault);
    }

    @Test
    public void testVersionV220V221() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.BACKWARD_COMPATIBLE_SOURCE, "2.2.0", "2.2.1", excludesDefault);
    }

    @Test
    public void testVersionV221V230() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.2.1", "2.3.0", excludesDefault);
    }

    void testVersions(VersionSemanticsUtil.CompatibilityType compatibilityType, String string, String string2, String string3) throws IllegalArgumentException, IOException, URISyntaxException {
        VersionNumberString versionNumberString = new VersionNumberString(string);
        File file = new File("lib/v" + string + "/" + jarFile);
        VersionNumberString versionNumberString2 = new VersionNumberString(string2);
        File file2 = new File("lib/v" + string2 + "/" + jarFile);
        VersionSemanticsUtil.testVersion2((VersionSemanticsUtil.CompatibilityType)compatibilityType, (File)file, (VersionNumberString)versionNumberString, (File)file2, (VersionNumberString)versionNumberString2, (String)string3, (boolean)true);
    }

    @Test
    public void testVersionV230V232() throws IllegalArgumentException, IOException, URISyntaxException {
        VersionSemanticsUtil.CompatibilityType compatibilityType = VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE;
        this.testVersions(compatibilityType, "2.3.0", "2.3.2", excludesStereoPackageAndAppletUtils);
    }

    @Test
    public void testVersionV232V24x() throws IllegalArgumentException, IOException, URISyntaxException {
        VersionSemanticsUtil.CompatibilityType compatibilityType = VersionSemanticsUtil.CompatibilityType.NON_BACKWARD_COMPATIBLE;
        VersionNumberString versionNumberString = new VersionNumberString("2.3.2");
        File file = new File("lib/v" + versionNumberString.getVersionString() + "/" + jarFile);
        ClassLoader classLoader = TestVersionSemanticsNOUI.class.getClassLoader();
        VersionSemanticsUtil.testVersion2((VersionSemanticsUtil.CompatibilityType)compatibilityType, (File)file, (VersionNumberString)versionNumberString, curVersion.getClass(), (ClassLoader)classLoader, (VersionNumberString)curVersionNumber, (String)excludesDefault, (boolean)true);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestVersionSemanticsNOUI.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

