/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.RedSquareES1;
import com.jogamp.opengl.test.junit.util.DumpGLInfo;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestX11DefaultDisplay
extends UITestCase {
    static long duration = 500L;
    static int width = 512;
    static int height = 512;
    static String x11DefaultDisplay = ":0.0";

    @BeforeClass
    public static void initClass() {
        System.setProperty("nativewindow.x11.display.default", x11DefaultDisplay);
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.setSize(width, height);
        RedSquareES1 redSquareES1 = new RedSquareES1();
        gLWindow.addGLEventListener((GLEventListener)redSquareES1);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setPostSNDetail(redSquareES1.getClass().getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)snapshotGLEventListener);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        animator.start();
        gLWindow.setVisible(true);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        animator.setUpdateFPSFrames(60, System.err);
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test00_DefaultDevice() {
        AbstractGraphicsDevice abstractGraphicsDevice = GLProfile.getDefaultDevice();
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + abstractGraphicsDevice);
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.addGLEventListener((GLEventListener)new DumpGLInfo());
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        gLWindow.display();
        gLWindow.destroy();
        if (".x11" == NativeWindowFactory.getNativeWindowType((boolean)true)) {
            Assert.assertEquals((String)"X11 Default device does not match", (Object)abstractGraphicsDevice.getConnection(), (Object)x11DefaultDisplay);
        }
    }

    @Test
    public void test01_GLDefaultRendering() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-x11DefaultDisplay")) continue;
            x11DefaultDisplay = stringArray[++i];
        }
        JUnitCore.main((String[])new String[]{TestX11DefaultDisplay.class.getName()});
    }
}

