/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.anim;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAnimatorGLJPanel01AWT
extends UITestCase {
    static final int width = 400;
    static final int height = 400;
    static long duration = 1500L;

    protected GLJPanel createGLJPanel(GLCapabilities gLCapabilities, Frame frame, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel);
        gLJPanel.addGLEventListener((GLEventListener)gearsES2);
        frame.add((Component)gLJPanel);
        frame.setLocation(n, n2);
        frame.setSize(400, 400);
        frame.setTitle("GLJPanel: " + n + "/" + n2);
        return gLJPanel;
    }

    static void pauseAnimator(Animator animator, boolean bl) {
        if (bl) {
            animator.pause();
            Assert.assertEquals((Object)true, (Object)animator.isStarted());
            Assert.assertEquals((Object)true, (Object)animator.isPaused());
            Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        } else {
            animator.resume();
            Assert.assertEquals((Object)true, (Object)animator.isStarted());
            Assert.assertEquals((Object)false, (Object)animator.isPaused());
            Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        }
    }

    static void stopAnimator(Animator animator) {
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
    }

    @Test
    public void test01SyncedOneAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        final Frame frame = new Frame();
        Animator animator = new Animator();
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)true, (Object)animator.isPaused());
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(gLCapabilities, frame, 0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLJPanel);
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        final Frame frame2 = new Frame();
        GearsES2 gearsES22 = new GearsES2(0);
        GLJPanel gLJPanel2 = this.createGLJPanel(gLCapabilities, frame2, frame.getX() + 400, frame.getY() + 0, gearsES22);
        animator.add((GLAutoDrawable)gLJPanel2);
        final Frame frame3 = new Frame();
        GearsES2 gearsES23 = new GearsES2(0);
        GLJPanel gLJPanel3 = this.createGLJPanel(gLCapabilities, frame3, frame.getX() + 0, frame.getY() + 400, gearsES23);
        animator.add((GLAutoDrawable)gLJPanel3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
                frame2.setVisible(true);
                frame3.setVisible(true);
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel, true, null));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel2, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel2, true, null));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel3, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel3, true, null));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.stopAnimator(animator);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.dispose();
                    frame2.dispose();
                    frame3.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel, false, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel2, false, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel3, false, null));
    }

    @Test
    public void test02AsyncEachAnimator() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLJPanel gLJPanel = this.createGLJPanel(gLCapabilities, frame, 0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLJPanel);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isStarted());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        final Frame frame2 = new Frame();
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        GLJPanel gLJPanel2 = this.createGLJPanel(gLCapabilities, frame2, frame.getX() + 400, frame.getY() + 0, gearsES22);
        animator2.add((GLAutoDrawable)gLJPanel2);
        animator2.start();
        Assert.assertEquals((Object)true, (Object)animator2.isStarted());
        Assert.assertEquals((Object)false, (Object)animator2.isPaused());
        Assert.assertEquals((Object)true, (Object)animator2.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
            }
        });
        final Frame frame3 = new Frame();
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        GLJPanel gLJPanel3 = this.createGLJPanel(gLCapabilities, frame3, frame.getX() + 0, frame.getY() + 400, gearsES23);
        animator3.add((GLAutoDrawable)gLJPanel3);
        animator3.start();
        Assert.assertEquals((Object)true, (Object)animator3.isStarted());
        Assert.assertEquals((Object)false, (Object)animator3.isPaused());
        Assert.assertEquals((Object)true, (Object)animator3.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame3.setVisible(true);
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel, true, null));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel2, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel2, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel2, true, null));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel3, true, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible((Component)gLJPanel3, true, null));
        Assert.assertTrue((boolean)GLTestUtil.waitForContextCreated((GLAutoDrawable)gLJPanel3, true, null));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, true);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator2, true);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator3, true);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator, false);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator2, false);
        TestAnimatorGLJPanel01AWT.pauseAnimator(animator3, false);
        try {
            Thread.sleep(duration / 3L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TestAnimatorGLJPanel01AWT.stopAnimator(animator);
        TestAnimatorGLJPanel01AWT.stopAnimator(animator2);
        TestAnimatorGLJPanel01AWT.stopAnimator(animator3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.dispose();
                    frame2.dispose();
                    frame3.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel, false, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel2, false, null));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLJPanel3, false, null));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestAnimatorGLJPanel01AWT.class.getName()});
    }
}

