/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.ect;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.AnimatorBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ExclusiveContextBase00
extends UITestCase {
    static boolean testExclusiveWithAWT = false;
    static final int durationParts = 9;
    static long duration = 2880L;
    static boolean showFPS = false;
    static int showFPSRate = 100;
    static final int demoWinSize = 128;
    static InsetsImmutable insets = null;
    static int num_x;
    static int num_y;
    static int swapInterval;

    @BeforeClass
    public static void initClass00() {
        Window window = NewtFactory.createWindow((CapabilitiesImmutable)new Capabilities());
        window.setSize(128, 128);
        window.setVisible(true);
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        insets = window.getInsets();
        int n = window.getScreen().getHeight();
        int n2 = window.getScreen().getWidth();
        int[] nArray = window.convertToPixelUnits(new int[]{128, 128});
        int[] nArray2 = window.convertToPixelUnits(new int[]{insets.getTotalWidth(), insets.getTotalHeight()});
        num_x = n2 / (nArray[0] + nArray2[0]) - 2;
        num_y = n / (nArray[1] + nArray2[1]) - 2;
        window.destroy();
    }

    @AfterClass
    public static void releaseClass00() {
    }

    protected abstract boolean isAWTTestCase();

    protected abstract Thread getAWTRenderThread();

    protected abstract AnimatorBase createAnimator();

    protected abstract GLAutoDrawable createGLAutoDrawable(String var1, int var2, int var3, int var4, int var5, GLCapabilitiesImmutable var6);

    protected abstract void setGLAutoDrawableVisible(GLAutoDrawable[] var1);

    protected abstract void destroyGLAutoDrawableVisible(GLAutoDrawable var1);

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws InterruptedException {
        int n2;
        boolean bl5 = this.isAWTTestCase();
        if (bl5 && bl) {
            if (testExclusiveWithAWT) {
                System.err.println("Warning: Testing AWT + Exclusive -> Not advised!");
            } else {
                System.err.println("Info: Skip test: AWT + Exclusive!");
                return;
            }
        }
        if (bl5 && bl && !testExclusiveWithAWT) {
            System.err.println("Skip test: AWT + Exclusive -> Not advised!");
            return;
        }
        Thread thread = this.getAWTRenderThread();
        AnimatorBase[] animatorBaseArray = new AnimatorBase[n];
        GLAutoDrawable[] gLAutoDrawableArray = new GLAutoDrawable[n];
        for (n2 = 0; n2 < n; ++n2) {
            animatorBaseArray[n2] = this.createAnimator();
            if (!bl5) {
                animatorBaseArray[n2].setModeBits(false, 1);
            }
            int n3 = n2 % num_x * (128 + insets.getTotalHeight()) + insets.getLeftWidth();
            int n4 = n2 / num_x % num_y * (128 + insets.getTotalHeight()) + insets.getTopHeight();
            gLAutoDrawableArray[n2] = this.createGLAutoDrawable("Win #" + n2, n3, n4, 128, 128, gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLAutoDrawableArray[n2]);
            GearsES2 gearsES2 = new GearsES2(swapInterval);
            gearsES2.setVerbose(false);
            gLAutoDrawableArray[n2].addGLEventListener((GLEventListener)gearsES2);
            if (bl2) {
                animatorBaseArray[n2].add(gLAutoDrawableArray[n2]);
                if (bl) {
                    if (bl5) {
                        Assert.assertEquals(null, (Object)animatorBaseArray[n2].setExclusiveContext(thread));
                    } else {
                        Assert.assertEquals((Object)false, (Object)animatorBaseArray[n2].setExclusiveContext(true));
                    }
                }
            }
            Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
            Assert.assertFalse((boolean)animatorBaseArray[n2].isStarted());
        }
        if (bl3) {
            this.setGLAutoDrawableVisible(gLAutoDrawableArray);
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertEquals((Object)true, (Object)gLAutoDrawableArray[n2].isRealized());
                animatorBaseArray[n2].setUpdateFPSFrames(showFPSRate, showFPS ? System.err : null);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            Assert.assertTrue((boolean)animatorBaseArray[n2].start());
            Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
            if (bl2) {
                Assert.assertTrue((boolean)animatorBaseArray[n2].isAnimating());
            } else {
                Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
                if (bl) {
                    if (bl5) {
                        Assert.assertEquals(null, (Object)animatorBaseArray[n2].setExclusiveContext(thread));
                    } else {
                        Assert.assertEquals((Object)false, (Object)animatorBaseArray[n2].setExclusiveContext(true));
                    }
                }
                animatorBaseArray[n2].add(gLAutoDrawableArray[n2]);
                Assert.assertTrue((boolean)animatorBaseArray[n2].isAnimating());
            }
            Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
            Thread thread2 = animatorBaseArray[n2].getExclusiveContextThread();
            if (bl) {
                if (bl5) {
                    Assert.assertEquals((Object)thread, (Object)thread2);
                } else {
                    Assert.assertEquals((Object)animatorBaseArray[n2].getThread(), (Object)thread2);
                }
            } else {
                Assert.assertEquals(null, (Object)thread2);
            }
            Assert.assertEquals((Object)thread2, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
        }
        if (!bl3) {
            this.setGLAutoDrawableVisible(gLAutoDrawableArray);
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertEquals((Object)true, (Object)gLAutoDrawableArray[n2].isRealized());
                animatorBaseArray[n2].setUpdateFPSFrames(showFPSRate, showFPS ? System.err : null);
            }
        }
        Thread.sleep(duration / 9L);
        if (!bl4) {
            if (bl) {
                int n5;
                Thread[] threadArray = new Thread[n];
                for (n5 = 0; n5 < n; ++n5) {
                    threadArray[n5] = animatorBaseArray[n5].getExclusiveContextThread();
                    if (bl5) {
                        Assert.assertEquals((Object)thread, (Object)threadArray[n5]);
                    } else {
                        Assert.assertEquals((Object)animatorBaseArray[n5].getThread(), (Object)threadArray[n5]);
                    }
                    Thread thread3 = gLAutoDrawableArray[n5].setExclusiveContextThread(null);
                    Assert.assertEquals((Object)threadArray[n5], (Object)thread3);
                }
                Thread.sleep(duration / 9L);
                for (n5 = 0; n5 < n; ++n5) {
                    int n6;
                    boolean bl6 = null == gLAutoDrawableArray[n5].getExclusiveContextThread();
                    for (n6 = 0; !bl6 && n6 < 250; ++n6) {
                        Thread.sleep(20L);
                        bl6 = null == gLAutoDrawableArray[n5].getExclusiveContextThread();
                    }
                    if (n6 > 0) {
                        System.err.println("Clearing drawable ECT was done 'later' @ " + n6 * 20 + "ms, ok " + bl6);
                    }
                    Assert.assertEquals((Object)true, (Object)bl6);
                    Thread thread4 = gLAutoDrawableArray[n5].setExclusiveContextThread(threadArray[n5]);
                    Assert.assertEquals(null, (Object)thread4);
                }
                Thread.sleep(duration / 9L);
                for (n5 = 0; n5 < n; ++n5) {
                    threadArray[n5] = animatorBaseArray[n5].getExclusiveContextThread();
                    if (bl5) {
                        Assert.assertEquals((Object)thread, (Object)threadArray[n5]);
                    } else {
                        Assert.assertEquals((Object)animatorBaseArray[n5].getThread(), (Object)threadArray[n5]);
                    }
                    Assert.assertEquals((Object)true, (Object)animatorBaseArray[n5].setExclusiveContext(false));
                    Assert.assertFalse((boolean)animatorBaseArray[n5].isExclusiveContextEnabled());
                    Assert.assertEquals(null, (Object)gLAutoDrawableArray[n5].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
                for (n5 = 0; n5 < n; ++n5) {
                    Assert.assertEquals(null, (Object)animatorBaseArray[n5].setExclusiveContext(threadArray[n5]));
                    Assert.assertTrue((boolean)animatorBaseArray[n5].isExclusiveContextEnabled());
                    Assert.assertEquals((Object)threadArray[n5], (Object)animatorBaseArray[n5].getExclusiveContextThread());
                    Assert.assertEquals((Object)threadArray[n5], (Object)gLAutoDrawableArray[n5].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
            }
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isAnimating());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isPaused());
                Assert.assertTrue((boolean)animatorBaseArray[n2].pause());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isPaused());
                Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
                if (bl) {
                    Thread thread5 = animatorBaseArray[n2].getExclusiveContextThread();
                    if (bl5) {
                        Assert.assertEquals((Object)thread, (Object)thread5);
                    } else {
                        Assert.assertEquals((Object)animatorBaseArray[n2].getThread(), (Object)thread5);
                    }
                } else {
                    Assert.assertEquals(null, (Object)animatorBaseArray[n2].getExclusiveContextThread());
                }
                Assert.assertEquals(null, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertTrue((boolean)animatorBaseArray[n2].resume());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isAnimating());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isPaused());
                Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
                if (bl) {
                    Thread thread6 = animatorBaseArray[n2].getExclusiveContextThread();
                    if (bl5) {
                        Assert.assertEquals((Object)thread, (Object)thread6);
                    } else {
                        Assert.assertEquals((Object)animatorBaseArray[n2].getThread(), (Object)thread6);
                    }
                    Assert.assertEquals((Object)thread6, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
                    continue;
                }
                Assert.assertEquals(null, (Object)animatorBaseArray[n2].getExclusiveContextThread());
                Assert.assertEquals(null, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertTrue((boolean)animatorBaseArray[n2].stop());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isPaused());
                Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
                Assert.assertEquals(null, (Object)animatorBaseArray[n2].getExclusiveContextThread());
                Assert.assertEquals(null, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertTrue((boolean)animatorBaseArray[n2].start());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isAnimating());
                Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
                Thread thread7 = animatorBaseArray[n2].getExclusiveContextThread();
                if (bl) {
                    if (bl5) {
                        Assert.assertEquals((Object)thread, (Object)thread7);
                    } else {
                        Assert.assertEquals((Object)animatorBaseArray[n2].getThread(), (Object)thread7);
                    }
                } else {
                    Assert.assertEquals(null, (Object)thread7);
                }
                Assert.assertEquals((Object)thread7, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (n2 = 0; n2 < n; ++n2) {
                GLAutoDrawable gLAutoDrawable = gLAutoDrawableArray[n2];
                animatorBaseArray[n2].remove(gLAutoDrawable);
                Assert.assertEquals(null, (Object)gLAutoDrawable.getExclusiveContextThread());
                Assert.assertTrue((boolean)animatorBaseArray[n2].isStarted());
                Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            Assert.assertTrue((boolean)animatorBaseArray[n2].stop());
            Assert.assertFalse((boolean)animatorBaseArray[n2].isAnimating());
            Assert.assertFalse((boolean)animatorBaseArray[n2].isStarted());
            Assert.assertFalse((boolean)animatorBaseArray[n2].isPaused());
            Assert.assertEquals((Object)bl, (Object)animatorBaseArray[n2].isExclusiveContextEnabled());
            Assert.assertEquals(null, (Object)animatorBaseArray[n2].getExclusiveContextThread());
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.destroyGLAutoDrawableVisible(gLAutoDrawableArray[n2]);
            Assert.assertEquals((Object)true, (Object)GLTestUtil.waitForRealized(gLAutoDrawableArray[n2], false, null));
        }
    }

    @Test
    public void test01NormalPre_1WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, true, false, false);
    }

    @Test
    public void test02NormalPost_1WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, false, false, true);
    }

    @Test
    public void test03ExclPre_1WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, true, false, false);
    }

    @Test
    public void test04ExclPost_1WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, false, false, true);
    }

    @Test
    public void test05NormalPre_4WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, true, false, false);
    }

    @Test
    public void test06NormalPost_4WinPostVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, false, false, true);
    }

    @Test
    public void test07ExclPre_4WinPostVis() throws InterruptedException {
        if (Platform.OSType.MACOS == Platform.getOSType()) {
            System.err.println("Disabled, see Bug 1415");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, true, false, false);
    }

    @Test
    public void test08ExclPost_4WinPostVis() throws InterruptedException {
        if (Platform.OSType.MACOS == Platform.getOSType()) {
            System.err.println("Disabled, see Bug 1415");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, false, false, true);
    }

    @Test
    public void test11NormalPre_1WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, true, true, false);
    }

    @Test
    public void test12NormalPost_1WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, false, true, true);
    }

    @Test
    public void test13ExclPre_1WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, true, true, false);
    }

    @Test
    public void test14ExclPost_1WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, false, true, true);
    }

    @Test
    public void test15NormalPre_4WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, true, true, false);
    }

    @Test
    public void test16NormalPost_4WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, false, true, true);
    }

    @Test
    public void test17ExclPre_4WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, true, true, false);
    }

    @Test
    public void test18ExclPost_4WinPreVis() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, false, true, true);
    }

    static {
        swapInterval = 0;
    }
}

