/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;

public abstract class GLContextDrawableSwitchBase1
extends UITestCase {
    static long duration = 1000L;
    static int width;
    static int height;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    static void setGLCanvasSize(final GLCanvas gLCanvas, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    gLCanvas.setMinimumSize(dimension);
                    gLCanvas.setPreferredSize(dimension);
                    gLCanvas.setSize(dimension);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setFrameVisible(final Frame frame) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void destroyFrame(final Frame frame) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private GLOffscreenAutoDrawable createGLOffscreenAutoDrawable(GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        return gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, n, n2);
    }

    protected static boolean validateOnOffscreenLayer(GLADType gLADType, GLADType gLADType2) {
        boolean bl;
        boolean bl2 = GLADType.GLCanvasOffscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType2;
        boolean bl3 = bl = GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOnscreen == gLADType2;
        if (bl2) {
            if (!JAWTUtil.isOffscreenLayerSupported()) {
                System.err.println("Platform doesn't support offscreen rendering.");
                return false;
            }
        } else if (bl && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform requires offscreen rendering.");
            return false;
        }
        return true;
    }

    protected void testGLADOneLifecycle(Screen screen, GLCapabilities gLCapabilities, GLADType gLADType, int n, int n2, GLEventListenerCounter gLEventListenerCounter, UITestCase.SnapshotGLEventListener snapshotGLEventListener, GLEventListenerState gLEventListenerState, GLEventListenerState[] gLEventListenerStateArray, GLAnimatorControl gLAnimatorControl) throws InterruptedException {
        long l;
        GLCanvas gLCanvas;
        Frame frame;
        System.err.println("GLAD Lifecycle.0 " + (Object)((Object)gLADType) + ", restoring " + (null != gLEventListenerState) + ", preserving " + (null != gLEventListenerStateArray));
        if (GLADType.GLCanvasOnscreen == gLADType) {
            if (JAWTUtil.isOffscreenLayerRequired()) {
                throw new InternalError("Platform requires offscreen rendering, but onscreen requested: " + (Object)((Object)gLADType));
            }
            frame = new Frame("AWT GLCanvas");
            gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            GLContextDrawableSwitchBase1.setGLCanvasSize(gLCanvas, new Dimension(n, n2));
            frame.add((Component)gLCanvas);
        } else if (GLADType.GLCanvasOffscreen == gLADType) {
            if (!JAWTUtil.isOffscreenLayerSupported()) {
                throw new InternalError("Platform doesn't support offscreen rendering: " + (Object)((Object)gLADType));
            }
            frame = new Frame("AWT GLCanvas");
            gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            gLCanvas.setShallUseOffscreenLayer(true);
            GLContextDrawableSwitchBase1.setGLCanvasSize(gLCanvas, new Dimension(n, n2));
            frame.add((Component)gLCanvas);
        } else if (GLADType.GLWindow == gLADType) {
            frame = null;
            gLCanvas = null != screen ? GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities) : GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            ((GLWindow)gLCanvas).setTitle("Newt GLWindow");
            ((GLWindow)gLCanvas).setSize(n, n2);
        } else if (GLADType.GLOffscreen == gLADType) {
            frame = null;
            gLCanvas = this.createGLOffscreenAutoDrawable(gLCapabilities, n, n2);
        } else {
            throw new InternalError("Unsupported: " + (Object)((Object)gLADType));
        }
        if (null == gLEventListenerState) {
            if (null != gLAnimatorControl) {
                gLAnimatorControl.add((GLAutoDrawable)gLCanvas);
            }
            gLCanvas.addGLEventListener((GLEventListener)gLEventListenerCounter);
            gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
            gLCanvas.addGLEventListener((GLEventListener)snapshotGLEventListener);
        }
        snapshotGLEventListener.setMakeSnapshot();
        if (GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType) {
            GLContextDrawableSwitchBase1.setFrameVisible(frame);
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true, null));
        } else if (GLADType.GLWindow == gLADType) {
            ((GLWindow)gLCanvas).setVisible(true);
        }
        Assert.assertEquals((Object)true, (Object)GLTestUtil.waitForRealized((GLAutoDrawable)gLCanvas, true, null));
        Assert.assertNotNull((Object)gLCanvas.getContext());
        Assert.assertTrue((boolean)gLCanvas.isRealized());
        if (null != gLEventListenerState) {
            Assert.assertEquals((long)0L, (long)gLCanvas.getGLEventListenerCount());
            System.err.println(".. restoring.0");
            gLEventListenerState.moveTo((GLAutoDrawable)gLCanvas);
            System.err.println(".. restoring.X");
            Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
            Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
            Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
            Assert.assertEquals((long)3L, (long)gLCanvas.getGLEventListenerCount());
            Assert.assertEquals((Object)gLEventListenerState.context, (Object)gLCanvas.getContext());
            Assert.assertEquals((long)gLEventListenerState.listenerCount(), (long)gLCanvas.getGLEventListenerCount());
            Assert.assertEquals((Object)gLEventListenerState.context.getGLReadDrawable(), (Object)gLCanvas.getDelegatedDrawable());
            Assert.assertEquals((Object)gLEventListenerState.context.getGLDrawable(), (Object)gLCanvas.getDelegatedDrawable());
            Assert.assertEquals((Object)false, (Object)gLEventListenerState.isOwner());
        }
        for (int i = 0; i < 20 && (1 > gLEventListenerCounter.initCount || 1 > gLEventListenerCounter.reshapeCount || 1 > gLEventListenerCounter.displayCount); ++i) {
            Thread.sleep(100L);
        }
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        if (null != gLEventListenerStateArray) {
            GLContext gLContext = gLCanvas.getContext();
            System.err.println(".. preserving.0");
            gLEventListenerStateArray[0] = GLEventListenerState.moveFrom((GLAutoDrawable)gLCanvas);
            System.err.println(".. preserving.X");
            Assert.assertEquals((Object)gLContext, (Object)gLEventListenerStateArray[0].context);
            Assert.assertNull((Object)gLContext.getGLReadDrawable());
            Assert.assertNull((Object)gLContext.getGLDrawable());
            Assert.assertEquals((long)3L, (long)gLEventListenerStateArray[0].listenerCount());
            Assert.assertEquals((Object)true, (Object)gLEventListenerStateArray[0].isOwner());
            Assert.assertEquals(null, (Object)gLCanvas.getContext());
            Assert.assertEquals((long)0L, (long)gLCanvas.getGLEventListenerCount());
        }
        if (GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType) {
            GLContextDrawableSwitchBase1.destroyFrame(frame);
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, false, null));
        } else if (GLADType.GLWindow == gLADType) {
            gLCanvas.destroy();
        } else if (GLADType.GLOffscreen == gLADType) {
            gLCanvas.destroy();
        }
        Assert.assertEquals((Object)true, (Object)GLTestUtil.waitForRealized((GLAutoDrawable)gLCanvas, false, null));
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        if (null != gLEventListenerStateArray) {
            Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals((long)1L, (long)gLEventListenerCounter.disposeCount);
        }
        System.err.println("GLAD Lifecycle.X " + (Object)((Object)gLADType));
    }

    protected static enum GLADType {
        GLCanvasOnscreen,
        GLCanvasOffscreen,
        GLWindow,
        GLOffscreen;

    }
}

