/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.SurfaceScaleUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAWT03GLJPanelRecreate01
extends UITestCase {
    static long durationPerTest = 500L;
    static final int sizeEps = 64;
    static final Dimension size1 = new Dimension(512, 447);
    static final Dimension size2 = new Dimension(833, 768);
    static final Dimension size3 = new Dimension(256, 191);
    JFrame frame1 = null;
    JFrame frame2 = null;
    JFrame frame3 = null;
    GLJPanel glComp = null;
    JLabel label1 = null;
    JLabel label2 = null;
    JLabel label3 = null;
    Animator animator = null;

    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    @Before
    public void init() {
        this.glComp = new GLJPanel();
        Assert.assertNotNull((Object)this.glComp);
        this.glComp.addGLEventListener((GLEventListener)new GearsES2());
        this.animator = new Animator((GLAutoDrawable)this.glComp);
        this.animator.start();
        this.label1 = new JLabel("L1 - No GLJPanel");
        this.label1.setMinimumSize(size1);
        this.label1.setPreferredSize(size1);
        this.frame1 = new JFrame("Frame 1");
        Assert.assertNotNull((Object)this.frame1);
        this.frame1.add(this.label1);
        this.frame1.setLocation(0, 0);
        this.label2 = new JLabel("L2 - No GLJPanel");
        this.label2.setMinimumSize(size2);
        this.label2.setPreferredSize(size2);
        this.frame2 = new JFrame("Frame 2");
        Assert.assertNotNull((Object)this.frame2);
        this.frame2.add(this.label2);
        this.frame2.setLocation(TestAWT03GLJPanelRecreate01.size1.width, 0);
        this.label3 = new JLabel("L3 - No GLJPanel");
        this.label3.setMinimumSize(size3);
        this.label3.setPreferredSize(size3);
        this.frame3 = new JFrame("Frame 3");
        Assert.assertNotNull((Object)this.frame3);
        this.frame3.add(this.label3);
        this.frame3.setLocation(0, TestAWT03GLJPanelRecreate01.size1.height);
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.frame1);
        Assert.assertNotNull((Object)this.frame2);
        Assert.assertNotNull((Object)this.glComp);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestAWT03GLJPanelRecreate01.this.glComp.destroy();
                    TestAWT03GLJPanelRecreate01.this.frame1.dispose();
                    TestAWT03GLJPanelRecreate01.this.frame2.dispose();
                    TestAWT03GLJPanelRecreate01.this.frame3.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.frame1 = null;
        this.frame2 = null;
        this.frame3 = null;
        this.glComp = null;
        this.animator.stop();
        this.animator = null;
    }

    private void addCanvas(final JFrame jFrame, final JLabel jLabel, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.getContentPane().remove(jLabel);
                    TestAWT03GLJPanelRecreate01.this.glComp.setPreferredSize(dimension);
                    TestAWT03GLJPanelRecreate01.this.glComp.setMinimumSize(dimension);
                    jFrame.getContentPane().add((Component)TestAWT03GLJPanelRecreate01.this.glComp, "Center");
                    jFrame.pack();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private void removeCanvas(final JFrame jFrame, final JLabel jLabel) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.getContentPane().remove((Component)TestAWT03GLJPanelRecreate01.this.glComp);
                    jFrame.getContentPane().add(jLabel);
                    jFrame.pack();
                    jFrame.repaint();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private void setVisible(final JFrame jFrame, final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.pack();
                    jFrame.setVisible(bl);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private void assertSize(Dimension dimension) {
        float[] fArray = new float[]{1.0f, 1.0f};
        this.glComp.getMaximumSurfaceScale(fArray);
        Dimension dimension2 = this.glComp.getSize(null);
        Assert.assertTrue((String)("AWT Size.width mismatch: expected " + dimension + ", has " + dimension2), (Math.abs(dimension.width - dimension2.width) <= 64 ? 1 : 0) != 0);
        Assert.assertTrue((String)("AWT Size.height mismatch: expected " + dimension + ", has " + dimension2), (Math.abs(dimension.height - dimension2.height) <= 64 ? 1 : 0) != 0);
        int n = SurfaceScaleUtils.scale((int)dimension.width, (float)fArray[0]);
        int n2 = SurfaceScaleUtils.scale((int)dimension.height, (float)fArray[0]);
        int n3 = this.glComp.getSurfaceWidth();
        int n4 = this.glComp.getSurfaceHeight();
        Assert.assertTrue((String)("GL Size.width mismatch: expected " + n + ", has " + n3), (Math.abs(n - n3) <= 64 ? 1 : 0) != 0);
        Assert.assertTrue((String)("GL Size.height mismatch: expected " + n2 + ", has " + n4), (Math.abs(n2 - n4) <= 64 ? 1 : 0) != 0);
    }

    @Test
    public void testAddRemove3Times() throws InterruptedException {
        this.setVisible(this.frame1, true);
        this.setVisible(this.frame2, true);
        this.setVisible(this.frame3, true);
        this.addCanvas(this.frame1, this.label1, size1);
        Thread.sleep(durationPerTest);
        this.assertSize(size1);
        this.removeCanvas(this.frame1, this.label1);
        this.addCanvas(this.frame2, this.label2, size2);
        Thread.sleep(durationPerTest);
        this.assertSize(size2);
        this.removeCanvas(this.frame2, this.label2);
        this.addCanvas(this.frame3, this.label3, size3);
        Thread.sleep(durationPerTest);
        this.assertSize(size3);
        this.removeCanvas(this.frame3, this.label3);
        this.addCanvas(this.frame1, this.label1, size1);
        Thread.sleep(durationPerTest);
        this.assertSize(size1);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestAWT03GLJPanelRecreate01.class.getName()});
    }
}

