/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1225EventQueueInterruptedAWT
extends UITestCase {
    static long durationPerTest = 1000L;

    private void setVisible(final JFrame jFrame, final boolean bl) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.setVisible(bl);
            }
        });
    }

    private void dispose(final JFrame jFrame) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.dispose();
            }
        });
    }

    @Test(timeout=180000L)
    public void test01_NoGL() throws InterruptedException, InvocationTargetException {
        this.testImpl(false);
    }

    @Test(timeout=180000L)
    public void test02_WithGL() throws InterruptedException, InvocationTargetException {
        this.testImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testImpl(boolean bl) throws InterruptedException, InvocationTargetException {
        InterruptableGLEL interruptableGLEL;
        Object object;
        GLCanvas gLCanvas;
        if (!AWTRobotUtil.isAWTEDTAlive()) {
            System.err.println("Test aborted: AWT not alive");
            return;
        }
        OurUncaughtExceptionHandler ourUncaughtExceptionHandler = new OurUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(ourUncaughtExceptionHandler);
        Dimension dimension = new Dimension(800, 400);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        if (bl) {
            gLCanvas = new GLCanvas();
            object = new GearsES2();
            ((GearsES2)object).setVerbose(false);
            gLCanvas.addGLEventListener((GLEventListener)object);
            interruptableGLEL = new InterruptableGLEL();
            gLCanvas.addGLEventListener((GLEventListener)interruptableGLEL);
            gLCanvas.setSize(dimension);
            gLCanvas.setPreferredSize(dimension);
            jPanel.add((Component)gLCanvas);
        } else {
            NativeWindowFactory.initSingleton();
            gLCanvas = null;
            interruptableGLEL = null;
            object = new Label("No GL Object");
            ((Component)object).setSize(dimension);
            ((Component)object).setPreferredSize(dimension);
            jPanel.add((Component)object);
        }
        object = new InterruptingComponent();
        jPanel.add((Component)object);
        ((Component)object).setSize(dimension);
        ((Component)object).setPreferredSize(dimension);
        JFrame jFrame = new JFrame();
        jFrame.setResizable(true);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)jPanel, "Center");
        this.setVisible(jFrame, true);
        if (bl) {
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)gLCanvas, true, null));
        }
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized((Component)object, true, null));
        InterruptableLoop interruptableLoop = new InterruptableLoop((InterruptingComponent)object, gLCanvas);
        Thread thread = new Thread(interruptableLoop);
        InterruptableLoop interruptableLoop2 = interruptableLoop;
        synchronized (interruptableLoop2) {
            thread.start();
            try {
                interruptableLoop.notifyAll();
                while (!interruptableLoop.isRunning && !interruptableLoop.shallStop) {
                    interruptableLoop.wait();
                }
                interruptableLoop.ack = true;
                interruptableLoop.notifyAll();
            }
            catch (InterruptedException interruptedException) {
                Assert.assertNull((String)"while starting loop", (Object)new InterruptedRuntimeException(interruptedException));
            }
        }
        for (int i = 0; thread.isAlive() && null == interruptableLoop.exception && null == ourUncaughtExceptionHandler.exception && i < 100; ++i) {
            ((InterruptingComponent)object).interruptAWTEventQueue();
            Thread.sleep(durationPerTest / 100L);
        }
        interruptableLoop.shallStop = true;
        InterruptableLoop interruptableLoop3 = interruptableLoop;
        synchronized (interruptableLoop3) {
            try {
                interruptableLoop.notifyAll();
                while (interruptableLoop.isRunning) {
                    interruptableLoop.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                Assert.assertNull((String)"while stopping loop", (Object)new InterruptedRuntimeException(interruptedException));
            }
        }
        if (null != interruptableGLEL && null != interruptableGLEL.exception) {
            ExceptionUtils.dumpThrowable((String)"GLEventListener", (Throwable)interruptableGLEL.exception);
        }
        if (null != ((InterruptingComponent)object).exception) {
            ExceptionUtils.dumpThrowable((String)"InterruptingComponent", (Throwable)((InterruptingComponent)object).exception);
        }
        if (null != interruptableLoop.exception) {
            ExceptionUtils.dumpThrowable((String)"loop", (Throwable)interruptableLoop.exception);
        }
        if (null != ourUncaughtExceptionHandler.exception) {
            ExceptionUtils.dumpThrowable((String)"uncaughtHandler", (Throwable)ourUncaughtExceptionHandler.exception);
        }
        if (!AWTRobotUtil.isAWTEDTAlive()) {
            System.err.println("AWT is not alive anymore!!! Ooops");
        } else {
            this.dispose(jFrame);
        }
        Assert.assertNull((String)"Caught Exception in loop", (Object)interruptableLoop.exception);
        Assert.assertNull((String)"Caught Exception via uncaughtHandler", (Object)ourUncaughtExceptionHandler.exception);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestBug1225EventQueueInterruptedAWT.class.getName()});
    }

    class OurUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public volatile Thread thread = null;
        public volatile Throwable exception = null;

        OurUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.thread = thread;
            this.exception = throwable;
            System.err.println("*** UncaughtException (this Thread " + Thread.currentThread().getName() + ") : Thread <" + thread.getName() + ">, " + throwable.getClass().getName() + ": " + throwable.getMessage());
            ExceptionUtils.dumpThrowable((String)"", (Throwable)throwable);
        }
    }

    static class InterruptableGLEL
    implements GLEventListener {
        public volatile InterruptedException exception = null;

        InterruptableGLEL() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Thread thread = Thread.currentThread();
            if (thread.isInterrupted() && null == this.exception) {
                this.exception = new InterruptedException("Interrupt detected in GLEventListener, thread: " + thread.getName());
                gLAutoDrawable.removeGLEventListener((GLEventListener)this);
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }

    static class InterruptingComponent
    extends Component {
        private static final long serialVersionUID = 1L;
        public volatile InterruptedException exception = null;
        private volatile boolean doInterrupt = false;
        private final Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY};
        private int colorIdx = 0;

        public void interruptAWTEventQueue() {
            this.doInterrupt = true;
        }

        @Override
        public void paint(Graphics graphics) {
            Thread thread = Thread.currentThread();
            if (thread.isInterrupted() && null == this.exception) {
                this.exception = new InterruptedException("Interrupt detected in AWT Component, thread: " + thread.getName());
            }
            graphics.setColor(this.colors[this.colorIdx++]);
            if (this.colorIdx >= this.colors.length) {
                this.colorIdx = 0;
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.doInterrupt) {
                System.err.println("Thread " + thread.getName() + ": *Interrupting*");
                this.doInterrupt = false;
                thread.interrupt();
            }
        }
    }

    static class InterruptableLoop
    implements Runnable {
        public volatile Exception exception = null;
        public volatile boolean shallStop = false;
        public volatile boolean isRunning = false;
        public volatile boolean ack = false;
        final InterruptingComponent icomp;
        final GLCanvas glc;
        boolean alt = false;

        InterruptableLoop(InterruptingComponent interruptingComponent, GLCanvas gLCanvas) {
            this.icomp = interruptingComponent;
            this.glc = gLCanvas;
        }

        public void stop() {
            this.shallStop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InterruptableLoop interruptableLoop = this;
            synchronized (interruptableLoop) {
                this.isRunning = true;
                this.notifyAll();
                try {
                    while (!this.ack) {
                        this.wait();
                    }
                    this.notifyAll();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                this.ack = false;
            }
            interruptableLoop = this;
            synchronized (interruptableLoop) {
                try {
                    while (!this.shallStop) {
                        if (this.alt) {
                            this.icomp.repaint();
                        } else if (null != this.glc) {
                            this.glc.repaint();
                        }
                        this.alt = !this.alt;
                        Thread.sleep(16L);
                        if (!Thread.interrupted()) continue;
                        InterruptedRuntimeException interruptedRuntimeException = new InterruptedRuntimeException(new InterruptedException("Interrupt detected in loop, thread: " + Thread.currentThread().getName()));
                        throw interruptedRuntimeException;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.exception = SourcedInterruptedException.wrap((InterruptedException)interruptedException);
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)this.exception);
                }
                catch (Exception exception) {
                    this.exception = exception;
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)this.exception);
                }
                finally {
                    this.isRunning = false;
                    this.notifyAll();
                }
            }
        }
    }
}

