/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug1245JTabbedPanelCrashAWT
extends UITestCase {
    static long durationPerTest = 2000L;
    static boolean manual = false;
    final GLEventListenerCounter glelCounter = new GLEventListenerCounter();

    private JTabbedPane createAndShowGUI(JFrame jFrame, final View3D[] view3DArray) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        final JTabbedPane jTabbedPane = new JTabbedPane();
        for (int i = 0; i < view3DArray.length; ++i) {
            Object object;
            Object object2;
            if (i % 2 == 0) {
                object2 = new GearsES2(1);
                ((GearsES2)object2).setVerbose(false);
                object = object2;
            } else {
                object2 = new RedSquareES2(1);
                ((RedSquareES2)object2).setVerbose(false);
                object = object2;
            }
            view3DArray[i] = new View3D(i);
            view3DArray[i].canvas.addGLEventListener((GLEventListener)this.glelCounter);
            view3DArray[i].canvas.addGLEventListener((GLEventListener)object);
            jTabbedPane.addTab("Tab " + i, null, view3DArray[i], "Does nothing");
        }
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jTabbedPane.getSelectedIndex();
                if (0 <= n && n < view3DArray.length) {
                    System.err.println("Pane[" + n + "]: State Changed: " + changeEvent);
                    System.err.println("Pane[" + n + "]: " + view3DArray[n].getGLCanvasStats());
                }
            }
        });
        jPanel.add(jTabbedPane);
        jFrame.add((Component)jPanel, "Center");
        jFrame.setSize(640, 480);
        return jTabbedPane;
    }

    private static String id(Object object) {
        return "0x" + Integer.toHexString(object.hashCode());
    }

    @BeforeClass
    public static void startup() {
        GLProfile.initSingleton();
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame("Java3DApplication");
        jFrame.setDefaultCloseOperation(3);
        final View3D[] view3DArray = new View3D[4];
        final JTabbedPane[] jTabbedPaneArray = new JTabbedPane[]{null};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                jTabbedPaneArray[0] = TestBug1245JTabbedPanelCrashAWT.this.createAndShowGUI(jFrame, view3DArray);
                System.err.println("XXX SetVisible ON XXX");
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true, null));
        for (int i = 0; i < view3DArray.length; ++i) {
            System.err.printf("View " + i + ": " + view3DArray[i] + ",%n       " + view3DArray[i].getGLCanvasStats() + "%n%n", new Object[0]);
        }
        System.err.println("XXX POST.VISIBLE: " + this.glelCounter);
        if (manual) {
            Thread.sleep(durationPerTest);
            System.err.println("XXX POST.ACTION: " + this.glelCounter);
        } else {
            JTabbedPane jTabbedPane = jTabbedPaneArray[0];
            for (int i = 0; i < view3DArray.length; ++i) {
                Thread.sleep(durationPerTest / (long)view3DArray.length);
                this.switchTab(jTabbedPane, view3DArray, i, (i + 1) % view3DArray.length);
            }
            Thread.sleep(durationPerTest / (long)view3DArray.length);
            this.switchTab(jTabbedPane, view3DArray, 0, 1);
            Thread.sleep(durationPerTest / (long)view3DArray.length);
            this.switchTab(jTabbedPane, view3DArray, 1, 0);
            System.err.println("XXX POST.ACTION: " + this.glelCounter);
            Assert.assertTrue((this.glelCounter.initCount >= view3DArray.length ? 1 : 0) != 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.err.println("XXX SetVisible OFF XXX");
                jFrame.dispose();
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, false, null));
        System.err.println("XXX POST.DISPOSE: " + this.glelCounter);
    }

    void switchTab(final JTabbedPane jTabbedPane, final View3D[] view3DArray, final int n, final int n2) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("XXXX Panel(" + TestBug1245JTabbedPanelCrashAWT.id(view3DArray[n]) + " -> Panel(" + TestBug1245JTabbedPanelCrashAWT.id(view3DArray[n2]) + ") START");
                jTabbedPane.setSelectedIndex(n2);
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        JUnitCore.main((String[])new String[]{TestBug1245JTabbedPanelCrashAWT.class.getName()});
    }

    static class View3D
    extends JPanel {
        final GLCanvas canvas;
        final Animator animator;
        final int num;

        public View3D(int n) {
            this.num = n;
            this.setLayout(new BorderLayout());
            this.canvas = new GLCanvas();
            this.canvas.setSize(new Dimension(100, 100));
            this.canvas.setMinimumSize(new Dimension(100, 100));
            this.add((Component)this.canvas, "Center");
            this.animator = new Animator();
            this.animator.add((GLAutoDrawable)this.canvas);
        }

        @Override
        public void addNotify() {
            System.err.println("View3D[" + this.num + "].addNotify()");
            super.addNotify();
            if (null != this.animator) {
                this.animator.start();
            }
        }

        @Override
        public void removeNotify() {
            System.err.println("View3D[" + this.num + "].removeNotify()");
            if (null != this.animator) {
                this.animator.stop();
            }
            super.removeNotify();
        }

        public String getGLCanvasStats() {
            return "GLCanvas: comp " + this.canvas.getBounds() + ", visible " + this.canvas.isVisible() + ", showing " + this.canvas.isShowing() + ", displayable " + this.canvas.isDisplayable() + ", " + this.canvas.getSurfaceWidth() + "x" + this.canvas.getSurfaceHeight() + ", " + this.canvas.getChosenGLCapabilities() + ", drawable 0x" + Long.toHexString(this.canvas.getHandle());
        }
    }
}

