/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug572AWT
extends UITestCase {
    static long durationPerTest = 150L;

    private void testRealizeGLCanvas(boolean bl, final boolean bl2) throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame(this.getSimpleTestName(" - "));
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setMakeSnapshotAlways(true);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2());
        gLCanvas.addGLEventListener((GLEventListener)snapshotGLEventListener);
        jFrame.add((Component)gLCanvas);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (bl2) {
                    jFrame.setSize(512, 512);
                    jFrame.validate();
                } else {
                    Dimension dimension = new Dimension(512, 512);
                    gLCanvas.setPreferredSize(dimension);
                    gLCanvas.setMinimumSize(dimension);
                    jFrame.pack();
                }
                jFrame.setVisible(true);
            }
        };
        if (bl) {
            SwingUtilities.invokeAndWait(runnable);
        } else {
            runnable.run();
            Assert.assertTrue((String)"GLCanvas didn't become visible", (boolean)AWTRobotUtil.waitForVisible((Component)gLCanvas, true, null));
            Assert.assertTrue((String)"GLCanvas didn't become realized", (boolean)AWTRobotUtil.waitForRealized((Component)gLCanvas, true, null));
        }
        System.err.println("XXXX-0 " + gLCanvas.getDelegatedDrawable().isRealized() + ", " + gLCanvas);
        Assert.assertTrue((String)"GLCanvas didn't become displayable", (boolean)gLCanvas.isDisplayable());
        Assert.assertTrue((String)"GLCanvas didn't become realized", (boolean)gLCanvas.isRealized());
        System.err.println("XXXX-1 reshapeCount " + snapshotGLEventListener.getReshapeCount());
        System.err.println("XXXX-1 displayCount " + snapshotGLEventListener.getDisplayCount());
        for (int i = 0; i < 20 && (0 == snapshotGLEventListener.getReshapeCount() || 0 == snapshotGLEventListener.getDisplayCount()); ++i) {
            Thread.sleep(100L);
        }
        System.err.println("XXXX-2 reshapeCount " + snapshotGLEventListener.getReshapeCount());
        System.err.println("XXXX-2 displayCount " + snapshotGLEventListener.getDisplayCount());
        Assert.assertTrue((String)"GLCanvas didn't reshape", (snapshotGLEventListener.getReshapeCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"GLCanvas didn't display", (snapshotGLEventListener.getDisplayCount() > 0 ? 1 : 0) != 0);
        Thread.sleep(durationPerTest);
        SwingUtilities.invokeAndWait(new Cleanup(jFrame));
    }

    @Test(timeout=10000L)
    public void test01RealizeGLCanvasOnAWTEDTUseFrameSize() throws InterruptedException, InvocationTargetException {
        this.testRealizeGLCanvas(true, true);
    }

    @Test(timeout=10000L)
    public void test02RealizeGLCanvasOnAWTEDTUseGLCanvasSize() throws InterruptedException, InvocationTargetException {
        this.testRealizeGLCanvas(true, false);
    }

    @Test(timeout=10000L)
    public void test11RealizeGLCanvasOnMainTUseFrameSize() throws InterruptedException, InvocationTargetException {
        this.testRealizeGLCanvas(false, true);
    }

    @Test(timeout=10000L)
    public void test12RealizeGLCanvasOnMainTUseGLCanvasSize() throws InterruptedException, InvocationTargetException {
        this.testRealizeGLCanvas(false, false);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug572AWT.class.getName()});
    }

    static class Cleanup
    implements Runnable {
        Window window;

        public Cleanup(Window window) {
            this.window = window;
        }

        @Override
        public void run() {
            System.err.println("cleaning up...");
            this.window.setVisible(false);
            try {
                this.window.removeAll();
            }
            catch (Throwable throwable) {
                Assume.assumeNoException((Throwable)throwable);
                throwable.printStackTrace();
            }
            this.window.dispose();
        }
    }
}

